/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.kickstart.tools.resolver.FieldResolverError;
import graphql.kickstart.tools.resolver.MissingResolverDataFetcherProvider;
import graphql.language.FieldDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLSchema;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002\b\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\b\u0010\u0007\u001a\u00020\u0005H\u0007\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/MissingFieldResolverTest;", "", "<init>", "()V", "should throw error when a field is missing", "", "should call missing resolver data fetcher if provided", "should call missing resolver data fetcher provider if provided", "TestMissingResolverDataFetcher", "TestMissingResolverDataFetcherProvider", "graphql-java-tools"})
public final class MissingFieldResolverTest {
    @Test(expected=FieldResolverError.class)
    public final void should throw error when a field is missing() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

            public final String implementedField(Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
        }};
        SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    implementedField(input: String): String\n                    missingField(input: Int): Int\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
    }

    @Test
    public final void should call missing resolver data fetcher if provided() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

            public final String implementedField(Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
        }};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    implementedField(input: String): String\n                    missingField(input: Int): Int\n                }\n                ").resolvers(graphQLResolverArray).options(SchemaParserOptions.Companion.newOptions().missingResolverDataFetcher((DataFetcher)new TestMissingResolverDataFetcher()).build()).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute("\n            query {\n                implementedField(input: \"test-value\")\n                missingField(input: 1)\n            }\n            ");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"implementedField", (Object)"Optional[test-value]"), TuplesKt.to((Object)"missingField", (Object)1)};
        Map expected = MapsKt.mapOf((Pair[])pairArray);
        TestUtilsKt.assertEquals(result.getData(), expected);
    }

    @Test
    public final void should call missing resolver data fetcher provider if provided() {
        TestMissingResolverDataFetcherProvider missingResolverDataFetcherProvider = new TestMissingResolverDataFetcherProvider();
        SchemaParserOptions options = SchemaParserOptions.Companion.newOptions().missingResolverDataFetcherProvider((MissingResolverDataFetcherProvider)missingResolverDataFetcherProvider).build();
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

            public final String implementedField(Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
        }};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    implementedField(input: String): String\n                    missingField(input: Int): Int\n                }\n                ").resolvers(graphQLResolverArray).options(options).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute("\n            query {\n                implementedField(input: \"test-value\")\n                missingField(input: 1)\n            }\n            ");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"implementedField", (Object)"Optional[test-value]"), TuplesKt.to((Object)"missingField", (Object)1)};
        Map expected = MapsKt.mapOf((Pair[])pairArray);
        TestUtilsKt.assertEquals(result.getData(), expected);
        FieldDefinition fieldDefinition = missingResolverDataFetcherProvider.getField();
        TestUtilsKt.assertEquals(fieldDefinition != null ? fieldDefinition.getName() : null, "missingField");
        TestUtilsKt.assertEquals(missingResolverDataFetcherProvider.getOptions(), options);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0096\u0002\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/MissingFieldResolverTest$TestMissingResolverDataFetcher;", "Lgraphql/schema/DataFetcher;", "", "<init>", "()V", "get", "env", "Lgraphql/schema/DataFetchingEnvironment;", "graphql-java-tools"})
    public static final class TestMissingResolverDataFetcher
    implements DataFetcher<Object> {
        @Nullable
        public Object get(@Nullable DataFetchingEnvironment env) {
            DataFetchingEnvironment dataFetchingEnvironment = env;
            return dataFetchingEnvironment != null ? dataFetchingEnvironment.getArgument("input") : null;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lgraphql/kickstart/tools/MissingFieldResolverTest$TestMissingResolverDataFetcherProvider;", "Lgraphql/kickstart/tools/resolver/MissingResolverDataFetcherProvider;", "<init>", "()V", "field", "Lgraphql/language/FieldDefinition;", "getField", "()Lgraphql/language/FieldDefinition;", "setField", "(Lgraphql/language/FieldDefinition;)V", "options", "Lgraphql/kickstart/tools/SchemaParserOptions;", "getOptions", "()Lgraphql/kickstart/tools/SchemaParserOptions;", "setOptions", "(Lgraphql/kickstart/tools/SchemaParserOptions;)V", "createDataFetcher", "Lgraphql/schema/DataFetcher;", "graphql-java-tools"})
    public static final class TestMissingResolverDataFetcherProvider
    implements MissingResolverDataFetcherProvider {
        @Nullable
        private FieldDefinition field;
        @Nullable
        private SchemaParserOptions options;

        @Nullable
        public final FieldDefinition getField() {
            return this.field;
        }

        public final void setField(@Nullable FieldDefinition fieldDefinition) {
            this.field = fieldDefinition;
        }

        @Nullable
        public final SchemaParserOptions getOptions() {
            return this.options;
        }

        public final void setOptions(@Nullable SchemaParserOptions schemaParserOptions) {
            this.options = schemaParserOptions;
        }

        @NotNull
        public DataFetcher<?> createDataFetcher(@NotNull FieldDefinition field, @NotNull SchemaParserOptions options) {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)options, (String)"options");
            this.field = field;
            this.options = options;
            return new TestMissingResolverDataFetcher();
        }
    }
}

