/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.ExceptionWhileDataFetching;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.kickstart.tools.EndToEndSpecHelperKt;
import graphql.kickstart.tools.Item;
import graphql.kickstart.tools.MockPart;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.kickstart.tools.Type;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLTypeVisitorStub;
import graphql.schema.SchemaTransformer;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.reactivestreams.tck.TestEnvironment;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b'\u0018\u00002\u00020\u0001:\u0001/B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\tH\u0007J\b\u0010\u000b\u001a\u00020\tH\u0007J\b\u0010\f\u001a\u00020\tH\u0007J\b\u0010\r\u001a\u00020\tH\u0007J\b\u0010\u000e\u001a\u00020\tH\u0007J\b\u0010\u000f\u001a\u00020\tH\u0007J\b\u0010\u0010\u001a\u00020\tH\u0007J\b\u0010\u0011\u001a\u00020\tH\u0007J\b\u0010\u0012\u001a\u00020\tH\u0007J\b\u0010\u0013\u001a\u00020\tH\u0007J\b\u0010\u0014\u001a\u00020\tH\u0007J\b\u0010\u0015\u001a\u00020\tH\u0007J\b\u0010\u0016\u001a\u00020\tH\u0007J\b\u0010\u0017\u001a\u00020\tH\u0007J\b\u0010\u0018\u001a\u00020\tH\u0007J\b\u0010\u0019\u001a\u00020\tH\u0007J\b\u0010\u001a\u001a\u00020\tH\u0007J\b\u0010\u001b\u001a\u00020\tH\u0007J\b\u0010\u001c\u001a\u00020\tH\u0007J\b\u0010\u001d\u001a\u00020\tH\u0007J\b\u0010\u001e\u001a\u00020\tH\u0007J\b\u0010\u001f\u001a\u00020\tH\u0007J\b\u0010 \u001a\u00020\tH\u0007J\b\u0010!\u001a\u00020\tH\u0007J\b\u0010\"\u001a\u00020\tH\u0007J\b\u0010#\u001a\u00020\tH\u0007J\b\u0010$\u001a\u00020\tH\u0007J\b\u0010%\u001a\u00020\tH\u0007J\b\u0010&\u001a\u00020\tH\u0007J\b\u0010'\u001a\u00020\tH\u0007J\b\u0010(\u001a\u00020\tH\u0007J\b\u0010)\u001a\u00020\tH\u0007J\b\u0010*\u001a\u00020\tH\u0007J\b\u0010+\u001a\u00020\tH\u0007J\b\u0010,\u001a\u00020\tH\u0007J\b\u0010-\u001a\u00020\tH\u0007J\b\u0010.\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lgraphql/kickstart/tools/EndToEndTest;", "", "<init>", "()V", "schema", "Lgraphql/schema/GraphQLSchema;", "gql", "Lgraphql/GraphQL;", "schema comments are used as descriptions", "", "generated schema should respond to simple queries", "generated schema should respond to simple mutations", "generated schema should execute the subscription query", "generated schema should execute the subscription query future", "generated schema should handle interface types", "generated schema should handle union types", "generated schema should handle nested union types", "generated schema should handle scalar types", "generated schema should handle union types with deep hierarchy", "generated schema should handle non nullable scalar types", "generated schema should handle any Map (using HashMap) types as property maps", "generated schema should handle any Map (using SortedMap) types as property maps", "generated schema should handle Map types as property maps when containing complex data", "property map returns null when a property is not defined", "generated schema should continue to associate resolvers for transitive types of a Map complex data type", "generated schema should handle optional arguments", "generated schema should handle optional arguments using Optional", "generated schema should handle optional return types using Optional", "generated schema should pass default arguments", "introspection shouldn't fail for arguments of type list with a default value (defaultEnumListArgument)", "generated schema should return null without errors for null value with nested fields", "generated schema handles nested lists in input type fields", "generated schema should use type extensions", "generated schema uses properties if no methods are found", "generated schema allows enums in input types", "generated schema works with custom scalars as input values", "generated schema should handle extended input types", "generated schema supports generic properties", "generated schema supports overriding built-in scalars", "generated schema supports DataFetcherResult", "generated schema supports list of DataFetcherResult", "generated schema supports Kotlin suspend functions", "generated schema supports Kotlin coroutine channels for the subscription query", "generated schema supports Kotlin coroutine channels with suspend function for the subscription query", "generated schema supports arrays", "generated schema should re-throw original runtime exception when executing a resolver method", "transformed schema should execute query", "Transformer", "graphql-java-tools"})
@SourceDebugExtension(value={"SMAP\nEndToEndTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndToEndTest.kt\ngraphql/kickstart/tools/EndToEndTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,749:1\n1#2:750\n*E\n"})
public final class EndToEndTest {
    @NotNull
    private final GraphQLSchema schema = EndToEndSpecHelperKt.createSchema();
    @NotNull
    private final GraphQL gql;

    public EndToEndTest() {
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)this.schema).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQL, (String)"build(...)");
        this.gql = graphQL;
    }

    @Test
    public final void schema comments are used as descriptions() {
        Object v1;
        block3: {
            List list = this.schema.getAllTypesAsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllTypesAsList(...)");
            Iterable iterable = list;
            for (Object t : iterable) {
                GraphQLNamedType it = (GraphQLNamedType)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Type")) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type graphql.schema.GraphQLEnumType");
        GraphQLEnumType type = v1;
        boolean bl = Intrinsics.areEqual((Object)((GraphQLEnumValueDefinition)type.getValues().get(0)).getDescription(), (Object)"Item type 1");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = Intrinsics.areEqual((Object)((GraphQLEnumValueDefinition)type.getValues().get(1)).getDescription(), (Object)"Item type 2");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    public final void generated schema should respond to simple queries() {
        TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_respond_to_simple_queries$lambda$1, 6, null);
    }

    @Test
    public final void generated schema should respond to simple mutations() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"new1"), TuplesKt.to((Object)"type", (Object)Type.TYPE_2.toString())};
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, MapsKt.mapOf((Pair[])pairArray), null, EndToEndTest::generated_schema_should_respond_to_simple_mutations$lambda$2, 4, null);
        TestUtilsKt.assertNotNull(data.get("addItem"));
    }

    @Test
    public final void generated schema should execute the subscription query() {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        Item newItem = new Item(1, "item", Type.TYPE_1, uUID, CollectionsKt.emptyList());
        Ref.ObjectRef returnedItem = new Ref.ObjectRef();
        Function0 closure = EndToEndTest::generated_schema_should_execute_the_subscription_query$lambda$3;
        ExecutionResult result = this.gql.execute(ExecutionInput.newExecutionInput().query((String)closure.invoke()).graphQLContext(MapsKt.mapOf((Pair)TuplesKt.to((Object)"newItem", (Object)newItem))).variables(MapsKt.emptyMap()));
        Object object = result.getData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.reactivestreams.Publisher<graphql.ExecutionResult>");
        Publisher data = (Publisher)object;
        CountDownLatch latch = new CountDownLatch(1);
        data.subscribe((Subscriber)new Subscriber<ExecutionResult>((Ref.ObjectRef<Map<String, Map<String, Object>>>)returnedItem, latch){
            final /* synthetic */ Ref.ObjectRef<Map<String, Map<String, Object>>> $returnedItem;
            final /* synthetic */ CountDownLatch $latch;
            {
                this.$returnedItem = $returnedItem;
                this.$latch = $latch;
            }

            public void onNext(ExecutionResult item) {
                ExecutionResult executionResult = item;
                this.$returnedItem.element = executionResult != null ? (Map<K, V>)executionResult.getData() : null;
                this.$latch.countDown();
            }

            public void onError(Throwable throwable) {
            }

            public void onComplete() {
            }

            public void onSubscribe(Subscription p0) {
            }
        });
        latch.await(3L, TimeUnit.SECONDS);
        boolean bl = result.getErrors().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Map map = (Map)returnedItem.element;
        TestUtilsKt.assertEquals(map != null ? (Map)map.get("onItemCreated") : null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)1)));
    }

    @Test
    public final void generated schema should execute the subscription query future() {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        Item newItem = new Item(1, "item", Type.TYPE_1, uUID, CollectionsKt.emptyList());
        Ref.ObjectRef returnedItem = new Ref.ObjectRef();
        Function0 closure = EndToEndTest::generated_schema_should_execute_the_subscription_query_future$lambda$4;
        ExecutionResult result = this.gql.execute(ExecutionInput.newExecutionInput().query((String)closure.invoke()).graphQLContext(MapsKt.mapOf((Pair)TuplesKt.to((Object)"newItem", (Object)newItem))).variables(MapsKt.emptyMap()));
        Object object = result.getData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.reactivestreams.Publisher<graphql.ExecutionResult>");
        Publisher data = (Publisher)object;
        CountDownLatch latch = new CountDownLatch(1);
        data.subscribe((Subscriber)new Subscriber<ExecutionResult>((Ref.ObjectRef<Map<String, Map<String, Object>>>)returnedItem, latch){
            final /* synthetic */ Ref.ObjectRef<Map<String, Map<String, Object>>> $returnedItem;
            final /* synthetic */ CountDownLatch $latch;
            {
                this.$returnedItem = $returnedItem;
                this.$latch = $latch;
            }

            public void onNext(ExecutionResult item) {
                ExecutionResult executionResult = item;
                this.$returnedItem.element = executionResult != null ? (Map<K, V>)executionResult.getData() : null;
                this.$latch.countDown();
            }

            public void onError(Throwable throwable) {
            }

            public void onComplete() {
            }

            public void onSubscribe(Subscription p0) {
            }
        });
        latch.await(3L, TimeUnit.SECONDS);
        boolean bl = result.getErrors().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Map map = (Map)returnedItem.element;
        TestUtilsKt.assertEquals(map != null ? (Map)map.get("onItemCreatedFuture") : null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)1)));
    }

    @Test
    public final void generated schema should handle interface types() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_handle_interface_types$lambda$5, 6, null);
        TestUtilsKt.assertNotNull(data.get("itemsByInterface"));
    }

    @Test
    public final void generated schema should handle union types() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_handle_union_types$lambda$6, 6, null);
        TestUtilsKt.assertNotNull(data.get("allItems"));
    }

    @Test
    public final void generated schema should handle nested union types() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_handle_nested_union_types$lambda$7, 6, null);
        Object[] objectArray = new Map[]{MapsKt.mapOf((Pair)TuplesKt.to((Object)"itemId", (Object)0)), MapsKt.mapOf((Pair)TuplesKt.to((Object)"itemId", (Object)1)), MapsKt.mapOf((Pair)TuplesKt.to((Object)"otherItemId", (Object)0)), MapsKt.mapOf((Pair)TuplesKt.to((Object)"otherItemId", (Object)1)), MapsKt.mapOf((Pair)TuplesKt.to((Object)"thirdItemId", (Object)100))};
        TestUtilsKt.assertEquals(data.get("nestedUnionItems"), CollectionsKt.listOf((Object[])objectArray));
    }

    @Test
    public final void generated schema should handle scalar types() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_handle_scalar_types$lambda$8, 6, null);
        TestUtilsKt.assertNotNull(data.get("itemByUUID"));
    }

    @Test
    public final void generated schema should handle union types with deep hierarchy() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_handle_union_types_with_deep_hierarchy$lambda$9, 6, null);
        TestUtilsKt.assertNotNull(data.get("findSuitableDog"));
    }

    @Test
    public final void generated schema should handle non nullable scalar types() {
        Object[] objectArray = new MockPart[]{new MockPart("test.doc", "Hello"), new MockPart("test.doc", "World")};
        List fileParts = CollectionsKt.listOf((Object[])objectArray);
        Map args = MapsKt.mapOf((Pair)TuplesKt.to((Object)"fileParts", (Object)fileParts));
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, args, null, EndToEndTest::generated_schema_should_handle_non_nullable_scalar_types$lambda$10, 4, null);
        Object[] objectArray2 = new String[]{"Hello", "World"};
        TestUtilsKt.assertEquals(data.get("echoFiles"), CollectionsKt.listOf((Object[])objectArray2));
    }

    @Test
    public final void generated schema should handle any Map (using HashMap) types as property maps() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_handle_any_Map__using_HashMap__types_as_property_maps$lambda$11, 6, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"bob"), TuplesKt.to((Object)"age", (Object)55)};
        TestUtilsKt.assertEquals(data.get("propertyHashMapItems"), CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])pairArray)));
    }

    @Test
    public final void generated schema should handle any Map (using SortedMap) types as property maps() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_handle_any_Map__using_SortedMap__types_as_property_maps$lambda$12, 6, null);
        Object[] objectArray = new Map[2];
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"Arthur"), TuplesKt.to((Object)"age", (Object)76)};
        objectArray[0] = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)"Jane"), TuplesKt.to((Object)"age", (Object)28)};
        objectArray[1] = MapsKt.mapOf((Pair[])pairArray);
        TestUtilsKt.assertEquals(data.get("propertySortedMapItems"), CollectionsKt.listOf((Object[])objectArray));
    }

    @Test
    public final void generated schema should handle Map types as property maps when containing complex data() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_handle_Map_types_as_property_maps_when_containing_complex_data$lambda$13, 6, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"nameId", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)150))), TuplesKt.to((Object)"age", (Object)72)};
        TestUtilsKt.assertEquals(data.get("propertyMapWithComplexItems"), CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])pairArray)));
    }

    @Test
    public final void property map returns null when a property is not defined() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::property_map_returns_null_when_a_property_is_not_defined$lambda$14, 6, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", null), TuplesKt.to((Object)"age", (Object)55)};
        TestUtilsKt.assertEquals(data.get("propertyMapMissingNamePropItems"), CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])pairArray)));
    }

    @Test
    public final void generated schema should continue to associate resolvers for transitive types of a Map complex data type() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_continue_to_associate_resolvers_for_transitive_types_of_a_Map_complex_data_type$lambda$15, 6, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"nested", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"item", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)63))))), TuplesKt.to((Object)"age", (Object)72)};
        TestUtilsKt.assertEquals(data.get("propertyMapWithNestedComplexItems"), CollectionsKt.listOf((Object)MapsKt.mapOf((Pair[])pairArray)));
    }

    @Test
    public final void generated schema should handle optional arguments() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_handle_optional_arguments$lambda$16, 6, null);
        Object[] objectArray = new Map[]{MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)0)), MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)1))};
        TestUtilsKt.assertEquals(data.get("missing"), CollectionsKt.listOf((Object[])objectArray));
        TestUtilsKt.assertEquals(data.get("present"), CollectionsKt.listOf((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)0))));
    }

    @Test
    public final void generated schema should handle optional arguments using Optional() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_handle_optional_arguments_using_Optional$lambda$17, 6, null);
        Object[] objectArray = new Map[]{MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)0)), MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)1))};
        TestUtilsKt.assertEquals(data.get("missing"), CollectionsKt.listOf((Object[])objectArray));
        TestUtilsKt.assertEquals(data.get("present"), CollectionsKt.listOf((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)0))));
    }

    @Test
    public final void generated schema should handle optional return types using Optional() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_handle_optional_return_types_using_Optional$lambda$18, 6, null);
        TestUtilsKt.assertNull(data.get("missing"));
        TestUtilsKt.assertNotNull(data.get("present"));
    }

    @Test
    public final void generated schema should pass default arguments() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_pass_default_arguments$lambda$19, 6, null);
        boolean bl = Intrinsics.areEqual(data.get("defaultArgument"), (Object)true);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    public final void introspection shouldn't fail for arguments of type list with a default value (defaultEnumListArgument)() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::introspection_shouldn_t_fail_for_arguments_of_type_list_with_a_default_value__defaultEnumListArgument_$lambda$20, 6, null);
        TestUtilsKt.assertNotNull(data.get("__type"));
    }

    @Test
    public final void generated schema should return null without errors for null value with nested fields() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_return_null_without_errors_for_null_value_with_nested_fields$lambda$21, 6, null);
        boolean bl = data.containsKey("complexNullableType");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        TestUtilsKt.assertNull(data.get("complexNullableType"));
    }

    @Test
    public final void generated schema handles nested lists in input type fields() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_handles_nested_lists_in_input_type_fields$lambda$22, 6, null);
        TestUtilsKt.assertNotNull(data.get("complexInputType"));
    }

    @Test
    public final void generated schema should use type extensions() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_use_type_extensions$lambda$23, 6, null);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"first", (Object)"test"), TuplesKt.to((Object)"second", (Object)"test")};
        TestUtilsKt.assertEquals(data.get("extendedType"), MapsKt.mapOf((Pair[])pairArray));
    }

    @Test
    public final void generated schema uses properties if no methods are found() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_uses_properties_if_no_methods_are_found$lambda$24, 6, null);
        TestUtilsKt.assertNotNull(data.get("propertyField"));
    }

    @Test
    public final void generated schema allows enums in input types() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_allows_enums_in_input_types$lambda$25, 6, null);
        TestUtilsKt.assertEquals(data.get("enumInputType"), "TYPE_2");
    }

    @Test
    public final void generated schema works with custom scalars as input values() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_works_with_custom_scalars_as_input_values$lambda$26, 6, null);
        TestUtilsKt.assertEquals(data.get("customScalarMapInputType"), MapsKt.mapOf((Pair)TuplesKt.to((Object)"test", (Object)"me")));
    }

    @Test
    public final void generated schema should handle extended input types() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_should_handle_extended_input_types$lambda$27, 6, null);
        TestUtilsKt.assertEquals(data.get("saveUser"), "John/secret");
    }

    @Test
    public final void generated schema supports generic properties() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_supports_generic_properties$lambda$28, 6, null);
        Object[] objectArray = new String[]{"A", "B"};
        TestUtilsKt.assertEquals(data.get("itemWithGenericProperties"), MapsKt.mapOf((Pair)TuplesKt.to((Object)"keys", (Object)CollectionsKt.listOf((Object[])objectArray))));
    }

    @Test
    public final void generated schema supports overriding built-in scalars() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_supports_overriding_built_in_scalars$lambda$29, 6, null);
        TestUtilsKt.assertNotNull(data.get("itemByBuiltInId"));
    }

    @Test
    public final void generated schema supports DataFetcherResult() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_supports_DataFetcherResult$lambda$30, 6, null);
        TestUtilsKt.assertEquals(data.get("dataFetcherResult"), MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)"item1")));
    }

    @Test
    public final void generated schema supports list of DataFetcherResult() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_supports_list_of_DataFetcherResult$lambda$31, 6, null);
        TestUtilsKt.assertEquals(data.get("dataFetcherResultItems"), CollectionsKt.listOf((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)"item1"))));
    }

    @Test
    public final void generated schema supports Kotlin suspend functions() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_supports_Kotlin_suspend_functions$lambda$32, 6, null);
        Object[] objectArray = new Map[2];
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)0), TuplesKt.to((Object)"name", (Object)"item1")};
        objectArray[0] = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"id", (Object)1), TuplesKt.to((Object)"name", (Object)"item2")};
        objectArray[1] = MapsKt.mapOf((Pair[])pairArray);
        TestUtilsKt.assertEquals(data.get("coroutineItems"), CollectionsKt.listOf((Object[])objectArray));
    }

    @Test
    public final void generated schema supports Kotlin coroutine channels for the subscription query() {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        Item newItem = new Item(1, "item", Type.TYPE_1, uUID, CollectionsKt.emptyList());
        Function0 closure = EndToEndTest::generated_schema_supports_Kotlin_coroutine_channels_for_the_subscription_query$lambda$33;
        ExecutionResult result = this.gql.execute(ExecutionInput.newExecutionInput().query((String)closure.invoke()).graphQLContext(MapsKt.mapOf((Pair)TuplesKt.to((Object)"newItem", (Object)newItem))).variables(MapsKt.emptyMap()));
        Object object = result.getData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.reactivestreams.Publisher<graphql.ExecutionResult>");
        Publisher data = (Publisher)object;
        TestEnvironment.ManualSubscriber subscriber = new TestEnvironment().newManualSubscriber(data);
        Object object2 = subscriber.requestNextElement();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type graphql.ExecutionResultImpl");
        ExecutionResultImpl subscriberResult = (ExecutionResultImpl)object2;
        Map subscriberData = (Map)subscriberResult.getData();
        boolean bl = result.getErrors().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Map map = subscriberData;
        TestUtilsKt.assertEquals(map != null ? (Map)map.get("onItemCreatedCoroutineChannel") : null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)1)));
        subscriber.expectCompletion();
    }

    @Test
    public final void generated schema supports Kotlin coroutine channels with suspend function for the subscription query() {
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        Item newItem = new Item(1, "item", Type.TYPE_1, uUID, CollectionsKt.emptyList());
        Function0 closure = EndToEndTest::generated_schema_supports_Kotlin_coroutine_channels_with_suspend_function_for_the_subscription_query$lambda$34;
        ExecutionResult result = this.gql.execute(ExecutionInput.newExecutionInput().query((String)closure.invoke()).graphQLContext(MapsKt.mapOf((Pair)TuplesKt.to((Object)"newItem", (Object)newItem))).variables(MapsKt.emptyMap()));
        Object object = result.getData();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.reactivestreams.Publisher<graphql.ExecutionResult>");
        Publisher data = (Publisher)object;
        TestEnvironment.ManualSubscriber subscriber = new TestEnvironment().newManualSubscriber(data);
        Object object2 = subscriber.requestNextElement();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type graphql.ExecutionResultImpl");
        ExecutionResultImpl subscriberResult = (ExecutionResultImpl)object2;
        Map subscriberData = (Map)subscriberResult.getData();
        boolean bl = result.getErrors().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Map map = subscriberData;
        TestUtilsKt.assertEquals(map != null ? (Map)map.get("onItemCreatedCoroutineChannelAndSuspendFunction") : null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"id", (Object)1)));
        subscriber.expectCompletion();
    }

    @Test
    public final void generated schema supports arrays() {
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, null, null, EndToEndTest::generated_schema_supports_arrays$lambda$35, 6, null);
        Object[] objectArray = new Map[]{MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)"item1")), MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)"item2"))};
        TestUtilsKt.assertEquals(data.get("arrayItems"), CollectionsKt.listOf((Object[])objectArray));
    }

    @Test
    public final void generated schema should re-throw original runtime exception when executing a resolver method() {
        ExecutionResult result = this.gql.execute(ExecutionInput.newExecutionInput().query("\n            {\n                throwsIllegalArgumentException\n            }\n            "));
        TestUtilsKt.assertEquals(result.getErrors().size(), 1);
        Object e = result.getErrors().get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type graphql.ExceptionWhileDataFetching");
        ExceptionWhileDataFetching exceptionWhileDataFetching = (ExceptionWhileDataFetching)e;
        boolean bl = exceptionWhileDataFetching.getException() instanceof IllegalArgumentException;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    public final void transformed schema should execute query() {
        GraphQLSchema transformedSchema = new SchemaTransformer().transform(this.schema, (GraphQLTypeVisitor)new Transformer());
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)transformedSchema).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQL, (String)"build(...)");
        GraphQL transformedGql = graphQL;
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(transformedGql, null, null, EndToEndTest::transformed_schema_should_execute_query$lambda$36, 6, null);
        Object[] objectArray = new Map[]{MapsKt.mapOf((Pair)TuplesKt.to((Object)"itemId", (Object)0)), MapsKt.mapOf((Pair)TuplesKt.to((Object)"itemId", (Object)1)), MapsKt.mapOf((Pair)TuplesKt.to((Object)"thirdItemId", (Object)100))};
        TestUtilsKt.assertEquals(data.get("otherUnionItems"), CollectionsKt.listOf((Object[])objectArray));
    }

    private static final String generated_schema_should_respond_to_simple_queries$lambda$1() {
        return "\n            {\n                items(itemsInput: {name: \"item1\"}) {\n                    id\n                    type\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_respond_to_simple_mutations$lambda$2() {
        return "\n            mutation addNewItem($name: String!, $type: Type!) {\n                addItem(newItem: {name: $name, type: $type}) {\n                    id\n                    name\n                    type\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_execute_the_subscription_query$lambda$3() {
        return "\n            subscription {\n                onItemCreated {\n                    id\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_execute_the_subscription_query_future$lambda$4() {
        return "\n            subscription {\n                onItemCreatedFuture {\n                    id\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_handle_interface_types$lambda$5() {
        return "\n            {\n                itemsByInterface {\n                    name\n                    type\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_handle_union_types$lambda$6() {
        return "\n            {\n                allItems {\n                    ... on Item {\n                        id\n                        name\n                    }\n                    ... on OtherItem {\n                        name\n                        type\n                    }\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_handle_nested_union_types$lambda$7() {
        return "\n            {\n                nestedUnionItems {\n                    ... on Item {\n                        itemId: id\n                    }\n                    ... on OtherItem {\n                        otherItemId: id\n                    }\n                    ... on ThirdItem {\n                        thirdItemId: id\n                    }\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_handle_scalar_types$lambda$8() {
        return "\n            {\n                itemByUUID(uuid: \"38f685f1-b460-4a54-a17f-7fd69e8cf3f8\") {\n                    uuid\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_handle_union_types_with_deep_hierarchy$lambda$9() {
        return "\n            {\n                findSuitableDog(preferredColor: \"chocolate\", minimumFluffiness: 31) {\n                    ... on Dog { name }\n                    ... on NoDogError { msg }\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_handle_non_nullable_scalar_types$lambda$10() {
        return "\n            mutation ($fileParts: [Upload!]!) { echoFiles(fileParts: $fileParts) }\n            ";
    }

    private static final String generated_schema_should_handle_any_Map__using_HashMap__types_as_property_maps$lambda$11() {
        return "\n            {\n                propertyHashMapItems {\n                    name\n                    age\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_handle_any_Map__using_SortedMap__types_as_property_maps$lambda$12() {
        return "\n            {\n                propertySortedMapItems {\n                    name\n                    age\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_handle_Map_types_as_property_maps_when_containing_complex_data$lambda$13() {
        return "\n            {\n                propertyMapWithComplexItems {\n                    nameId {\n                        id\n                    }\n                    age\n                }\n            }\n            ";
    }

    private static final String property_map_returns_null_when_a_property_is_not_defined$lambda$14() {
        return "\n            {\n                propertyMapMissingNamePropItems {\n                    name\n                    age\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_continue_to_associate_resolvers_for_transitive_types_of_a_Map_complex_data_type$lambda$15() {
        return "\n            {\n                propertyMapWithNestedComplexItems {\n                    nested {\n                        item {\n                            id\n                        }\n                    }\n                    age\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_handle_optional_arguments$lambda$16() {
        return "\n            {\n                missing: itemsWithOptionalInput {\n                    id\n                }\n\n                present: itemsWithOptionalInput(itemsInput: {name: \"item1\"}) {\n                    id\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_handle_optional_arguments_using_Optional$lambda$17() {
        return "\n            {\n                missing: itemsWithOptionalInputExplicit {\n                    id\n                }\n\n                present: itemsWithOptionalInputExplicit(itemsInput: {name: \"item1\"}) {\n                    id\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_handle_optional_return_types_using_Optional$lambda$18() {
        return "\n            {\n                missing: optionalItem(itemsInput: {name: \"item?\"}) {\n                    id\n                }\n\n                present: optionalItem(itemsInput: {name: \"item1\"}) {\n                    id\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_pass_default_arguments$lambda$19() {
        return "\n            {\n                defaultArgument\n            }\n            ";
    }

    private static final String introspection_shouldn_t_fail_for_arguments_of_type_list_with_a_default_value__defaultEnumListArgument_$lambda$20() {
        return "\n            {\n                __type(name: \"Query\") {\n                    name\n                    fields {\n                        name\n                        args {\n                            name\n                            defaultValue\n                        }\n                    }\n                }\n            }\n            ";
    }

    private static final String generated_schema_should_return_null_without_errors_for_null_value_with_nested_fields$lambda$21() {
        return "\n            {\n                complexNullableType {\n                    first\n                    second\n                    third\n                }\n            }\n            ";
    }

    private static final String generated_schema_handles_nested_lists_in_input_type_fields$lambda$22() {
        return "\n            {\n                complexInputType(complexInput: [[{first: \"foo\", second: [[{first: \"bar\"}]]}]])\n            }\n            ";
    }

    private static final String generated_schema_should_use_type_extensions$lambda$23() {
        return "\n            {\n                extendedType {\n                    first\n                    second\n                }\n            }\n            ";
    }

    private static final String generated_schema_uses_properties_if_no_methods_are_found$lambda$24() {
        return "\n            {\n                propertyField\n            }\n            ";
    }

    private static final String generated_schema_allows_enums_in_input_types$lambda$25() {
        return "\n            {\n                enumInputType(type: TYPE_2)\n            }\n            ";
    }

    private static final String generated_schema_works_with_custom_scalars_as_input_values$lambda$26() {
        return "\n            {\n                customScalarMapInputType(customScalarMap: { test: \"me\" })\n            }\n            ";
    }

    private static final String generated_schema_should_handle_extended_input_types$lambda$27() {
        return "\n            mutation {\n                saveUser(input: {name: \"John\", password: \"secret\"})\n            }\n            ";
    }

    private static final String generated_schema_supports_generic_properties$lambda$28() {
        return "\n            {\n                itemWithGenericProperties {\n                    keys\n                }\n            }\n            ";
    }

    private static final String generated_schema_supports_overriding_built_in_scalars$lambda$29() {
        return "\n            {\n                itemByBuiltInId(id: \"38f685f1-b460-4a54-a17f-7fd69e8cf3f8\") {\n                    name\n                }\n            }\n            ";
    }

    private static final String generated_schema_supports_DataFetcherResult$lambda$30() {
        return "\n            {\n                dataFetcherResult {\n                    name\n                }\n            }\n            ";
    }

    private static final String generated_schema_supports_list_of_DataFetcherResult$lambda$31() {
        return "\n            {\n                dataFetcherResultItems {\n                    name\n                }\n            }\n            ";
    }

    private static final String generated_schema_supports_Kotlin_suspend_functions$lambda$32() {
        return "\n            {\n                coroutineItems {\n                    id\n                    name\n                }\n            }\n            ";
    }

    private static final String generated_schema_supports_Kotlin_coroutine_channels_for_the_subscription_query$lambda$33() {
        return "\n            subscription {\n                onItemCreatedCoroutineChannel {\n                    id\n                }\n            }\n            ";
    }

    private static final String generated_schema_supports_Kotlin_coroutine_channels_with_suspend_function_for_the_subscription_query$lambda$34() {
        return "\n            subscription {\n                onItemCreatedCoroutineChannelAndSuspendFunction {\n                    id\n                }\n            }\n            ";
    }

    private static final String generated_schema_supports_arrays$lambda$35() {
        return "\n            {\n                arrayItems {\n                    name\n                }\n            }\n            ";
    }

    private static final String transformed_schema_should_execute_query$lambda$36() {
        return "\n            {\n                otherUnionItems {\n                    ... on Item {\n                        itemId: id\n                    }\n                    ... on ThirdItem {\n                       thirdItemId: id\n                    }\n                }\n            }\n            ";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tH\u0016\u00a8\u0006\u000b"}, d2={"Lgraphql/kickstart/tools/EndToEndTest$Transformer;", "Lgraphql/schema/GraphQLTypeVisitorStub;", "<init>", "()V", "visitGraphQLObjectType", "Lgraphql/util/TraversalControl;", "node", "Lgraphql/schema/GraphQLObjectType;", "context", "Lgraphql/util/TraverserContext;", "Lgraphql/schema/GraphQLSchemaElement;", "graphql-java-tools"})
    public static final class Transformer
    extends GraphQLTypeVisitorStub {
        @NotNull
        public TraversalControl visitGraphQLObjectType(@Nullable GraphQLObjectType node, @Nullable TraverserContext<GraphQLSchemaElement> context) {
            GraphQLObjectType graphQLObjectType = node;
            GraphQLObjectType newNode = graphQLObjectType != null ? graphQLObjectType.transform(arg_0 -> Transformer.visitGraphQLObjectType$lambda$0(node, arg_0)) : null;
            TraversalControl traversalControl = this.changeNode(context, (GraphQLSchemaElement)newNode);
            Intrinsics.checkNotNullExpressionValue((Object)traversalControl, (String)"changeNode(...)");
            return traversalControl;
        }

        private static final void visitGraphQLObjectType$lambda$0(GraphQLObjectType $node, GraphQLObjectType.Builder builder) {
            builder.description($node.getDescription() + " [MODIFIED]");
        }
    }
}

