/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\n\u000b\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgraphql/kickstart/tools/EnumListParameterTest;", "", "<init>", "()V", "schema", "Lgraphql/schema/GraphQLSchema;", "gql", "Lgraphql/GraphQL;", "query with parameter type list of enums should resolve correctly", "", "QueryResolver", "Country", "Region", "graphql-java-tools"})
public final class EnumListParameterTest {
    @NotNull
    private final GraphQLSchema schema;
    @NotNull
    private final GraphQL gql;

    public EnumListParameterTest() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new QueryResolver()};
        this.schema = SchemaParser.Companion.newParser().schemaString("\n            type Query {\n                countries(regions: [Region!]!): [Country!]!\n            }\n    \n            enum Region {\n                EUROPE\n                ASIA\n            }\n    \n            type Country {\n                code: String!\n                name: String!\n                regions: [Region!]\n            }\n            ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)this.schema).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQL, (String)"build(...)");
        this.gql = graphQL;
    }

    @Test
    public final void query with parameter type list of enums should resolve correctly() {
        Object[] objectArray = new String[]{"EUROPE", "ASIA"};
        Map data = TestUtilsKt.assertNoGraphQlErrors$default(this.gql, MapsKt.mapOf((Pair)TuplesKt.to((Object)"regions", (Object)SetsKt.setOf((Object[])objectArray))), null, EnumListParameterTest::query_with_parameter_type_list_of_enums_should_resolve_correctly$lambda$0, 4, null);
        TestUtilsKt.assertEquals(data.get("countries"), CollectionsKt.emptyList());
    }

    private static final String query_with_parameter_type_list_of_enums_should_resolve_correctly$lambda$0() {
        return "\n            query getCountries($regions: [Region!]!) {\n                countries(regions: $regions){\n                    code\n                    name\n                    regions\n                }\n            }\n            ";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\"\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lgraphql/kickstart/tools/EnumListParameterTest$Country;", "", "<init>", "()V", "code", "", "getCode", "()Ljava/lang/String;", "setCode", "(Ljava/lang/String;)V", "name", "getName", "setName", "regions", "", "Lgraphql/kickstart/tools/EnumListParameterTest$Region;", "getRegions", "()Ljava/util/List;", "setRegions", "(Ljava/util/List;)V", "graphql-java-tools"})
    public static final class Country {
        @Nullable
        private String code;
        @Nullable
        private String name;
        @Nullable
        private List<? extends Region> regions;

        @Nullable
        public final String getCode() {
            return this.code;
        }

        public final void setCode(@Nullable String string) {
            this.code = string;
        }

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }

        @Nullable
        public final List<Region> getRegions() {
            return this.regions;
        }

        public final void setRegions(@Nullable List<? extends Region> list) {
            this.regions = list;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/EnumListParameterTest$QueryResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "<init>", "()V", "getCountries", "", "Lgraphql/kickstart/tools/EnumListParameterTest$Country;", "regions", "Lgraphql/kickstart/tools/EnumListParameterTest$Region;", "graphql-java-tools"})
    public static final class QueryResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final Set<Country> getCountries(@NotNull Set<? extends Region> regions) {
            Intrinsics.checkNotNullParameter(regions, (String)"regions");
            return SetsKt.emptySet();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/EnumListParameterTest$Region;", "", "<init>", "(Ljava/lang/String;I)V", "EUROPE", "ASIA", "graphql-java-tools"})
    public static final class Region
    extends Enum<Region> {
        public static final /* enum */ Region EUROPE = new Region();
        public static final /* enum */ Region ASIA = new Region();
        private static final /* synthetic */ Region[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Region[] values() {
            return (Region[])$VALUES.clone();
        }

        public static Region valueOf(String value) {
            return Enum.valueOf(Region.class, value);
        }

        @NotNull
        public static EnumEntries<Region> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = regionArray = new Region[]{Region.EUROPE, Region.ASIA};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

