/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.ExecutionResult;
import graphql.GraphQLContext;
import graphql.execution.ExecutionContext;
import graphql.execution.ExecutionContextBuilder;
import graphql.execution.ExecutionId;
import graphql.execution.ExecutionStrategy;
import graphql.execution.ExecutionStrategyParameters;
import graphql.execution.instrumentation.Instrumentation;
import graphql.execution.instrumentation.SimplePerformantInstrumentation;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.NormalResolverInfo;
import graphql.kickstart.tools.ResolverError;
import graphql.kickstart.tools.ResolverInfo;
import graphql.kickstart.tools.RootResolverInfo;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.kickstart.tools.resolver.FieldResolverError;
import graphql.kickstart.tools.resolver.FieldResolverScanner;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;
import org.reactivestreams.Publisher;
import org.reactivestreams.tck.TestEnvironment;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0006*+,-./B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\b\u0010\u0007\u001a\u00020\u0005H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0007J\b\u0010\t\u001a\u00020\u0005H\u0007J\b\u0010\n\u001a\u00020\u0005H\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0007J\b\u0010\f\u001a\u00020\u0005H\u0007J\b\u0010\r\u001a\u00020\u0005H\u0007J\b\u0010\u000e\u001a\u00020\u0005H\u0007J\b\u0010\u000f\u001a\u00020\u0005H\u0007J\b\u0010\u0010\u001a\u00020\u0005H\u0007J\b\u0010\u0011\u001a\u00020\u0005H\u0007J\b\u0010\u0012\u001a\u00020\u0005H\u0007J\b\u0010\u0013\u001a\u00020\u0005H\u0007J\b\u0010\u0014\u001a\u00020\u0005H\u0007J\b\u0010\u0015\u001a\u00020\u0005H\u0007J\b\u0010\u0016\u001a\u00020\u0005H\u0007J0\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0002J:\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u001f2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\b\b\u0002\u0010 \u001a\u00020!H\u0002J4\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020\u00012\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u00010%2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'H\u0002J\b\u0010(\u001a\u00020)H\u0002\u00a8\u00060"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverDataFetcherTest;", "", "<init>", "()V", "data fetcher executes suspend function on coroutineContext defined by options", "", "canceling subscription Publisher also cancels underlying Kotlin coroutine channel", "canceling underlying Kotlin coroutine channel also cancels subscription Publisher", "data fetcher throws exception if resolver has too many arguments", "data fetcher throws exception if resolver has too few arguments", "data fetcher prioritizes methods on the resolver", "data fetcher uses data class methods if no resolver method is given", "data fetcher prioritizes methods without a prefix", "data fetcher uses 'is' prefix for booleans (primitive type)", "data fetcher uses 'is' prefix for Booleans (Object type)", "data fetcher passes environment if method has extra argument", "data fetcher passes environment if method has extra argument even if context is specified", "data fetcher passes context if method has extra argument and context is specified", "data fetcher passes custom context if method has extra argument and custom context is specified as part of GraphQLContext", "data fetcher marshalls input object if required", "data fetcher doesn't marshall input object if not required", "data fetcher returns null if nullable argument is passed null", "data fetcher throws exception if non-null argument is passed null", "createFetcher", "Lgraphql/schema/DataFetcher;", "methodName", "", "arguments", "", "Lgraphql/language/InputValueDefinition;", "resolver", "Lgraphql/kickstart/tools/GraphQLResolver;", "options", "Lgraphql/kickstart/tools/SchemaParserOptions;", "createEnvironment", "Lgraphql/schema/DataFetchingEnvironment;", "source", "", "context", "Lgraphql/GraphQLContext;", "buildExecutionContext", "Lgraphql/execution/ExecutionContext;", "SuspendClass", "DoubleChannel", "OnDataNameChanged", "DataClass", "InputClass", "ContextClass", "graphql-java-tools"})
public final class MethodFieldResolverDataFetcherTest {
    @Test
    @ExperimentalCoroutinesApi
    public final void data fetcher executes suspend function on coroutineContext defined by options() {
        SuspendClass suspendClass = new SuspendClass();
        DataFetcher resolver2 = MethodFieldResolverDataFetcherTest.createFetcher$default(this, "active", suspendClass, null, suspendClass.getOptions(), 4, null);
        Object object = resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, new DataClass(null, 1, null), null, null, 6, null));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.concurrent.CompletableFuture<kotlin.Boolean>");
        CompletableFuture future = (CompletableFuture)object;
        Object t = future.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        boolean bl = (Boolean)t;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    @ExperimentalCoroutinesApi
    public final void canceling subscription Publisher also cancels underlying Kotlin coroutine channel() {
        DoubleChannel doubleChannel = new DoubleChannel();
        DataFetcher resolver2 = MethodFieldResolverDataFetcherTest.createFetcher$default(this, "onDataNameChanged", doubleChannel, null, null, 12, null);
        Object object = resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, new DataClass(null, 1, null), null, null, 6, null));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.reactivestreams.Publisher<kotlin.String>");
        Publisher publisher = (Publisher)object;
        TestEnvironment.ManualSubscriber subscriber = new TestEnvironment().newManualSubscriber(publisher);
        TestUtilsKt.assertEquals(subscriber.requestNextElement(), "A");
        subscriber.cancel();
        Thread.sleep(100L);
        boolean bl = doubleChannel.getChannel().isClosedForReceive();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    public final void canceling underlying Kotlin coroutine channel also cancels subscription Publisher() {
        DataFetcher resolver2 = MethodFieldResolverDataFetcherTest.createFetcher$default(this, "onDataNameChanged", new OnDataNameChanged(), null, null, 12, null);
        Object object = resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, new DataClass(null, 1, null), null, null, 6, null));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.reactivestreams.Publisher<kotlin.String>");
        Publisher publisher = (Publisher)object;
        TestEnvironment.ManualSubscriber subscriber = new TestEnvironment().newManualSubscriber(publisher);
        TestUtilsKt.assertEquals(subscriber.requestNextElement(), "A");
        subscriber.expectErrorWithMessage(IllegalStateException.class, "Channel error");
    }

    @Test(expected=FieldResolverError.class)
    public final void data fetcher throws exception if resolver has too many arguments() {
        MethodFieldResolverDataFetcherTest.createFetcher$default(this, "active", (GraphQLResolver)new GraphQLQueryResolver(){

            public final boolean active(Object arg1, Object arg2) {
                Intrinsics.checkNotNullParameter((Object)arg1, (String)"arg1");
                Intrinsics.checkNotNullParameter((Object)arg2, (String)"arg2");
                return true;
            }
        }, null, null, 12, null);
    }

    @Test(expected=FieldResolverError.class)
    public final void data fetcher throws exception if resolver has too few arguments() {
        this.createFetcher("active", CollectionsKt.listOf((Object)new InputValueDefinition("doesNotExist", (Type)new TypeName("Boolean"))), (GraphQLResolver)new GraphQLQueryResolver(){

            public final boolean active() {
                return true;
            }
        });
    }

    @Test
    public final void data fetcher prioritizes methods on the resolver() {
        String name = "Resolver Name";
        DataFetcher resolver2 = MethodFieldResolverDataFetcherTest.createFetcher$default(this, "name", (GraphQLResolver)new GraphQLResolver<DataClass>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            public final String getName(DataClass dataClass) {
                Intrinsics.checkNotNullParameter((Object)dataClass, (String)"dataClass");
                return this.$name;
            }
        }, null, null, 12, null);
        TestUtilsKt.assertEquals(resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, new DataClass(null, 1, null), null, null, 6, null)), name);
    }

    @Test
    public final void data fetcher uses data class methods if no resolver method is given() {
        DataFetcher resolver2 = MethodFieldResolverDataFetcherTest.createFetcher$default(this, "name", (GraphQLResolver)new GraphQLResolver<DataClass>(){}, null, null, 12, null);
        TestUtilsKt.assertEquals(resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, new DataClass(null, 1, null), null, null, 6, null)), new DataClass(null, 1, null).getName());
    }

    @Test
    public final void data fetcher prioritizes methods without a prefix() {
        String name = "correct name";
        DataFetcher resolver2 = MethodFieldResolverDataFetcherTest.createFetcher$default(this, "name", (GraphQLResolver)new GraphQLResolver<DataClass>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            public final String getName(DataClass dataClass) {
                Intrinsics.checkNotNullParameter((Object)dataClass, (String)"dataClass");
                return "in" + this.$name;
            }

            public final String name(DataClass dataClass) {
                Intrinsics.checkNotNullParameter((Object)dataClass, (String)"dataClass");
                return this.$name;
            }
        }, null, null, 12, null);
        TestUtilsKt.assertEquals(resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, new DataClass(null, 1, null), null, null, 6, null)), name);
    }

    @Test
    public final void data fetcher uses 'is' prefix for booleans (primitive type)() {
        DataFetcher resolver2 = MethodFieldResolverDataFetcherTest.createFetcher$default(this, "active", (GraphQLResolver)new GraphQLResolver<DataClass>(){

            public final boolean isActive(DataClass dataClass) {
                Intrinsics.checkNotNullParameter((Object)dataClass, (String)"dataClass");
                return true;
            }

            public final boolean getActive(DataClass dataClass) {
                Intrinsics.checkNotNullParameter((Object)dataClass, (String)"dataClass");
                return true;
            }
        }, null, null, 12, null);
        TestUtilsKt.assertEquals(resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, new DataClass(null, 1, null), null, null, 6, null)), true);
    }

    @Test
    public final void data fetcher uses 'is' prefix for Booleans (Object type)() {
        DataFetcher resolver2 = MethodFieldResolverDataFetcherTest.createFetcher$default(this, "active", (GraphQLResolver)new GraphQLResolver<DataClass>(){

            public final Boolean isActive(DataClass dataClass) {
                Intrinsics.checkNotNullParameter((Object)dataClass, (String)"dataClass");
                return null;
            }

            public final Boolean getActive(DataClass dataClass) {
                Intrinsics.checkNotNullParameter((Object)dataClass, (String)"dataClass");
                return null;
            }
        }, null, null, 12, null);
        TestUtilsKt.assertEquals(resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, new DataClass(null, 1, null), null, null, 6, null)), null);
    }

    @Test
    public final void data fetcher passes environment if method has extra argument() {
        DataFetcher resolver2 = MethodFieldResolverDataFetcherTest.createFetcher$default(this, "active", (GraphQLResolver)new GraphQLResolver<DataClass>(){

            public final boolean isActive(DataClass dataClass, DataFetchingEnvironment env) {
                Intrinsics.checkNotNullParameter((Object)dataClass, (String)"dataClass");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                return true;
            }
        }, null, null, 12, null);
        TestUtilsKt.assertEquals(resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, new DataClass(null, 1, null), null, null, 6, null)), true);
    }

    @Test
    public final void data fetcher passes environment if method has extra argument even if context is specified() {
        GraphQLContext context = GraphQLContext.newContext().build();
        DataFetcher resolver2 = MethodFieldResolverDataFetcherTest.createFetcher$default(this, "active", null, (GraphQLResolver)new GraphQLResolver<DataClass>(){

            public final boolean isActive(DataClass dataClass, DataFetchingEnvironment env) {
                Intrinsics.checkNotNullParameter((Object)dataClass, (String)"dataClass");
                Intrinsics.checkNotNullParameter((Object)env, (String)"env");
                return true;
            }
        }, 2, null);
        TestUtilsKt.assertEquals(resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, new DataClass(null, 1, null), null, context, 2, null)), true);
    }

    @Test
    public final void data fetcher passes context if method has extra argument and context is specified() {
        GraphQLContext context = GraphQLContext.newContext().build();
        DataFetcher resolver2 = MethodFieldResolverDataFetcherTest.createFetcher$default(this, "active", null, (GraphQLResolver)new GraphQLResolver<DataClass>(context){
            final /* synthetic */ GraphQLContext $context;
            {
                this.$context = $context;
            }

            public final boolean isActive(DataClass dataClass, GraphQLContext ctx) {
                Intrinsics.checkNotNullParameter((Object)dataClass, (String)"dataClass");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                return Intrinsics.areEqual((Object)ctx, (Object)this.$context);
            }
        }, 2, null);
        TestUtilsKt.assertEquals(resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, new DataClass(null, 1, null), null, context, 2, null)), true);
    }

    @Test
    public final void data fetcher passes custom context if method has extra argument and custom context is specified as part of GraphQLContext() {
        ContextClass customContext = new ContextClass();
        GraphQLContext context = GraphQLContext.of((Map)MapsKt.mapOf((Pair)TuplesKt.to(ContextClass.class, (Object)customContext)));
        SchemaParserOptions options = SchemaParserOptions.Companion.newOptions().contextClass(Reflection.getOrCreateKotlinClass(ContextClass.class)).build();
        GraphQLResolver<DataClass> graphQLResolver = new GraphQLResolver<DataClass>(customContext){
            final /* synthetic */ ContextClass $customContext;
            {
                this.$customContext = $customContext;
            }

            public final boolean isActive(DataClass dataClass, ContextClass ctx) {
                Intrinsics.checkNotNullParameter((Object)dataClass, (String)"dataClass");
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                return Intrinsics.areEqual((Object)ctx, (Object)this.$customContext);
            }
        };
        DataFetcher resolver2 = MethodFieldResolverDataFetcherTest.createFetcher$default(this, "active", (GraphQLResolver)graphQLResolver, null, options, 4, null);
        TestUtilsKt.assertEquals(resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, new DataClass(null, 1, null), null, context, 2, null)), true);
    }

    @Test
    public final void data fetcher marshalls input object if required() {
        String name = "correct name";
        DataFetcher<?> resolver2 = this.createFetcher("active", CollectionsKt.listOf((Object)new InputValueDefinition("input", (Type)new TypeName("InputClass"))), (GraphQLResolver)new GraphQLQueryResolver(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            public final boolean active(InputClass input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return Intrinsics.areEqual((Object)input.getName(), (Object)this.$name);
            }
        });
        TestUtilsKt.assertEquals(resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"input", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)name)))), null, 5, null)), true);
    }

    @Test
    public final void data fetcher doesn't marshall input object if not required() {
        String name = "correct name";
        DataFetcher<?> resolver2 = this.createFetcher("active", CollectionsKt.listOf((Object)new InputValueDefinition("input", (Type)new TypeName("Map"))), (GraphQLResolver)new GraphQLQueryResolver(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
            }

            public final boolean active(Map<?, ?> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                return Intrinsics.areEqual(input.get("name"), (Object)this.$name);
            }
        });
        TestUtilsKt.assertEquals(resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"input", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"name", (Object)name)))), null, 5, null)), true);
    }

    @Test
    public final void data fetcher returns null if nullable argument is passed null() {
        DataFetcher<?> resolver2 = this.createFetcher("echo", CollectionsKt.listOf((Object)new InputValueDefinition("message", (Type)new TypeName("String"))), (GraphQLResolver)new GraphQLQueryResolver(){

            public final String echo(String message) {
                return message;
            }
        });
        TestUtilsKt.assertEquals(resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, null, null, null, 7, null)), null);
    }

    @Test(expected=ResolverError.class)
    public final void data fetcher throws exception if non-null argument is passed null() {
        DataFetcher<?> resolver2 = this.createFetcher("echo", CollectionsKt.listOf((Object)new InputValueDefinition("message", (Type)new NonNullType((Type)new TypeName("String")))), (GraphQLResolver)new GraphQLQueryResolver(){

            public final String echo(String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return message;
            }
        });
        resolver2.get(MethodFieldResolverDataFetcherTest.createEnvironment$default(this, null, null, null, 7, null));
    }

    private final DataFetcher<?> createFetcher(String methodName, List<? extends InputValueDefinition> arguments, GraphQLResolver<?> resolver2) {
        return MethodFieldResolverDataFetcherTest.createFetcher$default(this, methodName, resolver2, arguments, null, 8, null);
    }

    static /* synthetic */ DataFetcher createFetcher$default(MethodFieldResolverDataFetcherTest methodFieldResolverDataFetcherTest, String string, List list, GraphQLResolver graphQLResolver, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return methodFieldResolverDataFetcherTest.createFetcher(string, list, graphQLResolver);
    }

    private final DataFetcher<?> createFetcher(String methodName, GraphQLResolver<?> resolver2, List<? extends InputValueDefinition> arguments, SchemaParserOptions options) {
        FieldDefinition field = FieldDefinition.newFieldDefinition().name(methodName).type((Type)new TypeName("Boolean")).inputValueDefinitions(arguments).build();
        ResolverInfo resolverInfo = resolver2 instanceof GraphQLQueryResolver ? (ResolverInfo)new RootResolverInfo(CollectionsKt.listOf(resolver2), options) : (ResolverInfo)new NormalResolverInfo(resolver2, options);
        FieldResolverScanner fieldResolverScanner = new FieldResolverScanner(options);
        Intrinsics.checkNotNull((Object)field);
        return fieldResolverScanner.findFieldResolver(field, resolverInfo).createDataFetcher();
    }

    static /* synthetic */ DataFetcher createFetcher$default(MethodFieldResolverDataFetcherTest methodFieldResolverDataFetcherTest, String string, GraphQLResolver graphQLResolver, List list, SchemaParserOptions schemaParserOptions, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            schemaParserOptions = SchemaParserOptions.Companion.defaultOptions();
        }
        return methodFieldResolverDataFetcherTest.createFetcher(string, graphQLResolver, list, schemaParserOptions);
    }

    private final DataFetchingEnvironment createEnvironment(Object source, Map<String, ? extends Object> arguments, GraphQLContext context) {
        DataFetchingEnvironment dataFetchingEnvironment = DataFetchingEnvironmentImpl.newDataFetchingEnvironment((ExecutionContext)this.buildExecutionContext()).source(source).arguments(arguments).graphQLContext(context).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataFetchingEnvironment, (String)"build(...)");
        return dataFetchingEnvironment;
    }

    static /* synthetic */ DataFetchingEnvironment createEnvironment$default(MethodFieldResolverDataFetcherTest methodFieldResolverDataFetcherTest, Object object, Map map, GraphQLContext graphQLContext, int n, Object object2) {
        if ((n & 1) != 0) {
            object = new Object();
        }
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            graphQLContext = null;
        }
        return methodFieldResolverDataFetcherTest.createEnvironment(object, map, graphQLContext);
    }

    private final ExecutionContext buildExecutionContext() {
        ExecutionStrategy executionStrategy2 = new ExecutionStrategy(){

            public CompletableFuture<ExecutionResult> execute(ExecutionContext executionContext, ExecutionStrategyParameters parameters) {
                Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                throw new AssertionError((Object)"should not be called");
            }
        };
        ExecutionId executionId = ExecutionId.from((String)"executionId123");
        ExecutionContext executionContext = ExecutionContextBuilder.newExecutionContextBuilder().instrumentation((Instrumentation)SimplePerformantInstrumentation.INSTANCE).executionId(executionId).queryStrategy(executionStrategy2).mutationStrategy(executionStrategy2).subscriptionStrategy(executionStrategy2).build();
        Intrinsics.checkNotNullExpressionValue((Object)executionContext, (String)"build(...)");
        return executionContext;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverDataFetcherTest$ContextClass;", "", "<init>", "()V", "graphql-java-tools"})
    public static final class ContextClass {
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverDataFetcherTest$DataClass;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-java-tools"})
    public static final class DataClass {
        @NotNull
        private final String name;

        public DataClass(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
        }

        public /* synthetic */ DataClass(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "TestName";
            }
            this(string);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final DataClass copy(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new DataClass(name);
        }

        public static /* synthetic */ DataClass copy$default(DataClass dataClass, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = dataClass.name;
            }
            return dataClass.copy(string);
        }

        @NotNull
        public String toString() {
            return "DataClass(name=" + this.name + ')';
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DataClass)) {
                return false;
            }
            DataClass dataClass = (DataClass)other;
            return Intrinsics.areEqual((Object)this.name, (Object)dataClass.name);
        }

        public DataClass() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverDataFetcherTest$DoubleChannel;", "Lgraphql/kickstart/tools/GraphQLResolver;", "Lgraphql/kickstart/tools/MethodFieldResolverDataFetcherTest$DataClass;", "<init>", "()V", "channel", "Lkotlinx/coroutines/channels/Channel;", "", "getChannel", "()Lkotlinx/coroutines/channels/Channel;", "onDataNameChanged", "Lkotlinx/coroutines/channels/ReceiveChannel;", "date", "graphql-java-tools"})
    public static final class DoubleChannel
    implements GraphQLResolver<DataClass> {
        @NotNull
        private final Channel<String> channel = ChannelKt.Channel$default((int)10, null, null, (int)6, null);

        public DoubleChannel() {
            this.channel.trySend-JP2dKIU((Object)"A");
            this.channel.trySend-JP2dKIU((Object)"B");
        }

        @NotNull
        public final Channel<String> getChannel() {
            return this.channel;
        }

        @NotNull
        public final ReceiveChannel<String> onDataNameChanged(@NotNull DataClass date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return (ReceiveChannel)this.channel;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverDataFetcherTest$InputClass;", "", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "graphql-java-tools"})
    public static final class InputClass {
        @Nullable
        private String name;

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u0006\u0010\n\u001a\u00020\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverDataFetcherTest$OnDataNameChanged;", "Lgraphql/kickstart/tools/GraphQLResolver;", "Lgraphql/kickstart/tools/MethodFieldResolverDataFetcherTest$DataClass;", "<init>", "()V", "channel", "Lkotlinx/coroutines/channels/Channel;", "", "onDataNameChanged", "Lkotlinx/coroutines/channels/ReceiveChannel;", "date", "graphql-java-tools"})
    public static final class OnDataNameChanged
    implements GraphQLResolver<DataClass> {
        @NotNull
        private final Channel<String> channel = ChannelKt.Channel$default((int)10, null, null, (int)6, null);

        public OnDataNameChanged() {
            this.channel.trySend-JP2dKIU((Object)"A");
            this.channel.close((Throwable)new IllegalStateException("Channel error"));
        }

        @NotNull
        public final ReceiveChannel<String> onDataNameChanged(@NotNull DataClass date) {
            Intrinsics.checkNotNullParameter((Object)date, (String)"date");
            return (ReceiveChannel)this.channel;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0086@\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0004\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverDataFetcherTest$SuspendClass;", "Lgraphql/kickstart/tools/GraphQLResolver;", "Lgraphql/kickstart/tools/MethodFieldResolverDataFetcherTest$DataClass;", "<init>", "()V", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "job", "Lkotlinx/coroutines/CompletableJob;", "options", "Lgraphql/kickstart/tools/SchemaParserOptions;", "getOptions$annotations", "getOptions", "()Lgraphql/kickstart/tools/SchemaParserOptions;", "isActive", "", "data", "(Lgraphql/kickstart/tools/MethodFieldResolverDataFetcherTest$DataClass;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "graphql-java-tools"})
    public static final class SuspendClass
    implements GraphQLResolver<DataClass> {
        @NotNull
        private final CoroutineDispatcher dispatcher = Dispatchers.getIO();
        @NotNull
        private final CompletableJob job = JobKt.Job$default(null, (int)1, null);
        @NotNull
        private final SchemaParserOptions options = new SchemaParserOptions.Builder().coroutineContext(this.dispatcher.plus((CoroutineContext)this.job)).build();

        @NotNull
        public final SchemaParserOptions getOptions() {
            return this.options;
        }

        @ExperimentalCoroutinesApi
        public static /* synthetic */ void getOptions$annotations() {
        }

        @Nullable
        public final Object isActive(@NotNull DataClass data, @NotNull Continuation<? super Boolean> $completion) {
            return Boxing.boxBoolean((Intrinsics.areEqual((Object)$completion.getContext().get(this.dispatcher.getKey()), (Object)this.dispatcher) && Intrinsics.areEqual((Object)$completion.getContext().get((CoroutineContext.Key)Job.Key), (Object)SequencesKt.first((Sequence)this.job.getChildren())) ? 1 : 0) != 0);
        }
    }
}

