/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.ExceptionWhileDataFetching;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLContext;
import graphql.execution.CoercedVariables;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserBuilder;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\r\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\b\u0010\u0007\u001a\u00020\u0005H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0007J\b\u0010\t\u001a\u00020\u0005H\u0007J\b\u0010\n\u001a\u00020\u0005H\u0007R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverTest;", "", "<init>", "()V", "should handle Optional type as method input argument", "", "should handle Optional type as method input argument with omission detection", "should handle scalar types as method input argument", "should handle lists of scalar types", "should handle proxies", "should unwrap and rethrow resolver exceptions", "customScalarType", "Lgraphql/schema/GraphQLScalarType;", "CustomScalar", "Resolver", "graphql-java-tools"})
public final class MethodFieldResolverTest {
    @NotNull
    private final GraphQLScalarType customScalarType;

    public MethodFieldResolverTest() {
        GraphQLScalarType graphQLScalarType = GraphQLScalarType.newScalar().name("CustomScalar").description("customScalar").coercing((Coercing)new Coercing<CustomScalar, String>(){

            public CustomScalar parseValue(Object input, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                return CustomScalar.Companion.of(input);
            }

            public CustomScalar parseLiteral(Value<?> input, CoercedVariables variables, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                if (!(input instanceof StringValue)) {
                    throw new CoercingParseLiteralException();
                }
                String string = ((StringValue)input).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                return CustomScalar.Companion.of(string);
            }

            public String serialize(Object dataFetcherResult, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter((Object)dataFetcherResult, (String)"dataFetcherResult");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                if (!(dataFetcherResult instanceof CustomScalar)) {
                    throw new CoercingSerializeException();
                }
                return ((CustomScalar)dataFetcherResult).getValue();
            }
        }).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLScalarType, (String)"build(...)");
        this.customScalarType = graphQLScalarType;
    }

    @Test
    public final void should handle Optional type as method input argument() {
        GraphQLScalarType[] graphQLScalarTypeArray = new GraphQLScalarType[]{this.customScalarType};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    testValue(input: String): String\n                    testOmitted(input: String): String\n                    testNull(input: String): String\n                }\n                ").scalars(graphQLScalarTypeArray);
        graphQLScalarTypeArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

            public final String testValue(Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }

            public final String testOmitted(Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }

            public final String testNull(Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
        }};
        GraphQLSchema schema2 = schemaParserBuilder.resolvers((GraphQLResolver[])graphQLScalarTypeArray).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("\n            query {\n                testValue(input: \"test-value\")\n                testOmitted\n                testNull(input: null)\n            }\n            ").root(new Object()));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"testValue", (Object)"Optional[test-value]"), TuplesKt.to((Object)"testOmitted", (Object)"Optional.empty"), TuplesKt.to((Object)"testNull", (Object)"Optional.empty")};
        TestUtilsKt.assertEquals(result.getData(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Test
    public final void should handle Optional type as method input argument with omission detection() {
        GraphQLScalarType[] graphQLScalarTypeArray = new GraphQLScalarType[]{this.customScalarType};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    testValue(input: String): String\n                    testOmitted(input: String): String\n                    testNull(input: String): String\n                }\n                ").scalars(graphQLScalarTypeArray);
        graphQLScalarTypeArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

            public final String testValue(Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }

            public final String testOmitted(Optional<String> input) {
                return String.valueOf(input);
            }

            public final String testNull(Optional<String> input) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
        }};
        GraphQLSchema schema2 = schemaParserBuilder.resolvers((GraphQLResolver[])graphQLScalarTypeArray).options(SchemaParserOptions.Companion.newOptions().inputArgumentOptionalDetectOmission(true).build()).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("\n            query {\n                testValue(input: \"test-value\")\n                testOmitted\n                testNull(input: null)\n            }\n            ").root(new Object()));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"testValue", (Object)"Optional[test-value]"), TuplesKt.to((Object)"testOmitted", (Object)"null"), TuplesKt.to((Object)"testNull", (Object)"Optional.empty")};
        TestUtilsKt.assertEquals(result.getData(), MapsKt.mapOf((Pair[])pairArray));
    }

    @Test
    public final void should handle scalar types as method input argument() {
        GraphQLScalarType[] graphQLScalarTypeArray = new GraphQLScalarType[]{this.customScalarType};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                scalar CustomScalar\n                type Query {\n                    test(input: CustomScalar): Int\n                }\n                ").scalars(graphQLScalarTypeArray);
        graphQLScalarTypeArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

            public final int test(CustomScalar scalar) {
                Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
                return scalar.getValue().length();
            }
        }};
        GraphQLSchema schema2 = schemaParserBuilder.resolvers((GraphQLResolver[])graphQLScalarTypeArray).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("\n            query Test($input: CustomScalar) {\n                test(input: $input)\n            }\n            ").variables(MapsKt.mapOf((Pair)TuplesKt.to((Object)"input", (Object)"FooBar"))).root(new Object()));
        TestUtilsKt.assertEquals(result.getData(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"test", (Object)6)));
    }

    @Test
    public final void should handle lists of scalar types() {
        GraphQLScalarType[] graphQLScalarTypeArray = new GraphQLScalarType[]{this.customScalarType};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                scalar CustomScalar\n                type Query {\n                    test(input: [CustomScalar]): Int\n                }\n                ").scalars(graphQLScalarTypeArray);
        graphQLScalarTypeArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

            /*
             * WARNING - void declaration
             */
            public final int test(List<CustomScalar> scalars) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkNotNullParameter(scalars, (String)"scalars");
                Iterable $this$map$iv = scalars;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CustomScalar customScalar = (CustomScalar)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getValue().length());
                }
                return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
            }
        }};
        GraphQLSchema schema2 = schemaParserBuilder.resolvers((GraphQLResolver[])graphQLScalarTypeArray).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        Object[] objectArray = new String[]{"Foo", "Bar"};
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("\n            query Test($input: [CustomScalar]) {\n                test(input: $input)\n            }\n            ").variables(MapsKt.mapOf((Pair)TuplesKt.to((Object)"input", (Object)CollectionsKt.listOf((Object[])objectArray)))).root(new Object()));
        TestUtilsKt.assertEquals(result.getData(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"test", (Object)6)));
    }

    @Test
    public final void should handle proxies() {
        InvocationHandler invocationHandler2 = new InvocationHandler(){

            /*
             * Unable to fully structure code
             */
            public Object invoke(Object proxy, Method method, Object[] args) {
                block12: {
                    block9: {
                        block10: {
                            block11: {
                                Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
                                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                                Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                                var4_4 = method.getName();
                                if (var4_4 == null) break block9;
                                switch (var4_4.hashCode()) {
                                    case 3556498: {
                                        if (!var4_4.equals("test")) {
                                            ** break;
                                        }
                                        break block10;
                                    }
                                    case 147696667: {
                                        if (var4_4.equals("hashCode")) break;
                                        ** break;
                                    }
                                    case -1295482945: {
                                        if (!var4_4.equals("equals")) {
                                            ** break;
                                        }
                                        break block11;
                                    }
                                    case -1776922004: {
                                        if (!var4_4.equals("toString")) ** break;
                                        v0 = (Serializable)("Proxy$" + System.identityHashCode(this));
                                        break block12;
                                    }
                                }
                                v0 = Integer.valueOf(System.identityHashCode(this));
                                break block12;
                            }
                            v0 = Boolean.valueOf(Proxy.isProxyClass(args[0].getClass()));
                            break block12;
                        }
                        v1 = args[0];
                        Intrinsics.checkNotNull((Object)v1, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                        $this$map$iv = (List)v1;
                        $i$f$map = false;
                        var7_7 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        var10_10 = $this$mapTo$iv$iv.iterator();
                        while (var10_10.hasNext()) {
                            var12_12 = item$iv$iv = var10_10.next();
                            var14_14 = destination$iv$iv;
                            $i$a$-map-MethodFieldResolverTest$should handle proxies$invocationHandler$1$invoke$1 = false;
                            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type graphql.kickstart.tools.MethodFieldResolverTest.CustomScalar");
                            var14_14.add(((CustomScalar)it).getValue().length());
                        }
                        v0 = Integer.valueOf(CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv)));
                        break block12;
                    }
                    v0 = new UnsupportedOperationException();
                }
                return v0;
            }
        };
        Class[] classArray = new Class[]{Resolver.class, GraphQLQueryResolver.class};
        Object object = Proxy.newProxyInstance(MethodFieldResolverTest.class.getClassLoader(), classArray, invocationHandler2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type graphql.kickstart.tools.GraphQLQueryResolver");
        GraphQLQueryResolver resolver2 = (GraphQLQueryResolver)object;
        classArray = new GraphQLScalarType[]{this.customScalarType};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                scalar CustomScalar\n                type Query {\n                    test(input: [CustomScalar]): Int\n                }\n                ").scalars((GraphQLScalarType[])classArray);
        classArray = new GraphQLResolver[]{resolver2};
        GraphQLSchema schema2 = schemaParserBuilder.resolvers((GraphQLResolver[])classArray).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        Object[] objectArray = new String[]{"Foo", "Bar"};
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("\n            query Test($input: [CustomScalar]) {\n                test(input: $input)\n            }\n            ").variables(MapsKt.mapOf((Pair)TuplesKt.to((Object)"input", (Object)CollectionsKt.listOf((Object[])objectArray)))).root(new Object()));
        TestUtilsKt.assertEquals(result.getData(), MapsKt.mapOf((Pair)TuplesKt.to((Object)"test", (Object)6)));
    }

    @Test
    public final void should unwrap and rethrow resolver exceptions() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

            public final String test() {
                throw new Exception("Whoops");
            }
        }};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    test: String\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("\n            query {\n                test\n            }\n            "));
        TestUtilsKt.assertEquals(result.getErrors().size(), 1);
        Object e = result.getErrors().get(0);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type graphql.ExceptionWhileDataFetching");
        ExceptionWhileDataFetching exceptionWhileDataFetching = (ExceptionWhileDataFetching)e;
        TestUtilsKt.assertEquals(exceptionWhileDataFetching.getException().getMessage(), "Whoops");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverTest$CustomScalar;", "", "internalValue", "", "<init>", "(Ljava/lang/String;)V", "value", "getValue", "()Ljava/lang/String;", "Companion", "graphql-java-tools"})
    public static final class CustomScalar {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String internalValue;

        private CustomScalar(String internalValue) {
            this.internalValue = internalValue;
        }

        @NotNull
        public final String getValue() {
            return this.internalValue;
        }

        public /* synthetic */ CustomScalar(String internalValue, DefaultConstructorMarker $constructor_marker) {
            this(internalValue);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverTest$CustomScalar$Companion;", "", "<init>", "()V", "of", "Lgraphql/kickstart/tools/MethodFieldResolverTest$CustomScalar;", "input", "graphql-java-tools"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final CustomScalar of(@NotNull Object input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                if (!(input instanceof String)) {
                    throw new IllegalArgumentException();
                }
                return new CustomScalar((String)input, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverTest$Resolver;", "", "test", "", "scalars", "", "Lgraphql/kickstart/tools/MethodFieldResolverTest$CustomScalar;", "graphql-java-tools"})
    public static interface Resolver {
        public int test(@NotNull List<CustomScalar> var1);
    }
}

