/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.schema.GraphQLSchema;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0006\u0007\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/ReactiveTest;", "", "<init>", "()V", "futureSucceeds", "", "Query", "Organization", "User", "graphql-java-tools"})
public final class ReactiveTest {
    @Test
    public final void futureSucceeds() {
        SchemaParserOptions options = SchemaParserOptions.Companion.newOptions().build();
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new Query()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().file("Reactive.graphqls").resolvers(graphQLResolverArray).options(options).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        Intrinsics.checkNotNull((Object)gql);
        TestUtilsKt.assertNoGraphQlErrors$default(gql, null, null, ReactiveTest::futureSucceeds$lambda$0, 6, null);
    }

    private static final String futureSucceeds$lambda$0() {
        return "query { organization(organizationId: 1) { user { id } } }";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/ReactiveTest$Organization;", "", "<init>", "()V", "user", "Lgraphql/kickstart/tools/ReactiveTest$User;", "graphql-java-tools"})
    private static final class Organization {
        @Nullable
        private final User user;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/ReactiveTest$Query;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "<init>", "()V", "organization", "Ljava/util/concurrent/Future;", "Ljava/util/Optional;", "Lgraphql/kickstart/tools/ReactiveTest$Organization;", "organizationid", "", "graphql-java-tools"})
    private static final class Query
    implements GraphQLQueryResolver {
        @NotNull
        public final Future<Optional<Organization>> organization(int organizationid) {
            CompletableFuture<Optional<Organization>> completableFuture = CompletableFuture.completedFuture(Optional.of(new Organization()));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/ReactiveTest$User;", "", "<init>", "()V", "id", "", "Ljava/lang/Long;", "name", "", "graphql-java-tools"})
    private static final class User {
        @Nullable
        private final Long id;
        @Nullable
        private final String name;
    }
}

