/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.GraphQLContext;
import graphql.execution.CoercedVariables;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserBuilder;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0007J\b\u0010\t\u001a\u00020\u0005H\u0007J\b\u0010\n\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerDirectiveTest;", "", "<init>", "()V", "scanner should handle directives with scalar input value", "", "customValueScalar", "Lgraphql/schema/GraphQLScalarType;", "scanner should handle directives with enum input value", "scanner should handle directives with input object input value", "scanner should handle directives with arguments with directives", "CustomValue", "CustomEnum", "CustomInput", "graphql-java-tools"})
public final class SchemaClassScannerDirectiveTest {
    @NotNull
    private final GraphQLScalarType customValueScalar;

    public SchemaClassScannerDirectiveTest() {
        GraphQLScalarType graphQLScalarType = GraphQLScalarType.newScalar().name("CustomValue").coercing((Coercing)new Coercing<CustomValue, String>(){

            public String serialize(Object input, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                return input.toString();
            }

            public CustomValue parseValue(Object input, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                return new CustomValue(input.toString());
            }

            public CustomValue parseLiteral(Value<?> input, CoercedVariables variables, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                String string = ((StringValue)input).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                return new CustomValue(string);
            }
        }).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLScalarType, (String)"build(...)");
        this.customValueScalar = graphQLScalarType;
    }

    @Test
    public final void scanner should handle directives with scalar input value() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

            public final String string() {
                return "hello";
            }
        }};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                scalar CustomValue\n                directive @doSomething(value: CustomValue) on FIELD_DEFINITION \n\n                type Query {\n                    string: String @doSomething(value: \"some thing\")\n                }\n                ").resolvers(graphQLResolverArray);
        graphQLResolverArray = new GraphQLScalarType[]{this.customValueScalar};
        GraphQLSchema schema2 = schemaParserBuilder.scalars((GraphQLScalarType[])graphQLResolverArray).build().makeExecutableSchema();
        CustomValue value = (CustomValue)schema2.getQueryType().getFieldDefinition("string").getAppliedDirective("doSomething").getArgument("value").getValue();
        TestUtilsKt.assertEquals(value.getValue(), "some thing");
    }

    @Test
    public final void scanner should handle directives with enum input value() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

            public final String string() {
                return "hello";
            }

            public final CustomEnum another() {
                return CustomEnum.ONE;
            }
        }};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                enum CustomEnum { ONE TWO THREE }\n                directive @doSomething(value: CustomEnum) on FIELD_DEFINITION \n\n                type Query {\n                    string: String @doSomething(value: ONE)\n                    another: CustomEnum\n                }\n                ").resolvers(graphQLResolverArray);
        graphQLResolverArray = new GraphQLScalarType[]{this.customValueScalar};
        GraphQLSchema schema2 = schemaParserBuilder.scalars((GraphQLScalarType[])graphQLResolverArray).build().makeExecutableSchema();
        CustomEnum value = (CustomEnum)((Object)schema2.getQueryType().getFieldDefinition("string").getAppliedDirective("doSomething").getArgument("value").getValue());
        TestUtilsKt.assertEquals(value, CustomEnum.ONE);
    }

    @Test
    public final void scanner should handle directives with input object input value() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

            public final String string() {
                return "hello";
            }

            public final String another(CustomInput input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                return input.getValue();
            }
        }};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                input CustomInput { value: String }\n                directive @doSomething(input: CustomInput) on FIELD_DEFINITION\n                \n                type Query {\n                    string: String @doSomething(input: { value: \"some value\" })\n                    another(input: CustomInput): String\n                }\n                ").resolvers(graphQLResolverArray);
        graphQLResolverArray = new GraphQLScalarType[]{this.customValueScalar};
        GraphQLSchema schema2 = schemaParserBuilder.scalars((GraphQLScalarType[])graphQLResolverArray).build().makeExecutableSchema();
        Object object = schema2.getQueryType().getFieldDefinition("string").getAppliedDirective("doSomething").getArgument("input").getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        Map map = (Map)object;
        String string = "value";
        Object value = map.get(string);
        TestUtilsKt.assertEquals(value, "some value");
    }

    @Test
    public final void scanner should handle directives with arguments with directives() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

            public final String string() {
                return "hello";
            }
        }};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                directive @doSomething(one: String @somethingElse) on FIELD_DEFINITION | ARGUMENT_DEFINITION\n                directive @somethingElse(two: String @doSomething) on FIELD_DEFINITION | ARGUMENT_DEFINITION\n                \n                type Query {\n                    string: String @doSomething(one: \"sss\")\n                }\n                ").resolvers(graphQLResolverArray);
        graphQLResolverArray = new GraphQLScalarType[]{this.customValueScalar};
        GraphQLSchema schema2 = schemaParserBuilder.scalars((GraphQLScalarType[])graphQLResolverArray).build().makeExecutableSchema();
        Object object = (GraphQLDirective)schema2.getDirectivesByName().get("doSomething");
        TestUtilsKt.assertNotNull(object != null && (object = object.getArgument("one")) != null && (object = object.getDirectivesByName()) != null ? (GraphQLDirective)object.get("somethingElse") : null);
        Object object2 = (GraphQLDirective)schema2.getDirectivesByName().get("somethingElse");
        TestUtilsKt.assertNotNull(object2 != null && (object2 = object2.getArgument("two")) != null && (object2 = object2.getDirectivesByName()) != null ? (GraphQLDirective)object2.get("doSomething") : null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerDirectiveTest$CustomEnum;", "", "<init>", "(Ljava/lang/String;I)V", "ONE", "TWO", "THREE", "graphql-java-tools"})
    public static final class CustomEnum
    extends Enum<CustomEnum> {
        public static final /* enum */ CustomEnum ONE = new CustomEnum();
        public static final /* enum */ CustomEnum TWO = new CustomEnum();
        public static final /* enum */ CustomEnum THREE = new CustomEnum();
        private static final /* synthetic */ CustomEnum[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CustomEnum[] values() {
            return (CustomEnum[])$VALUES.clone();
        }

        public static CustomEnum valueOf(String value) {
            return Enum.valueOf(CustomEnum.class, value);
        }

        @NotNull
        public static EnumEntries<CustomEnum> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = customEnumArray = new CustomEnum[]{CustomEnum.ONE, CustomEnum.TWO, CustomEnum.THREE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerDirectiveTest$CustomInput;", "", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-java-tools"})
    public static final class CustomInput {
        @NotNull
        private final String value;

        public CustomInput(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final CustomInput copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new CustomInput(value);
        }

        public static /* synthetic */ CustomInput copy$default(CustomInput customInput, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = customInput.value;
            }
            return customInput.copy(string);
        }

        @NotNull
        public String toString() {
            return "CustomInput(value=" + this.value + ')';
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CustomInput)) {
                return false;
            }
            CustomInput customInput = (CustomInput)other;
            return Intrinsics.areEqual((Object)this.value, (Object)customInput.value);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerDirectiveTest$CustomValue;", "", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-java-tools"})
    public static final class CustomValue {
        @NotNull
        private final String value;

        public CustomValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final CustomValue copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new CustomValue(value);
        }

        public static /* synthetic */ CustomValue copy$default(CustomValue customValue, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = customValue.value;
            }
            return customValue.copy(string);
        }

        @NotNull
        public String toString() {
            return "CustomValue(value=" + this.value + ')';
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CustomValue)) {
                return false;
            }
            CustomValue customValue = (CustomValue)other;
            return Intrinsics.areEqual((Object)this.value, (Object)customValue.value);
        }
    }
}

