/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.GraphQLContext;
import graphql.execution.CoercedVariables;
import graphql.kickstart.tools.Animal;
import graphql.kickstart.tools.GraphQLMutationResolver;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserBuilder;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.SomeInterface;
import graphql.kickstart.tools.TestUtilsKt;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u00002\u00020\u0001:\u0015\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\b\u0010\u0007\u001a\u00020\u0005H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0007J\b\u0010\t\u001a\u00020\u0005H\u0007J\b\u0010\n\u001a\u00020\u0005H\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0007J\b\u0010\f\u001a\u00020\u0005H\u0007J\b\u0010\r\u001a\u00020\u0005H\u0007J\b\u0010\u000e\u001a\u00020\u0005H\u0007J\b\u0010\u000f\u001a\u00020\u0005H\u0007J\b\u0010\u0010\u001a\u00020\u0005H\u0007J\b\u0010\u0011\u001a\u00020\u0005H\u0007J\b\u0010\u0014\u001a\u00020\u0005H\u0007R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest;", "", "<init>", "()V", "scanner handles futures and immediate return types", "", "scanner handles primitive and boxed return types", "scanner handles different scalars with same java class", "scanner handles interfaces referenced by objects that aren't explicitly used", "scanner handles input types that reference other input types", "scanner handles input types extensions", "scanner allows multiple return types for custom scalars", "scanner handles multiple interfaces that are not used as field types", "scanner handles interface implementation that is not used as field type", "scanner handles custom scalars when matching input types", "scanner allows class to be used for object type and input object type", "scanner should handle nested types in input types", "scanner should handle unused types when option is true", "fieldSetScalar", "Lgraphql/schema/GraphQLScalarType;", "scanner should handle unused types with interfaces when option is true", "FutureImmediateQuery", "PrimitiveBoxedQuery", "ScalarDuplicateQuery", "InterfaceMissingQuery", "MultipleInputTypeQuery", "ScalarsWithMultipleTypes", "MultipleInterfaces", "NamedResource", "VersionedResource", "InterfaceImplementation", "HasMapField", "Pojo", "NestedInterfaceTypeQuery", "FieldSet", "LinkPurpose", "Product", "User", "Address", "Whatever", "Unused", "Implementation", "graphql-java-tools"})
@SourceDebugExtension(value={"SMAP\nSchemaClassScannerTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaClassScannerTest.kt\ngraphql/kickstart/tools/SchemaClassScannerTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,559:1\n1#2:560\n1788#3,4:561\n808#3,11:565\n1374#3:576\n1460#3,5:577\n1788#3,4:582\n1788#3,4:586\n808#3,11:590\n1761#3,3:601\n1761#3,3:604\n808#3,11:607\n808#3,11:618\n1761#3,3:629\n1761#3,3:632\n1761#3,3:635\n*S KotlinDebug\n*F\n+ 1 SchemaClassScannerTest.kt\ngraphql/kickstart/tools/SchemaClassScannerTest\n*L\n125#1:561,4\n180#1:565,11\n181#1:576\n181#1:577,5\n248#1:582,4\n296#1:586,4\n472#1:590,11\n473#1:601,3\n474#1:604,3\n538#1:607,11\n539#1:618,11\n540#1:629,3\n541#1:632,3\n542#1:635,3\n*E\n"})
public final class SchemaClassScannerTest {
    @NotNull
    private final GraphQLScalarType fieldSetScalar;

    public SchemaClassScannerTest() {
        GraphQLScalarType graphQLScalarType = GraphQLScalarType.newScalar().name("FieldSet").coercing((Coercing)new Coercing<FieldSet, String>(){

            public String serialize(Object input, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                return input.toString();
            }

            public FieldSet parseValue(Object input, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                return new FieldSet(input.toString());
            }

            public FieldSet parseLiteral(Value<?> input, CoercedVariables variables, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                return new FieldSet(input.toString());
            }
        }).build();
        Intrinsics.checkNotNullExpressionValue((Object)graphQLScalarType, (String)"build(...)");
        this.fieldSetScalar = graphQLScalarType;
    }

    @Test
    public final void scanner handles futures and immediate return types() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new FutureImmediateQuery()};
        SchemaParser.Companion.newParser().resolvers(graphQLResolverArray).schemaString("\n                type Query {\n                    future: Int!\n                    immediate: Int!\n                }\n                ").build();
    }

    @Test
    public final void scanner handles primitive and boxed return types() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new PrimitiveBoxedQuery()};
        SchemaParser.Companion.newParser().resolvers(graphQLResolverArray).schemaString("\n                type Query {\n                    primitive: Int!\n                    boxed: Int!\n                }\n                ").build();
    }

    @Test
    public final void scanner handles different scalars with same java class() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new ScalarDuplicateQuery()};
        SchemaParser.Companion.newParser().resolvers(graphQLResolverArray).schemaString("\n                type Query {\n                    string: String!\n                    id: ID!\n                }\n                ").build();
    }

    @Test
    public final void scanner handles interfaces referenced by objects that aren't explicitly used() {
        Object v1;
        block1: {
            GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new InterfaceMissingQuery()};
            GraphQLSchema schema2 = SchemaParser.Companion.newParser().resolvers(graphQLResolverArray).schemaString("\n                interface Interface {\n                    id: ID!\n                }\n\n                type Query implements Interface {\n                    id: ID!\n                }\n                ").build().makeExecutableSchema();
            Set set = schema2.getAdditionalTypes();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAdditionalTypes(...)");
            Iterable iterable = set;
            for (Object t : iterable) {
                GraphQLType it = (GraphQLType)t;
                boolean bl = false;
                if (!(it instanceof GraphQLInterfaceType)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        GraphQLType interfaceType = v1;
        TestUtilsKt.assertNotNull(interfaceType);
    }

    @Test
    public final void scanner handles input types that reference other input types() {
        int n;
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new MultipleInputTypeQuery()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().resolvers(graphQLResolverArray).schemaString("\n                input FirstInput {\n                    id: String!\n                    second: SecondInput!\n                    third: ThirdInput!\n                }\n                input SecondInput {\n                    id: String!\n                }\n                input ThirdInput {\n                    id: String!\n                }\n\n                type Query {\n                    test(input: FirstInput): String!\n                }\n                ").build().makeExecutableSchema();
        Set set = schema2.getAdditionalTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAdditionalTypes(...)");
        Iterable $this$count$iv = set;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                GraphQLType it = (GraphQLType)element$iv;
                boolean bl = false;
                if (!(it instanceof GraphQLInputType) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int inputTypeCount = n;
        TestUtilsKt.assertEquals(inputTypeCount, 3);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void scanner handles input types extensions() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new GraphQLMutationResolver(){

            public final boolean save(Map<?, ?> map) {
                Intrinsics.checkNotNullParameter(map, (String)"map");
                return true;
            }
        }, new GraphQLQueryResolver(){

            public final boolean test() {
                return true;
            }
        }};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                type Query { test: Boolean }\n\n                type Mutation {\n                    save(input: UserInput!): Boolean\n                }\n                \n                input UserInput {\n                    name: String                        \n                }\n                \n                extend input UserInput {\n                    password: String\n                }\n                ").resolvers(graphQLResolverArray).build().makeExecutableSchema();
        Set set = schema2.getAdditionalTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAdditionalTypes(...)");
        Iterable $this$filterIsInstance$iv = set;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof GraphQLInputObjectType)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            GraphQLInputObjectType it = (GraphQLInputObjectType)element$iv$iv;
            boolean bl = false;
            List list = it.getExtensionDefinitions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExtensionDefinitions(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        int inputTypeExtensionCount = ((Collection)((List)destination$iv$iv)).size();
        TestUtilsKt.assertEquals(inputTypeExtensionCount, 1);
    }

    @Test
    public final void scanner allows multiple return types for custom scalars() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new ScalarsWithMultipleTypes()};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().resolvers(graphQLResolverArray);
        graphQLResolverArray = new GraphQLScalarType[]{GraphQLScalarType.newScalar().name("UUID").description("Test scalars with duplicate types").coercing((Coercing)new Coercing<Object, Object>(){

            public Object serialize(Object dataFetcherResult, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter((Object)dataFetcherResult, (String)"dataFetcherResult");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                return null;
            }

            public Object parseValue(Object input, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                return input;
            }

            public Object parseLiteral(Value<?> input, CoercedVariables variables, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                return input;
            }
        }).build()};
        GraphQLSchema schema2 = schemaParserBuilder.scalars((GraphQLScalarType[])graphQLResolverArray).schemaString("\n                scalar UUID\n\n                type Query {\n                    first: UUID\n                    second: UUID\n                }\n                ").build().makeExecutableSchema();
        boolean bl = schema2.getTypeMap().containsKey("UUID");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    public final void scanner handles multiple interfaces that are not used as field types() {
        int n;
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new MultipleInterfaces()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().resolvers(graphQLResolverArray).schemaString("\n                type Query {\n                    query1: NamedResourceImpl\n                    query2: VersionedResourceImpl\n                }\n\n                interface NamedResource {\n                    name: String!\n                }\n\n                interface VersionedResource {\n                    version: Int!\n                }\n\n                type NamedResourceImpl implements NamedResource {\n                    name: String!\n                }\n\n                type VersionedResourceImpl implements VersionedResource {\n                    version: Int!\n                }\n                ").build().makeExecutableSchema();
        Set set = schema2.getAdditionalTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAdditionalTypes(...)");
        Iterable $this$count$iv = set;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                GraphQLType it = (GraphQLType)element$iv;
                boolean bl = false;
                if (!(it instanceof GraphQLInterfaceType) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int interfaceTypeCount = n;
        TestUtilsKt.assertEquals(interfaceTypeCount, 2);
    }

    @Test
    public final void scanner handles interface implementation that is not used as field type() {
        int n;
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new InterfaceImplementation()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().dictionary(Reflection.getOrCreateKotlinClass(InterfaceImplementation.NamedResourceImpl.class)).resolvers(graphQLResolverArray).schemaString("\n                type Query {\n                    query1: NamedResource\n                }\n\n                interface NamedResource {\n                    name: String!\n                }\n\n                type NamedResourceImpl implements NamedResource {\n                    name: String!\n                }\n                ").build().makeExecutableSchema();
        Set set = schema2.getAdditionalTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAdditionalTypes(...)");
        Iterable $this$count$iv = set;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                GraphQLType it = (GraphQLType)element$iv;
                boolean bl = false;
                if (!(it instanceof GraphQLInterfaceType) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int interfaceTypeCount = n;
        TestUtilsKt.assertEquals(interfaceTypeCount, 1);
    }

    @Test
    public final void scanner handles custom scalars when matching input types() {
        GraphQLScalarType customMap2 = GraphQLScalarType.newScalar().name("customMap").coercing((Coercing)new Coercing<Map<String, ? extends Object>, Map<String, ? extends Object>>(){

            public Map<String, Object> serialize(Object dataFetcherResult, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter((Object)dataFetcherResult, (String)"dataFetcherResult");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                return MapsKt.emptyMap();
            }

            public Map<String, Object> parseValue(Object input, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                return MapsKt.emptyMap();
            }

            public Map<String, Object> parseLiteral(Value<?> input, CoercedVariables variables, GraphQLContext context, Locale locale) {
                Intrinsics.checkNotNullParameter(input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
                return MapsKt.emptyMap();
            }
        }).build();
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

            public final boolean hasRawScalar(Map<String, ? extends Object> rawScalar) {
                Intrinsics.checkNotNullParameter(rawScalar, (String)"rawScalar");
                return true;
            }

            public final boolean hasMapField(HasMapField mapField) {
                Intrinsics.checkNotNullParameter((Object)mapField, (String)"mapField");
                return true;
            }
        }};
        SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().resolvers(graphQLResolverArray);
        graphQLResolverArray = new GraphQLScalarType[]{customMap2};
        GraphQLSchema schema2 = schemaParserBuilder.scalars((GraphQLScalarType[])graphQLResolverArray).schemaString("\n                type Query {\n                    hasRawScalar(customMap: customMap): Boolean\n                    hasMapField(mapField: HasMapField): Boolean\n                }\n\n                input HasMapField {\n                    map: customMap\n                }\n\n                scalar customMap\n                ").build().makeExecutableSchema();
        boolean bl = schema2.getTypeMap().containsKey("customMap");
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Test
    public final void scanner allows class to be used for object type and input object type() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

            public final Pojo test(Pojo pojo) {
                Intrinsics.checkNotNullParameter((Object)pojo, (String)"pojo");
                return pojo;
            }
        }};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().resolvers(graphQLResolverArray).schemaString("\n                type Query {\n                    test(inPojo: InPojo): OutPojo\n                }\n\n                input InPojo {\n                    name: String\n                }\n\n                type OutPojo {\n                    name: String\n                }\n                ").build().makeExecutableSchema();
        Set set = schema2.getAdditionalTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAdditionalTypes(...)");
        int typeCount = ((Collection)set).size();
        TestUtilsKt.assertEquals(typeCount, 2);
    }

    @Test
    public final void scanner should handle nested types in input types() {
        GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new NestedInterfaceTypeQuery()};
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                schema {\n                    query: Query\n                }\n                \n                type Query {\n                    animal: Animal\n                }\n                \n                interface Animal {\n                    type: ComplexType\n                }\n                \n                type Dog implements Animal {\n                    type: ComplexType\n                }\n                \n                type ComplexType {\n                    id: String\n                }\n                ").resolvers(graphQLResolverArray).dictionary(Reflection.getOrCreateKotlinClass(NestedInterfaceTypeQuery.Dog.class)).build().makeExecutableSchema();
        Set set = schema2.getAdditionalTypes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAdditionalTypes(...)");
        int typeCount = ((Collection)set).size();
        TestUtilsKt.assertEquals(typeCount, 3);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void scanner should handle unused types when option is true() {
        boolean bl;
        block10: {
            boolean bl2;
            boolean $this$any$iv2;
            boolean $i$f$any2;
            List objectTypes;
            block9: {
                boolean bl3;
                void $this$filterIsInstanceTo$iv$iv;
                GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

                    public final List<Product> allProducts() {
                        return null;
                    }
                }};
                SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                # these directives are defined in the Apollo Federation Specification: \n                # https://www.apollographql.com/docs/apollo-server/federation/federation-spec/\n                scalar FieldSet\n                scalar link__Import\n                enum link__Purpose { SECURITY EXECUTION }\n                directive @key(fields: FieldSet!, resolvable: Boolean = true) repeatable on OBJECT | INTERFACE\n                directive @extends on OBJECT | INTERFACE\n                directive @external on FIELD_DEFINITION | OBJECT\n                directive @link(url: String!, as: String, for: link__Purpose) repeatable on SCHEMA\n\n                extend schema @link(url: \"https://specs.apollo.dev/federation/v2.0\", import: [\"@key\", \"@shareable\"])\n\n                # Let's say this is the Products service from Apollo Federation Introduction\n                type Query {\n                    allProducts: [Product]\n                }\n                \n                type Product {\n                    name: String\n                }\n                \n                type User @key(fields: \"id\") @extends {\n                    id: ID! @external\n                    recentPurchasedProducts: [Product]\n                    address: Address\n                }\n                \n                type Address {\n                    street: String\n                }\n                ").resolvers(graphQLResolverArray).options(SchemaParserOptions.Companion.newOptions().includeUnusedTypes(true).build()).dictionary(Reflection.getOrCreateKotlinClass(User.class)).dictionary("link__Purpose", Reflection.getOrCreateKotlinClass(LinkPurpose.class));
                graphQLResolverArray = new GraphQLScalarType[]{this.fieldSetScalar};
                GraphQLSchema schema2 = schemaParserBuilder.scalars((GraphQLScalarType[])graphQLResolverArray).build().makeExecutableSchema();
                Set set = schema2.getAdditionalTypes();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAdditionalTypes(...)");
                Iterable $this$filterIsInstance$iv = set;
                boolean $i$f$filterIsInstance = false;
                Iterator iterator = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof GraphQLObjectType)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                objectTypes = (List)destination$iv$iv;
                Iterable $this$any$iv2 = objectTypes;
                $i$f$any2 = false;
                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv2) {
                        GraphQLObjectType it = (GraphQLObjectType)element$iv;
                        boolean bl4 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"User")) continue;
                        bl3 = true;
                        break block9;
                    }
                    bl3 = $this$any$iv2 = false;
                }
            }
            if (_Assertions.ENABLED && !$this$any$iv2) {
                String $i$f$any2 = "Assertion failed";
                throw new AssertionError((Object)$i$f$any2);
            }
            Iterable $this$any$iv2 = objectTypes;
            $i$f$any2 = false;
            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv2) {
                    GraphQLObjectType it = (GraphQLObjectType)element$iv;
                    boolean bl5 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Address")) continue;
                    bl2 = true;
                    break block10;
                }
                bl2 = bl = false;
            }
        }
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public final void scanner should handle unused types with interfaces when option is true() {
        boolean bl;
        block16: {
            boolean bl2;
            boolean $this$any$iv22;
            boolean $i$f$any2;
            List interfaceTypes;
            block15: {
                boolean bl3;
                boolean $this$any$iv3;
                List objectTypes;
                block14: {
                    boolean bl4;
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$filterIsInstanceTo$iv$iv2;
                    GraphQLResolver[] graphQLResolverArray = new GraphQLResolver[]{new GraphQLQueryResolver(){

                        public final Whatever whatever() {
                            return null;
                        }
                    }};
                    SchemaParserBuilder schemaParserBuilder = SchemaParser.Companion.newParser().schemaString("\n                type Query {\n                    whatever: Whatever\n                }\n\n                type Whatever {\n                    value: String\n                }\n\n                type Unused {\n                    someInterface: SomeInterface\n                }\n\n                interface SomeInterface {\n                    value: String\n                }\n\n                type Implementation implements SomeInterface {\n                    value: String\n                }\n                ").resolvers(graphQLResolverArray).options(SchemaParserOptions.Companion.newOptions().includeUnusedTypes(true).build());
                    graphQLResolverArray = new KClass[]{Reflection.getOrCreateKotlinClass(Unused.class), Reflection.getOrCreateKotlinClass(Implementation.class)};
                    GraphQLSchema schema2 = schemaParserBuilder.dictionary((KClass[])graphQLResolverArray).build().makeExecutableSchema();
                    Set set = schema2.getAdditionalTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAdditionalTypes(...)");
                    Iterable $this$filterIsInstance$iv = set;
                    boolean $i$f$filterIsInstance = false;
                    Iterable iterable = $this$filterIsInstance$iv;
                    Iterable destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
                        if (!(element$iv$iv instanceof GraphQLObjectType)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    objectTypes = (List)destination$iv$iv;
                    Set set2 = schema2.getAdditionalTypes();
                    Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getAdditionalTypes(...)");
                    Iterable $this$filterIsInstance$iv2 = set2;
                    boolean $i$f$filterIsInstance2 = false;
                    destination$iv$iv = $this$filterIsInstance$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterIsInstanceTo2 = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof GraphQLInterfaceType)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    interfaceTypes = (List)destination$iv$iv2;
                    Iterable $this$any$iv3 = objectTypes;
                    $i$f$any2 = false;
                    if ($this$any$iv3 instanceof Collection && ((Collection)$this$any$iv3).isEmpty()) {
                        bl4 = false;
                    } else {
                        for (Object element$iv : $this$any$iv3) {
                            GraphQLObjectType it = (GraphQLObjectType)element$iv;
                            boolean bl5 = false;
                            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Unused")) continue;
                            bl4 = true;
                            break block14;
                        }
                        bl4 = $this$any$iv3 = false;
                    }
                }
                if (_Assertions.ENABLED && !$this$any$iv3) {
                    String $i$f$any2 = "Assertion failed";
                    throw new AssertionError((Object)$i$f$any2);
                }
                Iterable $this$any$iv22 = objectTypes;
                $i$f$any2 = false;
                if ($this$any$iv22 instanceof Collection && ((Collection)$this$any$iv22).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv22) {
                        GraphQLObjectType it = (GraphQLObjectType)element$iv;
                        boolean bl6 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Implementation")) continue;
                        bl3 = true;
                        break block15;
                    }
                    bl3 = $this$any$iv22 = false;
                }
            }
            if (_Assertions.ENABLED && !$this$any$iv22) {
                String $i$f$any3 = "Assertion failed";
                throw new AssertionError((Object)$i$f$any3);
            }
            Iterable $this$any$iv = interfaceTypes;
            $i$f$any2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GraphQLInterfaceType it = (GraphQLInterfaceType)element$iv;
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)"SomeInterface")) continue;
                    bl2 = true;
                    break block16;
                }
                bl2 = bl = false;
            }
        }
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$Address;", "", "<init>", "()V", "street", "", "getStreet", "()Ljava/lang/String;", "setStreet", "(Ljava/lang/String;)V", "graphql-java-tools"})
    public static final class Address {
        @Nullable
        private String street;

        @Nullable
        public final String getStreet() {
            return this.street;
        }

        public final void setStreet(@Nullable String string) {
            this.street = string;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$FieldSet;", "", "value", "", "<init>", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-java-tools"})
    public static final class FieldSet {
        @NotNull
        private final String value;

        public FieldSet(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.value;
        }

        @NotNull
        public final FieldSet copy(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new FieldSet(value);
        }

        public static /* synthetic */ FieldSet copy$default(FieldSet fieldSet, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = fieldSet.value;
            }
            return fieldSet.copy(string);
        }

        @NotNull
        public String toString() {
            return "FieldSet(value=" + this.value + ')';
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FieldSet)) {
                return false;
            }
            FieldSet fieldSet = (FieldSet)other;
            return Intrinsics.areEqual((Object)this.value, (Object)fieldSet.value);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$FutureImmediateQuery;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "<init>", "()V", "future", "Ljava/util/concurrent/CompletableFuture;", "", "immediate", "graphql-java-tools"})
    private static final class FutureImmediateQuery
    implements GraphQLQueryResolver {
        @NotNull
        public final CompletableFuture<Integer> future() {
            CompletableFuture<Integer> completableFuture = CompletableFuture.completedFuture(1);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }

        public final int immediate() {
            return 1;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R(\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$HasMapField;", "", "<init>", "()V", "map", "", "", "getMap", "()Ljava/util/Map;", "setMap", "(Ljava/util/Map;)V", "graphql-java-tools"})
    public static final class HasMapField {
        @Nullable
        private Map<String, ? extends Object> map;

        @Nullable
        public final Map<String, Object> getMap() {
            return this.map;
        }

        public final void setMap(@Nullable Map<String, ? extends Object> map) {
            this.map = map;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$Implementation;", "Lgraphql/kickstart/tools/SomeInterface;", "<init>", "()V", "getValue", "", "graphql-java-tools"})
    public static final class Implementation
    implements SomeInterface {
        @Override
        @Nullable
        public String getValue() {
            return null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$InterfaceImplementation;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "<init>", "()V", "query1", "Lgraphql/kickstart/tools/SchemaClassScannerTest$NamedResource;", "query2", "Lgraphql/kickstart/tools/SchemaClassScannerTest$InterfaceImplementation$NamedResourceImpl;", "NamedResourceImpl", "graphql-java-tools"})
    public static final class InterfaceImplementation
    implements GraphQLQueryResolver {
        @Nullable
        public final NamedResource query1() {
            return null;
        }

        @Nullable
        public final NamedResourceImpl query2() {
            return null;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$InterfaceImplementation$NamedResourceImpl;", "Lgraphql/kickstart/tools/SchemaClassScannerTest$NamedResource;", "<init>", "()V", "name", "", "graphql-java-tools"})
        public static final class NamedResourceImpl
        implements NamedResource {
            @Override
            @Nullable
            public String name() {
                return null;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$InterfaceMissingQuery;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "<init>", "()V", "id", "", "graphql-java-tools"})
    private static final class InterfaceMissingQuery
    implements GraphQLQueryResolver {
        @NotNull
        public final String id() {
            return "";
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$LinkPurpose;", "", "<init>", "(Ljava/lang/String;I)V", "SECURITY", "EXECUTION", "graphql-java-tools"})
    public static final class LinkPurpose
    extends Enum<LinkPurpose> {
        public static final /* enum */ LinkPurpose SECURITY = new LinkPurpose();
        public static final /* enum */ LinkPurpose EXECUTION = new LinkPurpose();
        private static final /* synthetic */ LinkPurpose[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static LinkPurpose[] values() {
            return (LinkPurpose[])$VALUES.clone();
        }

        public static LinkPurpose valueOf(String value) {
            return Enum.valueOf(LinkPurpose.class, value);
        }

        @NotNull
        public static EnumEntries<LinkPurpose> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = linkPurposeArray = new LinkPurpose[]{LinkPurpose.SECURITY, LinkPurpose.EXECUTION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0003\b\t\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$MultipleInputTypeQuery;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "<init>", "()V", "test", "", "input", "Lgraphql/kickstart/tools/SchemaClassScannerTest$MultipleInputTypeQuery$FirstInput;", "FirstInput", "SecondInput", "ThirdInput", "graphql-java-tools"})
    private static final class MultipleInputTypeQuery
    implements GraphQLQueryResolver {
        @NotNull
        public final String test(@NotNull FirstInput input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return "";
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$MultipleInputTypeQuery$FirstInput;", "", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "second", "Lgraphql/kickstart/tools/SchemaClassScannerTest$MultipleInputTypeQuery$SecondInput;", "third", "Lgraphql/kickstart/tools/SchemaClassScannerTest$MultipleInputTypeQuery$ThirdInput;", "getThird", "()Lgraphql/kickstart/tools/SchemaClassScannerTest$MultipleInputTypeQuery$ThirdInput;", "setThird", "(Lgraphql/kickstart/tools/SchemaClassScannerTest$MultipleInputTypeQuery$ThirdInput;)V", "graphql-java-tools"})
        public static final class FirstInput {
            @Nullable
            private String id;
            @Nullable
            private ThirdInput third;

            @Nullable
            public final String getId() {
                return this.id;
            }

            public final void setId(@Nullable String string) {
                this.id = string;
            }

            @NotNull
            public final SecondInput second() {
                return new SecondInput();
            }

            @Nullable
            public final ThirdInput getThird() {
                return this.third;
            }

            public final void setThird(@Nullable ThirdInput thirdInput) {
                this.third = thirdInput;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$MultipleInputTypeQuery$SecondInput;", "", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "graphql-java-tools"})
        public static final class SecondInput {
            @Nullable
            private String id;

            @Nullable
            public final String getId() {
                return this.id;
            }

            public final void setId(@Nullable String string) {
                this.id = string;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$MultipleInputTypeQuery$ThirdInput;", "", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "graphql-java-tools"})
        public static final class ThirdInput {
            @Nullable
            private String id;

            @Nullable
            public final String getId() {
                return this.id;
            }

            public final void setId(@Nullable String string) {
                this.id = string;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\b\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$MultipleInterfaces;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "<init>", "()V", "query1", "Lgraphql/kickstart/tools/SchemaClassScannerTest$MultipleInterfaces$NamedResourceImpl;", "query2", "Lgraphql/kickstart/tools/SchemaClassScannerTest$MultipleInterfaces$VersionedResourceImpl;", "NamedResourceImpl", "VersionedResourceImpl", "graphql-java-tools"})
    public static final class MultipleInterfaces
    implements GraphQLQueryResolver {
        @Nullable
        public final NamedResourceImpl query1() {
            return null;
        }

        @Nullable
        public final VersionedResourceImpl query2() {
            return null;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$MultipleInterfaces$NamedResourceImpl;", "Lgraphql/kickstart/tools/SchemaClassScannerTest$NamedResource;", "<init>", "()V", "name", "", "graphql-java-tools"})
        public static final class NamedResourceImpl
        implements NamedResource {
            @Override
            @Nullable
            public String name() {
                return null;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$MultipleInterfaces$VersionedResourceImpl;", "Lgraphql/kickstart/tools/SchemaClassScannerTest$VersionedResource;", "<init>", "()V", "version", "", "()Ljava/lang/Integer;", "graphql-java-tools"})
        public static final class VersionedResourceImpl
        implements VersionedResource {
            @Override
            @Nullable
            public Integer version() {
                return null;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&\u00a8\u0006\u0004"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$NamedResource;", "", "name", "", "graphql-java-tools"})
    public static interface NamedResource {
        @Nullable
        public String name();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0006\u0007B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$NestedInterfaceTypeQuery;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "<init>", "()V", "animal", "Lgraphql/kickstart/tools/Animal;", "Dog", "ComplexType", "graphql-java-tools"})
    public static final class NestedInterfaceTypeQuery
    implements GraphQLQueryResolver {
        @Nullable
        public final Animal animal() {
            return null;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$NestedInterfaceTypeQuery$ComplexType;", "", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "graphql-java-tools"})
        public static final class ComplexType {
            @Nullable
            private String id;

            @Nullable
            public final String getId() {
                return this.id;
            }

            public final void setId(@Nullable String string) {
                this.id = string;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$NestedInterfaceTypeQuery$Dog;", "Lgraphql/kickstart/tools/Animal;", "<init>", "()V", "type", "Lgraphql/kickstart/tools/SchemaClassScannerTest$NestedInterfaceTypeQuery$ComplexType;", "graphql-java-tools"})
        public static final class Dog
        implements Animal {
            @Override
            @Nullable
            public ComplexType type() {
                return null;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$Pojo;", "", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "graphql-java-tools"})
    public static final class Pojo {
        @Nullable
        private String name;

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\r\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$PrimitiveBoxedQuery;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "<init>", "()V", "primitive", "", "boxed", "()Ljava/lang/Integer;", "graphql-java-tools"})
    private static final class PrimitiveBoxedQuery
    implements GraphQLQueryResolver {
        public final int primitive() {
            return 1;
        }

        @Nullable
        public final Integer boxed() {
            return null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$Product;", "", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "graphql-java-tools"})
    public static final class Product {
        @Nullable
        private String name;

        @Nullable
        public final String getName() {
            return this.name;
        }

        public final void setName(@Nullable String string) {
            this.name = string;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0005\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$ScalarDuplicateQuery;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "<init>", "()V", "string", "", "id", "graphql-java-tools"})
    private static final class ScalarDuplicateQuery
    implements GraphQLQueryResolver {
        @NotNull
        public final String string() {
            return "";
        }

        @NotNull
        public final String id() {
            return "";
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$ScalarsWithMultipleTypes;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "<init>", "()V", "first", "", "()Ljava/lang/Integer;", "second", "", "graphql-java-tools"})
    public static final class ScalarsWithMultipleTypes
    implements GraphQLQueryResolver {
        @Nullable
        public final Integer first() {
            return null;
        }

        @Nullable
        public final String second() {
            return null;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$Unused;", "", "<init>", "()V", "someInterface", "Lgraphql/kickstart/tools/SomeInterface;", "getSomeInterface", "()Lgraphql/kickstart/tools/SomeInterface;", "setSomeInterface", "(Lgraphql/kickstart/tools/SomeInterface;)V", "graphql-java-tools"})
    public static final class Unused {
        @Nullable
        private SomeInterface someInterface;

        @Nullable
        public final SomeInterface getSomeInterface() {
            return this.someInterface;
        }

        public final void setSomeInterface(@Nullable SomeInterface someInterface) {
            this.someInterface = someInterface;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\"\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$User;", "", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "setId", "(Ljava/lang/String;)V", "recentPurchasedProducts", "", "Lgraphql/kickstart/tools/SchemaClassScannerTest$Product;", "getRecentPurchasedProducts", "()Ljava/util/List;", "setRecentPurchasedProducts", "(Ljava/util/List;)V", "address", "Lgraphql/kickstart/tools/SchemaClassScannerTest$Address;", "getAddress", "()Lgraphql/kickstart/tools/SchemaClassScannerTest$Address;", "setAddress", "(Lgraphql/kickstart/tools/SchemaClassScannerTest$Address;)V", "graphql-java-tools"})
    public static final class User {
        @Nullable
        private String id;
        @Nullable
        private List<Product> recentPurchasedProducts;
        @Nullable
        private Address address;

        @Nullable
        public final String getId() {
            return this.id;
        }

        public final void setId(@Nullable String string) {
            this.id = string;
        }

        @Nullable
        public final List<Product> getRecentPurchasedProducts() {
            return this.recentPurchasedProducts;
        }

        public final void setRecentPurchasedProducts(@Nullable List<Product> list) {
            this.recentPurchasedProducts = list;
        }

        @Nullable
        public final Address getAddress() {
            return this.address;
        }

        public final void setAddress(@Nullable Address address) {
            this.address = address;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u000f\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$VersionedResource;", "", "version", "", "()Ljava/lang/Integer;", "graphql-java-tools"})
    public static interface VersionedResource {
        @Nullable
        public Integer version();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/SchemaClassScannerTest$Whatever;", "", "<init>", "()V", "value", "", "getValue", "()Ljava/lang/String;", "setValue", "(Ljava/lang/String;)V", "graphql-java-tools"})
    public static final class Whatever {
        @Nullable
        private String value;

        @Nullable
        public final String getValue() {
            return this.value;
        }

        public final void setValue(@Nullable String string) {
            this.value = string;
        }
    }
}

