/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BiMap<K, V>
implements Map<K, V> {
    private final Map<K, V> delegate;
    private final Map<V, K> inverse;

    public static <K, V> BiMap<K, V> create() {
        return new BiMap(new HashMap(), new HashMap());
    }

    public static <K, V> BiMap<K, V> unmodifiableBiMap(BiMap<K, V> biMap) {
        return new BiMap<K, V>(Collections.unmodifiableMap(biMap.delegate), Collections.unmodifiableMap(biMap.inverse));
    }

    private BiMap(Map<K, V> delegate, Map<V, K> inverse) {
        this.delegate = delegate;
        this.inverse = inverse;
    }

    public BiMap<V, K> inverse() {
        return new BiMap<V, K>(this.inverse, this.delegate);
    }

    @Override
    public void clear() {
        this.delegate.clear();
        this.inverse.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.inverse.containsKey(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public V put(K key, V value) {
        boolean containedKey = this.containsKey(key);
        if (containedKey && Objects.equals(value, this.get(key))) {
            return value;
        }
        if (this.containsValue(value)) {
            throw new IllegalArgumentException("value already present: " + String.valueOf(value));
        }
        V oldValue = this.delegate.put(key, value);
        if (containedKey) {
            this.inverse.remove(oldValue);
        }
        this.inverse.put(value, key);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        this.inverse.remove(this.delegate.get(key));
        return this.delegate.remove(key);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Set<V> values() {
        return this.inverse.keySet();
    }
}

