/*
 * Decompiled with CFR 0.152.
 */
package com.coxautodev.graphql.tools;

import com.coxautodev.graphql.tools.GraphQLQueryResolver;
import com.coxautodev.graphql.tools.GraphQLResolver;
import com.coxautodev.graphql.tools.SchemaParser;
import com.coxautodev.graphql.tools.Utils;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.relay.Connection;
import graphql.relay.SimpleListConnection;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLSchema;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Test;

public class RelayConnectionTest {
    @Test
    public void compiles() {
        GraphQLSchema schema = SchemaParser.newParser().file("RelayConnection.graphqls").resolvers(new GraphQLResolver[]{new QueryResolver()}).dictionary(User.class).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("limit", 10);
        Utils.assertNoGraphQlErrors(gql, variables, new Closure<String>(null){

            public String call() {
                return "query {\n   users {\n       edges {\n           cursor\n           node {\n               id\n               name\n           }\n       },\n       pageInfo {\n           hasPreviousPage,\n           hasNextPage\n           startCursor\n           endCursor\n       }\n   }\n}";
            }
        });
    }

    static class User {
        Long id;
        String name;

        public User(Long id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    static class QueryResolver
    implements GraphQLQueryResolver {
        QueryResolver() {
        }

        public Connection<User> users(int first, String after, DataFetchingEnvironment env) {
            return new SimpleListConnection(Collections.singletonList(new User(1L, "Luke"))).get(env);
        }
    }
}

