/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.kickstart.tools.Utils;
import graphql.schema.GraphQLSchema;
import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.junit.Test;

public class ReactiveTest {
    @Test
    public void futureSucceeds() {
        SchemaParserOptions options = SchemaParserOptions.newOptions().build();
        GraphQLSchema schema2 = SchemaParser.newParser().file("Reactive.graphqls").resolvers(new GraphQLResolver[]{new Query()}).options(options).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        Utils.assertNoGraphQlErrors(gql, new HashMap<String, Object>(), new Object(), new Closure<String>(null){

            public String call() {
                return "query { organization(organizationId: 1) { user { id } } }";
            }
        });
    }

    static class User {
        private Long id;
        private String name;

        User() {
        }
    }

    static class Organization {
        private User user;

        Organization() {
        }
    }

    static class Query
    implements GraphQLQueryResolver {
        Query() {
        }

        Future<Optional<Organization>> organization(int organizationid) {
            return CompletableFuture.completedFuture(Optional.of(new Organization()));
        }
    }
}

