/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.SchemaParserOptions;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\u0006H\u0007J\b\u0010\b\u001a\u00020\u0006H\u0007J\b\u0010\t\u001a\u00020\u0006H\u0007J\b\u0010\n\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverTest;", "", "()V", "customScalarType", "Lgraphql/schema/GraphQLScalarType;", "should handle Optional type as method input argument", "", "should handle Optional type as method input argument with omission detection", "should handle lists of scalar types", "should handle proxies", "should handle scalar types as method input argument", "CustomScalar", "Resolver", "graphql-java-tools"})
public final class MethodFieldResolverTest {
    private final GraphQLScalarType customScalarType;

    @Test
    public final void should handle Optional type as method input argument() {
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                    type Query {\n                        testValue(input: String): String\n                        testOmitted(input: String): String\n                        testNull(input: String): String\n                    }\n                    ").scalars(new GraphQLScalarType[]{this.customScalarType}).resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @NotNull
            public final String testValue(@NotNull Optional<String> input) {
                Intrinsics.checkParameterIsNotNull(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"input.toString()");
                return string;
            }

            @NotNull
            public final String testOmitted(@NotNull Optional<String> input) {
                Intrinsics.checkParameterIsNotNull(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"input.toString()");
                return string;
            }

            @NotNull
            public final String testNull(@NotNull Optional<String> input) {
                Intrinsics.checkParameterIsNotNull(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"input.toString()");
                return string;
            }
        }}).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("\n                            query {\n                                testValue(input: \"test-value\")\n                                testOmitted\n                                testNull(input: null)\n                            }\n                            ").context(new Object()).root(new Object()));
        Map expected = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"testValue", (Object)"Optional[test-value]"), TuplesKt.to((Object)"testOmitted", (Object)"Optional.empty"), TuplesKt.to((Object)"testNull", (Object)"Optional.empty")});
        Assert.assertEquals((Object)expected, (Object)result.getData());
    }

    @Test
    public final void should handle Optional type as method input argument with omission detection() {
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n                    type Query {\n                        testValue(input: String): String\n                        testOmitted(input: String): String\n                        testNull(input: String): String\n                    }\n                    ").scalars(new GraphQLScalarType[]{this.customScalarType}).resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            @NotNull
            public final String testValue(@NotNull Optional<String> input) {
                Intrinsics.checkParameterIsNotNull(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"input.toString()");
                return string;
            }

            @NotNull
            public final String testOmitted(@Nullable Optional<String> input) {
                return String.valueOf(input);
            }

            @NotNull
            public final String testNull(@NotNull Optional<String> input) {
                Intrinsics.checkParameterIsNotNull(input, (String)"input");
                String string = input.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"input.toString()");
                return string;
            }
        }}).options(SchemaParserOptions.Companion.newOptions().inputArgumentOptionalDetectOmission(true).build()).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("\n                            query {\n                                testValue(input: \"test-value\")\n                                testOmitted\n                                testNull(input: null)\n                            }\n                            ").context(new Object()).root(new Object()));
        Map expected = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"testValue", (Object)"Optional[test-value]"), TuplesKt.to((Object)"testOmitted", (Object)"null"), TuplesKt.to((Object)"testNull", (Object)"Optional.empty")});
        Assert.assertEquals((Object)expected, (Object)result.getData());
    }

    @Test
    public final void should handle scalar types as method input argument() {
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("scalar CustomScalar\ntype Query {\n    test(input: CustomScalar): Int\n}").scalars(new GraphQLScalarType[]{this.customScalarType}).resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            public final int test(@NotNull CustomScalar scalar) {
                Intrinsics.checkParameterIsNotNull((Object)scalar, (String)"scalar");
                return scalar.getValue().length();
            }
        }}).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("query Test($input: CustomScalar) {\n    test(input: $input)\n}").variables(MapsKt.mapOf((Pair)TuplesKt.to((Object)"input", (Object)"FooBar"))).context(new Object()).root(new Object()));
        Assert.assertEquals((Object)6, ((Map)result.getData()).get("test"));
    }

    @Test
    public final void should handle lists of scalar types() {
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("scalar CustomScalar\ntype Query {\n    test(input: [CustomScalar]): Int\n}").scalars(new GraphQLScalarType[]{this.customScalarType}).resolvers(new GraphQLResolver[]{(GraphQLResolver)new GraphQLQueryResolver(){

            /*
             * WARNING - void declaration
             */
            public final int test(@NotNull List<CustomScalar> scalars) {
                void $this$mapTo$iv$iv;
                Intrinsics.checkParameterIsNotNull(scalars, (String)"scalars");
                Iterable $this$map$iv = scalars;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CustomScalar customScalar = (CustomScalar)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Integer n = it.getValue().length();
                    collection.add(n);
                }
                return CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
            }
        }}).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("query Test($input: [CustomScalar]) {\n    test(input: $input)\n}").variables(MapsKt.mapOf((Pair)TuplesKt.to((Object)"input", (Object)CollectionsKt.listOf((Object[])new String[]{"Foo", "Bar"})))).context(new Object()).root(new Object()));
        Assert.assertEquals((Object)6, ((Map)result.getData()).get("test"));
    }

    @Test
    public final void should handle proxies() {
        InvocationHandler invocationHandler2 = new InvocationHandler(){

            /*
             * Unable to fully structure code
             */
            @NotNull
            public Object invoke(@NotNull Object proxy, @NotNull Method method, @NotNull Object[] args) {
                block12: {
                    block9: {
                        block10: {
                            block11: {
                                Intrinsics.checkParameterIsNotNull((Object)proxy, (String)"proxy");
                                Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
                                Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                                v0 = method.getName();
                                if (v0 == null) break block9;
                                var4_4 = v0;
                                switch (var4_4.hashCode()) {
                                    case 3556498: {
                                        if (!var4_4.equals("test")) ** break;
                                        break block10;
                                    }
                                    case 147696667: {
                                        if (!var4_4.equals("hashCode")) ** break;
                                        break;
                                    }
                                    case -1295482945: {
                                        if (!var4_4.equals("equals")) ** break;
                                        break block11;
                                    }
                                    case -1776922004: {
                                        if (!var4_4.equals("toString")) ** break;
                                        v1 = (Serializable)("Proxy$" + System.identityHashCode(this));
                                        break block12;
                                    }
                                }
                                v1 = Integer.valueOf(System.identityHashCode(this));
                                break block12;
                            }
                            v1 = Boolean.valueOf(Proxy.isProxyClass(args[0].getClass()));
                            break block12;
                        }
                        v2 = args[0];
                        if (v2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.List<*>");
                        }
                        $this$map$iv = (List)v2;
                        $i$f$map = false;
                        var7_7 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        var10_10 = $this$mapTo$iv$iv.iterator();
                        while (var10_10.hasNext()) {
                            var12_12 = item$iv$iv = var10_10.next();
                            var14_14 = destination$iv$iv;
                            $i$a$-map-MethodFieldResolverTest$should handle proxies$invocationHandler$1$invoke$1 = false;
                            v3 = it;
                            if (v3 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type graphql.kickstart.tools.MethodFieldResolverTest.CustomScalar");
                            }
                            var15_15 = ((CustomScalar)v3).getValue().length();
                            var14_14.add(var15_15);
                        }
                        v1 = Integer.valueOf(CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv)));
                        break block12;
                    }
                    v1 = new UnsupportedOperationException();
                }
                return v1;
            }
        };
        Object object = Proxy.newProxyInstance(MethodFieldResolverTest.class.getClassLoader(), new Class[]{Resolver.class, GraphQLQueryResolver.class}, invocationHandler2);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type graphql.kickstart.tools.GraphQLQueryResolver");
        }
        GraphQLQueryResolver resolver = (GraphQLQueryResolver)object;
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("scalar CustomScalar\ntype Query {\n    test(input: [CustomScalar]): Int\n}").scalars(new GraphQLScalarType[]{this.customScalarType}).resolvers(new GraphQLResolver[]{(GraphQLResolver)resolver}).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).build();
        ExecutionResult result = gql.execute(ExecutionInput.newExecutionInput().query("query Test($input: [CustomScalar]) {\n    test(input: $input)\n}").variables(MapsKt.mapOf((Pair)TuplesKt.to((Object)"input", (Object)CollectionsKt.listOf((Object[])new String[]{"Foo", "Bar"})))).context(new Object()).root(new Object()));
        Assert.assertEquals((Object)6, ((Map)result.getData()).get("test"));
    }

    public MethodFieldResolverTest() {
        GraphQLScalarType graphQLScalarType = GraphQLScalarType.newScalar().name("CustomScalar").description("customScalar").coercing((Coercing)new Coercing<CustomScalar, String>(){

            @Nullable
            public CustomScalar parseValue(@Nullable Object input) {
                return CustomScalar.Companion.of(input);
            }

            @Nullable
            public CustomScalar parseLiteral(@Nullable Object input) {
                Object object = input;
                return object instanceof StringValue ? CustomScalar.Companion.of(((StringValue)input).getValue()) : null;
            }

            @Nullable
            public String serialize(@Nullable Object dataFetcherResult) {
                Object object = dataFetcherResult;
                return object instanceof CustomScalar ? ((CustomScalar)dataFetcherResult).getValue() : null;
            }
        }).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)graphQLScalarType, (String)"GraphQLScalarType.newSca\u2026      })\n        .build()");
        this.customScalarType = graphQLScalarType;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\t"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverTest$CustomScalar;", "", "internalValue", "", "(Ljava/lang/String;)V", "value", "getValue", "()Ljava/lang/String;", "Companion", "graphql-java-tools"})
    public static final class CustomScalar {
        private final String internalValue;
        public static final Companion Companion = new Companion(null);

        @NotNull
        public final String getValue() {
            return this.internalValue;
        }

        private CustomScalar(String internalValue) {
            this.internalValue = internalValue;
        }

        public /* synthetic */ CustomScalar(String internalValue, DefaultConstructorMarker $constructor_marker) {
            this(internalValue);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u0006"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverTest$CustomScalar$Companion;", "", "()V", "of", "Lgraphql/kickstart/tools/MethodFieldResolverTest$CustomScalar;", "input", "graphql-java-tools"})
        public static final class Companion {
            @Nullable
            public final CustomScalar of(@Nullable Object input) {
                Object object = input;
                return object instanceof String ? new CustomScalar((String)input, null) : null;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/MethodFieldResolverTest$Resolver;", "", "test", "", "scalars", "", "Lgraphql/kickstart/tools/MethodFieldResolverTest$CustomScalar;", "graphql-java-tools"})
    public static interface Resolver {
        public int test(@NotNull List<CustomScalar> var1);
    }
}

