/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools;

import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.execution.AsyncExecutionStrategy;
import graphql.execution.ExecutionStrategy;
import graphql.kickstart.tools.GraphQLQueryResolver;
import graphql.kickstart.tools.GraphQLResolver;
import graphql.kickstart.tools.RelayConnectionTest;
import graphql.kickstart.tools.SchemaParser;
import graphql.kickstart.tools.Utils;
import graphql.relay.Connection;
import graphql.relay.SimpleListConnection;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import groovy.lang.Closure;
import java.util.Map;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004\u0006\u0007\b\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0004H\u0007\u00a8\u0006\n"}, d2={"Lgraphql/kickstart/tools/RelayConnectionTest;", "", "()V", "should compile relay schema when not using @connection directive", "", "should compile relay schema when using @connection directive", "AnotherType", "QueryResolver", "UppercaseDirective", "User", "graphql-java-tools"})
public final class RelayConnectionTest {
    @Test
    public final void should compile relay schema when not using @connection directive() {
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().schemaString("\n              directive @uppercase on FIELD_DEFINITION\n  \n              type Query {\n                users(first: Int, after: String): UserConnection\n                otherTypes: AnotherTypeConnection\n              }\n      \n              type UserConnection {\n                edges: [UserEdge!]!\n                pageInfo: PageInfo!\n              }\n      \n              type UserEdge {\n                node: User!\n              } \n              \n              type User {\n                id: ID!\n                name: String @uppercase\n              }\n      \n              type PageInfo\n      \n              type AnotherTypeConnection {\n                edges: [AnotherTypeEdge!]!\n              }\n      \n              type AnotherTypeEdge {\n                node: AnotherType!\n              }\n      \n              type AnotherType {\n                echo: String\n              }\n            ").resolvers(new GraphQLResolver[]{(GraphQLResolver)new QueryResolver()}).directive("uppercase", (SchemaDirectiveWiring)new UppercaseDirective()).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        ExecutionResult result = gql.execute("\n          query {\n            users {\n              edges {\n                node {\n                  id\n                  name\n                }\n              }\n            }\n            otherTypes {\n              edges {\n                node {\n                  echo\n                }\n              }\n            }\n          }\n        ");
        Map expected = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"users", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"edges", (Object)CollectionsKt.listOf((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"node", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"id", (Object)"1"), TuplesKt.to((Object)"name", (Object)"LUKE")}))))))), TuplesKt.to((Object)"otherTypes", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"edges", (Object)CollectionsKt.listOf((Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"node", (Object)MapsKt.mapOf((Pair)TuplesKt.to((Object)"echo", (Object)"echo-o-o"))))))))});
        Assert.assertEquals((Object)expected, (Object)result.getData());
    }

    @Test
    public final void should compile relay schema when using @connection directive() {
        GraphQLSchema schema2 = SchemaParser.Companion.newParser().file("RelayConnection.graphqls").resolvers(new GraphQLResolver[]{(GraphQLResolver)new QueryResolver()}).dictionary(User.class).build().makeExecutableSchema();
        GraphQL gql = GraphQL.newGraphQL((GraphQLSchema)schema2).queryExecutionStrategy((ExecutionStrategy)new AsyncExecutionStrategy()).build();
        Utils.assertNoGraphQlErrors(gql, MapsKt.emptyMap(), (Closure<String>)((Closure)new Closure<String>(null){

            @NotNull
            public String call() {
                return "\n                  query {\n                    users {\n                      edges {\n                        cursor\n                        node {\n                          id\n                          name\n                        }\n                      }\n                      pageInfo {\n                        hasPreviousPage\n                        hasNextPage\n                        startCursor\n                        endCursor\n                      }\n                    }\n                  }\n                ";
            }
        }));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007J-\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lgraphql/kickstart/tools/RelayConnectionTest$QueryResolver;", "Lgraphql/kickstart/tools/GraphQLQueryResolver;", "()V", "otherTypes", "Lgraphql/relay/Connection;", "Lgraphql/kickstart/tools/RelayConnectionTest$AnotherType;", "env", "Lgraphql/schema/DataFetchingEnvironment;", "users", "Lgraphql/kickstart/tools/RelayConnectionTest$User;", "first", "", "after", "", "(Ljava/lang/Integer;Ljava/lang/String;Lgraphql/schema/DataFetchingEnvironment;)Lgraphql/relay/Connection;", "graphql-java-tools"})
    private static final class QueryResolver
    implements GraphQLQueryResolver {
        @NotNull
        public final Connection<User> users(@Nullable Integer first, @Nullable String after, @NotNull DataFetchingEnvironment env) {
            Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
            Connection connection = new SimpleListConnection(CollectionsKt.listOf((Object)new User(1L, "Luke"))).get(env);
            Intrinsics.checkExpressionValueIsNotNull((Object)connection, (String)"SimpleListConnection(lis\u2026er(1L, \"Luke\"))).get(env)");
            return connection;
        }

        @NotNull
        public final Connection<AnotherType> otherTypes(@NotNull DataFetchingEnvironment env) {
            Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
            Connection connection = new SimpleListConnection(CollectionsKt.listOf((Object)new AnotherType("echo-o-o"))).get(env);
            Intrinsics.checkExpressionValueIsNotNull((Object)connection, (String)"SimpleListConnection(lis\u2026pe(\"echo-o-o\"))).get(env)");
            return connection;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lgraphql/kickstart/tools/RelayConnectionTest$User;", "", "id", "", "name", "", "(JLjava/lang/String;)V", "getId", "()J", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-java-tools"})
    private static final class User {
        private final long id;
        @NotNull
        private final String name;

        public final long getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public User(long id, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            this.id = id;
            this.name = name;
        }

        public final long component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final User copy(long id, @NotNull String name) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            return new User(id, name);
        }

        public static /* synthetic */ User copy$default(User user, long l, String string, int n, Object object) {
            if ((n & 1) != 0) {
                l = user.id;
            }
            if ((n & 2) != 0) {
                string = user.name;
            }
            return user.copy(l, string);
        }

        @NotNull
        public String toString() {
            return "User(id=" + this.id + ", name=" + this.name + ")";
        }

        public int hashCode() {
            long l = this.id;
            String string = this.name;
            return (int)(l ^ l >>> 32) * 31 + (string != null ? string.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof User)) break block3;
                    User user = (User)object;
                    if (this.id != user.id || !Intrinsics.areEqual((Object)this.name, (Object)user.name)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\t\u0010\u000e\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lgraphql/kickstart/tools/RelayConnectionTest$AnotherType;", "", "echo", "", "(Ljava/lang/String;)V", "getEcho", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "graphql-java-tools"})
    private static final class AnotherType {
        @NotNull
        private final String echo;

        @NotNull
        public final String getEcho() {
            return this.echo;
        }

        public AnotherType(@NotNull String echo) {
            Intrinsics.checkParameterIsNotNull((Object)echo, (String)"echo");
            this.echo = echo;
        }

        @NotNull
        public final String component1() {
            return this.echo;
        }

        @NotNull
        public final AnotherType copy(@NotNull String echo) {
            Intrinsics.checkParameterIsNotNull((Object)echo, (String)"echo");
            return new AnotherType(echo);
        }

        public static /* synthetic */ AnotherType copy$default(AnotherType anotherType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = anotherType.echo;
            }
            return anotherType.copy(string);
        }

        @NotNull
        public String toString() {
            return "AnotherType(echo=" + this.echo + ")";
        }

        public int hashCode() {
            String string = this.echo;
            return string != null ? string.hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof AnotherType)) break block3;
                    AnotherType anotherType = (AnotherType)object;
                    if (!Intrinsics.areEqual((Object)this.echo, (Object)anotherType.echo)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lgraphql/kickstart/tools/RelayConnectionTest$UppercaseDirective;", "Lgraphql/schema/idl/SchemaDirectiveWiring;", "()V", "onField", "Lgraphql/schema/GraphQLFieldDefinition;", "environment", "Lgraphql/schema/idl/SchemaDirectiveWiringEnvironment;", "graphql-java-tools"})
    private static final class UppercaseDirective
    implements SchemaDirectiveWiring {
        @NotNull
        public GraphQLFieldDefinition onField(@NotNull SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> environment) {
            Intrinsics.checkParameterIsNotNull(environment, (String)"environment");
            GraphQLFieldDefinition field = (GraphQLFieldDefinition)environment.getElement();
            GraphQLFieldsContainer parentType = environment.getFieldsContainer();
            DataFetcher originalDataFetcher = environment.getCodeRegistry().getDataFetcher(parentType, field);
            DataFetcher wrappedDataFetcher2 = DataFetcherFactories.wrapDataFetcher((DataFetcher)originalDataFetcher, (BiFunction)onField.wrappedDataFetcher.1.INSTANCE);
            environment.getCodeRegistry().dataFetcher(parentType, field, wrappedDataFetcher2);
            GraphQLFieldDefinition graphQLFieldDefinition = field;
            Intrinsics.checkExpressionValueIsNotNull((Object)graphQLFieldDefinition, (String)"field");
            return graphQLFieldDefinition;
        }
    }
}

