/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.tools.util;

import graphql.kickstart.tools.util.BiMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\fH\u0007J\b\u0010\u000e\u001a\u00020\fH\u0007J\b\u0010\u000f\u001a\u00020\fH\u0007J\b\u0010\u0010\u001a\u00020\fH\u0007J\b\u0010\u0011\u001a\u00020\fH\u0007R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lgraphql/kickstart/tools/util/BiMapTest;", "", "()V", "bimap", "Lgraphql/kickstart/tools/util/BiMap;", "", "", "getBimap", "()Lgraphql/kickstart/tools/util/BiMap;", "setBimap", "(Lgraphql/kickstart/tools/util/BiMap;)V", "setup", "", "should allow same key new value", "should allow same key same value", "should not permit duplicate values", "should provide inverse view", "should return correct values", "graphql-java-tools"})
public final class BiMapTest {
    @NotNull
    public BiMap<String, Integer> bimap;

    @NotNull
    public final BiMap<String, Integer> getBimap() {
        BiMap<String, Integer> biMap = this.bimap;
        if (biMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        return biMap;
    }

    public final void setBimap(@NotNull BiMap<String, Integer> biMap) {
        Intrinsics.checkParameterIsNotNull(biMap, (String)"<set-?>");
        this.bimap = biMap;
    }

    @Before
    public final void setup() {
        BiMap biMap = BiMap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)biMap, (String)"BiMap.create()");
        this.bimap = biMap;
    }

    @Test(expected=IllegalArgumentException.class)
    public final void should not permit duplicate values() {
        BiMap<String, Integer> biMap = this.bimap;
        if (biMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        ((Map)biMap).put("foo", 1);
        BiMap<String, Integer> biMap2 = this.bimap;
        if (biMap2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        ((Map)biMap2).put("bar", 1);
    }

    @Test
    public final void should allow same key same value() {
        BiMap<String, Integer> biMap = this.bimap;
        if (biMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        ((Map)biMap).put("foo", 1);
        BiMap<String, Integer> biMap2 = this.bimap;
        if (biMap2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        ((Map)biMap2).put("foo", 1);
    }

    @Test
    public final void should allow same key new value() {
        BiMap<String, Integer> biMap = this.bimap;
        if (biMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        ((Map)biMap).put("foo", 1);
        BiMap<String, Integer> biMap2 = this.bimap;
        if (biMap2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        ((Map)biMap2).put("bar", 2);
        BiMap<String, Integer> biMap3 = this.bimap;
        if (biMap3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        Object object = biMap3.put((Object)"bar", (Object)3);
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bimap.put(\"bar\", 3)!!");
        int old = ((Number)object).intValue();
        Assert.assertEquals((long)2L, (long)old);
        Set expected = new HashSet(Arrays.asList(1, 3));
        BiMap<String, Integer> biMap4 = this.bimap;
        if (biMap4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        Assert.assertEquals((Object)expected, (Object)biMap4.values());
        BiMap<String, Integer> biMap5 = this.bimap;
        if (biMap5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        Assert.assertEquals((Object)expected, (Object)biMap5.inverse().keySet());
    }

    @Test
    public final void should provide inverse view() {
        BiMap<String, Integer> biMap = this.bimap;
        if (biMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        ((Map)biMap).put("foo", 1);
        BiMap<String, Integer> biMap2 = this.bimap;
        if (biMap2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        ((Map)biMap2).put("bar", 2);
        BiMap<String, Integer> biMap3 = this.bimap;
        if (biMap3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        ((Map)biMap3).put("baz", 3);
        BiMap<String, Integer> biMap4 = this.bimap;
        if (biMap4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        BiMap inverse = biMap4.inverse();
        Assert.assertTrue((boolean)inverse.containsKey((Object)1));
        Assert.assertTrue((boolean)inverse.containsKey((Object)2));
        Assert.assertTrue((boolean)inverse.containsKey((Object)3));
        Assert.assertThat((Object)inverse.get((Object)1), (Matcher)CoreMatchers.is((Object)"foo"));
        Assert.assertThat((Object)inverse.get((Object)2), (Matcher)CoreMatchers.is((Object)"bar"));
        Assert.assertThat((Object)inverse.get((Object)3), (Matcher)CoreMatchers.is((Object)"baz"));
    }

    @Test
    public final void should return correct values() {
        BiMap<String, Integer> biMap = this.bimap;
        if (biMap == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        ((Map)biMap).put("foo", 1);
        BiMap<String, Integer> biMap2 = this.bimap;
        if (biMap2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        ((Map)biMap2).put("bar", 2);
        BiMap<String, Integer> biMap3 = this.bimap;
        if (biMap3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        ((Map)biMap3).put("baz", 3);
        BiMap<String, Integer> biMap4 = this.bimap;
        if (biMap4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bimap");
        }
        Set set = (Set)biMap4.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"bimap.values");
        Set values = set;
        Set expected = SetsKt.setOf((Object[])new Integer[]{1, 2, 3});
        Assert.assertEquals((Object)expected, (Object)values);
    }
}

