/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations;

import graphql.Scalars;
import graphql.annotations.GraphQLAnnotationsProcessor;
import graphql.annotations.GraphQLDescription;
import graphql.annotations.GraphQLName;
import graphql.annotations.GraphQLNonNull;
import graphql.annotations.TypeFunction;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.component.annotations.ServiceScope;

@Component(scope=ServiceScope.SINGLETON, property={"type=default"})
public class DefaultTypeFunction
implements TypeFunction {
    @Reference(target="(!(type=default))", policyOption=ReferencePolicyOption.GREEDY)
    protected List<TypeFunction> otherFunctions = new ArrayList<TypeFunction>();
    private Map<Class<?>, BiFunction<Class<?>, AnnotatedType, GraphQLType>> registry = new ConcurrentHashMap();
    GraphQLAnnotationsProcessor annotationsProcessor;

    @Override
    public Collection<Class<?>> getAcceptedTypes() {
        List<Class<?>> list = this.registry.keySet().stream().collect(Collectors.toList());
        List others = this.otherFunctions.stream().flatMap(tf -> tf.getAcceptedTypes().stream()).collect(Collectors.toList());
        list.addAll(others);
        return list;
    }

    void setAnnotationsProcessor(GraphQLAnnotationsProcessor annotationsProcessor) {
        this.annotationsProcessor = annotationsProcessor;
    }

    public DefaultTypeFunction() {
        this.register(new StringFunction());
        this.register(new BooleanFunction());
        this.register(new FloatFunction());
        this.register(new IntegerFunction());
        this.register(new LongFunction());
        this.register(new ListFunction());
        this.register(new StreamFunction());
        this.register(new EnumFunction());
        this.register(new OptionalFunction());
        this.register(new ObjectFunction());
    }

    @Activate
    protected void activate() {
        this.otherFunctions.forEach(this::register);
    }

    public Class<DefaultTypeFunction> register(TypeFunction function) {
        function.getAcceptedTypes().forEach(t -> {
            BiFunction cfr_ignored_0 = this.registry.put((Class<?>)t, function);
        });
        return DefaultTypeFunction.class;
    }

    @Override
    public GraphQLType apply(Class<?> klass, AnnotatedType annotatedType) {
        Class<Object> t = klass;
        while (!this.registry.containsKey(t)) {
            if (t.getSuperclass() == null && t.isInterface()) {
                t = Object.class;
                continue;
            }
            if ((t = t.getSuperclass()) != null) continue;
            throw new IllegalArgumentException("unsupported type");
        }
        GraphQLType result = this.registry.get(t).apply(klass, annotatedType);
        if (klass.getAnnotation(GraphQLNonNull.class) != null || annotatedType != null && annotatedType.getAnnotation(GraphQLNonNull.class) != null) {
            result = new graphql.schema.GraphQLNonNull(result);
        }
        return result;
    }

    private class ObjectFunction
    implements TypeFunction {
        private final Map<String, GraphQLTypeReference> processing = new ConcurrentHashMap<String, GraphQLTypeReference>();
        private final Map<String, GraphQLType> types = new ConcurrentHashMap<String, GraphQLType>();

        private ObjectFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            String typeName;
            GraphQLName name = aClass.getAnnotation(GraphQLName.class);
            String string = typeName = name == null ? aClass.getSimpleName() : name.value();
            if (this.processing.containsKey(typeName)) {
                return (GraphQLType)this.processing.get(typeName);
            }
            this.processing.put(typeName, new GraphQLTypeReference(typeName));
            Object type = aClass.isInterface() ? DefaultTypeFunction.this.annotationsProcessor.getInterface(aClass) : DefaultTypeFunction.this.annotationsProcessor.getObject(aClass);
            this.processing.remove(typeName);
            this.types.put(typeName, (GraphQLType)type);
            return type;
        }

        @Override
        public Collection<Class<?>> getAcceptedTypes() {
            return Collections.singletonList(Object.class);
        }
    }

    private class EnumFunction
    implements TypeFunction {
        private EnumFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            Class<?> enumClass = aClass;
            GraphQLEnumType.Builder builder = GraphQLEnumType.newEnum();
            GraphQLName name = aClass.getAnnotation(GraphQLName.class);
            builder.name(name == null ? aClass.getSimpleName() : name.value());
            GraphQLDescription description = aClass.getAnnotation(GraphQLDescription.class);
            if (description != null) {
                builder.description(description.value());
            }
            List<?> constants = Arrays.asList(enumClass.getEnumConstants());
            Arrays.stream(enumClass.getEnumConstants()).map(Enum::name).forEachOrdered(n -> {
                try {
                    Field field = aClass.getField((String)n);
                    GraphQLName fieldName = field.getAnnotation(GraphQLName.class);
                    GraphQLDescription fieldDescription = field.getAnnotation(GraphQLDescription.class);
                    Enum constant = constants.stream().filter(c -> c.name().contentEquals((CharSequence)n)).findFirst().get();
                    String name_ = fieldName == null ? n : fieldName.value();
                    builder.value(name_, (Object)constant, fieldDescription == null ? name_ : fieldDescription.value());
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            });
            return builder.build();
        }

        @Override
        public Collection<Class<?>> getAcceptedTypes() {
            return Collections.singletonList(Enum.class);
        }
    }

    private class OptionalFunction
    implements TypeFunction {
        private OptionalFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            if (!(annotatedType instanceof AnnotatedParameterizedType)) {
                throw new IllegalArgumentException("Optional type parameter should be specified");
            }
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
            AnnotatedType arg = parameterizedType.getAnnotatedActualTypeArguments()[0];
            Class klass = arg.getType() instanceof ParameterizedType ? (Class)((ParameterizedType)arg.getType()).getRawType() : (Class)arg.getType();
            return DefaultTypeFunction.this.apply(klass, arg);
        }

        @Override
        public Collection<Class<?>> getAcceptedTypes() {
            return Collections.singletonList(Optional.class);
        }
    }

    private class StreamFunction
    implements TypeFunction {
        private StreamFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            if (!(annotatedType instanceof AnnotatedParameterizedType)) {
                throw new IllegalArgumentException("Stream type parameter should be specified");
            }
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
            AnnotatedType arg = parameterizedType.getAnnotatedActualTypeArguments()[0];
            Class klass = arg.getType() instanceof ParameterizedType ? (Class)((ParameterizedType)arg.getType()).getRawType() : (Class)arg.getType();
            return new GraphQLList(DefaultTypeFunction.this.apply(klass, arg));
        }

        @Override
        public Collection<Class<?>> getAcceptedTypes() {
            return Collections.singletonList(Stream.class);
        }
    }

    private class ListFunction
    implements TypeFunction {
        private ListFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            if (!(annotatedType instanceof AnnotatedParameterizedType)) {
                throw new IllegalArgumentException("List type parameter should be specified");
            }
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)annotatedType;
            AnnotatedType arg = parameterizedType.getAnnotatedActualTypeArguments()[0];
            Class klass = arg.getType() instanceof ParameterizedType ? (Class)((ParameterizedType)arg.getType()).getRawType() : (Class)arg.getType();
            return new GraphQLList(DefaultTypeFunction.this.apply(klass, arg));
        }

        @Override
        public Collection<Class<?>> getAcceptedTypes() {
            return Arrays.asList(List.class, AbstractList.class);
        }
    }

    private class LongFunction
    implements TypeFunction {
        private LongFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLLong;
        }

        @Override
        public Collection<Class<?>> getAcceptedTypes() {
            return Arrays.asList(Long.class, Long.TYPE);
        }
    }

    private class IntegerFunction
    implements TypeFunction {
        private IntegerFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLInt;
        }

        @Override
        public Collection<Class<?>> getAcceptedTypes() {
            return Arrays.asList(Integer.class, Integer.TYPE);
        }
    }

    private class FloatFunction
    implements TypeFunction {
        private FloatFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLFloat;
        }

        @Override
        public Collection<Class<?>> getAcceptedTypes() {
            return Arrays.asList(Float.class, Float.TYPE, Double.class, Double.TYPE);
        }
    }

    private class BooleanFunction
    implements TypeFunction {
        private BooleanFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLBoolean;
        }

        @Override
        public Collection<Class<?>> getAcceptedTypes() {
            return Arrays.asList(Boolean.class, Boolean.TYPE);
        }
    }

    private class StringFunction
    implements TypeFunction {
        private StringFunction() {
        }

        @Override
        public GraphQLType apply(Class<?> aClass, AnnotatedType annotatedType) {
            return Scalars.GraphQLString;
        }

        @Override
        public Collection<Class<?>> getAcceptedTypes() {
            return Collections.singletonList(String.class);
        }
    }
}

