/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.util;

import java.util.regex.Pattern;

public class NamingKit {
    private static final Pattern VALID_NAME = Pattern.compile("[_A-Za-z][_0-9A-Za-z]*");
    private static final Pattern VALID_START = Pattern.compile("[_A-Za-z]");
    private static final Pattern VALID_CHAR = Pattern.compile("[_0-9A-Za-z]");

    public static String toGraphqlName(String name) {
        if (VALID_NAME.matcher(name).matches()) {
            return name;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            String sChar = new String(new char[]{c});
            if (i == 0) {
                if (!VALID_START.matcher(sChar).matches()) {
                    NamingKit.replace(sb, c);
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (!VALID_CHAR.matcher(sChar).matches()) {
                NamingKit.replace(sb, c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static void replace(StringBuilder sb, char c) {
        if (c == '.' || c == '$') {
            sb.append('_');
        } else {
            sb.append("_");
            Integer iChar = c;
            sb.append(iChar.toString());
            sb.append("_");
        }
    }
}

