/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.schemawiring;

import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import graphql.validation.interpolation.MessageInterpolator;
import graphql.validation.rules.OnValidationErrorStrategy;
import graphql.validation.rules.TargetedValidationRules;
import graphql.validation.rules.ValidationRules;
import graphql.validation.util.Util;
import java.util.List;
import java.util.Locale;

@PublicApi
public class ValidationSchemaWiring
implements SchemaDirectiveWiring {
    private final ValidationRules ruleCandidates;

    public ValidationSchemaWiring(ValidationRules ruleCandidates) {
        this.ruleCandidates = ruleCandidates;
    }

    public GraphQLFieldDefinition onField(SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> env) {
        GraphQLFieldsContainer fieldsContainer = env.getFieldsContainer();
        GraphQLFieldDefinition fieldDefinition = env.getFieldDefinition();
        TargetedValidationRules rules = this.ruleCandidates.buildRulesFor(fieldDefinition, fieldsContainer);
        if (rules.isEmpty()) {
            return fieldDefinition;
        }
        OnValidationErrorStrategy errorStrategy = this.ruleCandidates.getOnValidationErrorStrategy();
        MessageInterpolator messageInterpolator = this.ruleCandidates.getMessageInterpolator();
        Locale locale = this.ruleCandidates.getLocale();
        DataFetcher currentDF = env.getCodeRegistry().getDataFetcher(fieldsContainer, fieldDefinition);
        DataFetcher newDF = this.buildValidatingDataFetcher(rules, errorStrategy, messageInterpolator, currentDF, locale);
        env.getCodeRegistry().dataFetcher(fieldsContainer, fieldDefinition, newDF);
        return fieldDefinition;
    }

    private DataFetcher buildValidatingDataFetcher(TargetedValidationRules rules, OnValidationErrorStrategy errorStrategy, MessageInterpolator messageInterpolator, DataFetcher currentDF, Locale defaultLocale) {
        return environment -> {
            List<GraphQLError> errors = rules.runValidationRules(environment, messageInterpolator, defaultLocale);
            if (!errors.isEmpty() && !errorStrategy.shouldContinue(errors, environment)) {
                return errorStrategy.onErrorValue(errors, environment);
            }
            Object returnValue = currentDF.get(environment);
            if (errors.isEmpty()) {
                return returnValue;
            }
            return Util.mkDFRFromFetchedResult(errors, returnValue);
        };
    }
}

