/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.constraints.standard;

import graphql.Scalars;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLNamedType;
import graphql.validation.constraints.Documentation;
import graphql.validation.constraints.standard.AbstractSizeConstraint;

public class SizeConstraint
extends AbstractSizeConstraint {
    public SizeConstraint() {
        super("Size");
    }

    @Override
    public Documentation getDocumentation() {
        return Documentation.newDocumentation().messageTemplate(this.getMessageTemplate()).description("The element size must be between the specified `min` and `max` boundaries (inclusive).").example("updateDrivingNotes( drivingNote : String @Size( min : 1000, max : 100000)) : DriverDetails").applicableTypes(new GraphQLNamedType[]{Scalars.GraphQLString, Scalars.GraphQLID}).directiveSDL("directive @Size(min : Int = 0, max : Int = %d, message : String = \"%s\") on ARGUMENT_DEFINITION | INPUT_FIELD_DEFINITION", Integer.MAX_VALUE, this.getMessageTemplate()).build();
    }

    @Override
    public boolean appliesToType(GraphQLInputType inputType) {
        return this.isStringOrID(inputType);
    }

    @Override
    protected boolean appliesToListElements() {
        return true;
    }
}

