/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.CharStreams;
import graphql.ExceptionWhileDataFetching;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.InvalidSyntaxError;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.servlet.DefaultGraphQLContextBuilder;
import graphql.servlet.EnhancedExecutionStrategyProvider;
import graphql.servlet.ExecutionStrategyProvider;
import graphql.servlet.GraphQLContext;
import graphql.servlet.GraphQLContextBuilder;
import graphql.servlet.GraphQLMBean;
import graphql.servlet.GraphQLMutationProvider;
import graphql.servlet.GraphQLQueryProvider;
import graphql.servlet.GraphQLSchemaProvider;
import graphql.validation.ValidationError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"alias=/graphql", "jmx.objectname=graphql.servlet:type=graphql"})
public class GraphQLServlet
extends HttpServlet
implements Servlet,
GraphQLMBean,
GraphQLSchemaProvider {
    private static final Logger log = LoggerFactory.getLogger(GraphQLServlet.class);
    private List<GraphQLQueryProvider> queryProviders = new ArrayList<GraphQLQueryProvider>();
    private List<GraphQLMutationProvider> mutationProviders = new ArrayList<GraphQLMutationProvider>();
    GraphQLSchema schema;
    GraphQLSchema readOnlySchema;
    private GraphQLContextBuilder contextBuilder = new DefaultGraphQLContextBuilder();
    private ExecutionStrategyProvider executionStrategyProvider = new EnhancedExecutionStrategyProvider();

    protected void updateSchema() {
        GraphQLObjectType.Builder object = GraphQLObjectType.newObject().name("query");
        for (GraphQLQueryProvider provider : this.queryProviders) {
            GraphQLObjectType query = provider.getQuery();
            object.field(GraphQLFieldDefinition.newFieldDefinition().type((GraphQLOutputType)query).staticValue(provider.context()).name(provider.getName()).description(query.getDescription()).build());
        }
        this.readOnlySchema = GraphQLSchema.newSchema().query(object.build()).build();
        if (this.mutationProviders.isEmpty()) {
            this.schema = this.readOnlySchema;
        } else {
            GraphQLObjectType.Builder mutationObject = GraphQLObjectType.newObject().name("mutation");
            for (GraphQLMutationProvider provider : this.mutationProviders) {
                provider.getMutations().forEach(arg_0 -> ((GraphQLObjectType.Builder)mutationObject).field(arg_0));
            }
            this.schema = GraphQLSchema.newSchema().query(object.build()).mutation(mutationObject.build()).build();
        }
    }

    public GraphQLServlet() {
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindQueryProvider(GraphQLQueryProvider queryProvider) {
        this.queryProviders.add(queryProvider);
        this.updateSchema();
    }

    public void unbindQueryProvider(GraphQLQueryProvider queryProvider) {
        this.queryProviders.remove(queryProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindMutationProvider(GraphQLMutationProvider mutationProvider) {
        this.mutationProviders.add(mutationProvider);
        this.updateSchema();
    }

    public void unbindMutationProvider(GraphQLMutationProvider mutationProvider) {
        this.mutationProviders.remove(mutationProvider);
        this.updateSchema();
    }

    @Override
    public String[] getQueries() {
        return (String[])this.schema.getQueryType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String[] getMutations() {
        return (String[])this.schema.getMutationType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    public void setContextProvider(GraphQLContextBuilder contextBuilder) {
        this.contextBuilder = contextBuilder;
    }

    public void unsetContextProvider(GraphQLContextBuilder contextBuilder) {
        this.contextBuilder = new DefaultGraphQLContextBuilder();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL)
    public void setExecutionStrategyProvider(ExecutionStrategyProvider provider) {
        this.executionStrategyProvider = provider;
    }

    public void unsetExecutionStrategyProvider(ExecutionStrategyProvider provider) {
        this.executionStrategyProvider = new EnhancedExecutionStrategyProvider();
    }

    protected GraphQLContext createContext(Optional<HttpServletRequest> req, Optional<HttpServletResponse> resp) {
        return this.contextBuilder.build(req, resp);
    }

    @Override
    public String executeQuery(String query) {
        try {
            ExecutionResult result = new GraphQL(this.schema).execute(query, (Object)this.createContext(Optional.empty(), Optional.empty()), new HashMap());
            if (result.getErrors().isEmpty()) {
                return new ObjectMapper().writeValueAsString(result.getData());
            }
            return new ObjectMapper().writeValueAsString(this.getGraphQLErrors(result));
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        GraphQLContext context = this.createContext(Optional.of(req), Optional.of(resp));
        String path = req.getPathInfo();
        if (path == null) {
            path = req.getServletPath();
        }
        if (path.contentEquals("/schema.json")) {
            this.query(CharStreams.toString((Readable)new InputStreamReader(GraphQLServlet.class.getResourceAsStream("introspectionQuery"))), new HashMap<String, Object>(), this.schema, req, resp, context);
        } else {
            this.query(req.getParameter("q"), new HashMap<String, Object>(), this.readOnlySchema, req, resp, context);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object inputStream;
        GraphQLContext context;
        block5: {
            context = this.createContext(Optional.of(req), Optional.of(resp));
            inputStream = null;
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                ServletFileUpload upload = new ServletFileUpload();
                try {
                    FileItemIterator it = upload.getItemIterator(req);
                    context.setFiles(Optional.of(it));
                    while (inputStream == null && it.hasNext()) {
                        FileItemStream stream = it.next();
                        if (!stream.getFieldName().contentEquals("graphql")) continue;
                        inputStream = stream.openStream();
                    }
                    if (inputStream == null) {
                        throw new ServletException("no query found");
                    }
                    break block5;
                }
                catch (FileUploadException e) {
                    throw new ServletException("no query found");
                }
            }
            inputStream = req.getInputStream();
        }
        Request request = (Request)new ObjectMapper().readValue((InputStream)inputStream, Request.class);
        this.query(request.query, request.variables, this.schema, req, resp, context);
    }

    private void query(final String query, final Map<String, Object> variables, final GraphQLSchema schema, final HttpServletRequest req, final HttpServletResponse resp, final GraphQLContext context) throws IOException {
        if (Subject.getSubject(AccessController.getContext()) == null && context.getSubject().isPresent()) {
            Subject.doAs(context.getSubject().get(), new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    GraphQLServlet.this.query(query, variables, schema, req, resp, context);
                    return null;
                }
            });
        } else {
            ExecutionResult result = new GraphQL(schema, this.executionStrategyProvider.getExecutionStrategy()).execute(query, (Object)context, variables);
            resp.setContentType("application/json");
            if (result.getErrors().isEmpty()) {
                HashMap<String, Object> dict = new HashMap<String, Object>();
                dict.put("data", result.getData());
                resp.getWriter().write(new ObjectMapper().writeValueAsString(dict));
            } else {
                result.getErrors().stream().filter(error -> error instanceof ExceptionWhileDataFetching).forEachOrdered(err -> log.error("{}", (Throwable)((ExceptionWhileDataFetching)err).getException()));
                resp.setStatus(500);
                List<GraphQLError> errors = this.getGraphQLErrors(result);
                HashMap<String, List<GraphQLError>> dict = new HashMap<String, List<GraphQLError>>();
                dict.put("errors", errors);
                resp.getWriter().write(new ObjectMapper().writeValueAsString(dict));
            }
        }
    }

    private List<GraphQLError> getGraphQLErrors(ExecutionResult result) {
        return result.getErrors().stream().filter(error -> error instanceof InvalidSyntaxError || error instanceof ValidationError).collect(Collectors.toList());
    }

    @Override
    public GraphQLSchema getSchema() {
        return this.schema;
    }

    @Override
    public GraphQLSchema getReadOnlySchema() {
        return this.readOnlySchema;
    }

    public static class Request {
        private String query;
        private Map<String, Object> variables = new HashMap<String, Object>();
        private String operationName;

        public void setVariables(String variables) {
            this.variables = (Map)new ObjectMapper().readValue(variables, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public void setOperationName(String operationName) {
            this.operationName = operationName;
        }
    }
}

