/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.language.Argument;
import graphql.schema.GraphQLArgument;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;

public class ArgumentsOfCorrectType
extends AbstractRule {
    public ArgumentsOfCorrectType(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkArgument(Argument argument) {
        GraphQLArgument fieldArgument = this.getValidationContext().getArgument();
        if (fieldArgument == null) {
            return;
        }
        if (!this.getValidationUtil().isValidLiteralValue(argument.getValue(), fieldArgument.getType())) {
            String message = String.format("argument value %s has wrong type", argument.getValue());
            this.addError(new ValidationError(ValidationErrorType.WrongType, argument.getSourceLocation(), message));
        }
    }
}

