/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.language.Argument;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationError;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;

public class KnownArgumentNames
extends AbstractRule {
    public KnownArgumentNames(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkArgument(Argument argument) {
        GraphQLFieldDefinition fieldDef = this.getValidationContext().getFieldDef();
        if (fieldDef == null) {
            return;
        }
        GraphQLArgument fieldArgument = fieldDef.getArgument(argument.getName());
        if (fieldArgument == null) {
            String message = String.format("Unknown argument %s", argument.getName());
            this.addError(new ValidationError(ValidationErrorType.UnknownArgument, argument.getSourceLocation(), message));
        }
    }
}

