/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLOutputType;
import java.lang.reflect.Field;
import java.util.Map;

public class FieldDataFetcher
implements DataFetcher {
    private final String fieldName;

    public FieldDataFetcher(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public Object get(DataFetchingEnvironment environment) {
        Object source = environment.getSource();
        if (source == null) {
            return null;
        }
        if (source instanceof Map) {
            return ((Map)source).get(this.fieldName);
        }
        return this.getFieldValue(source, environment.getFieldType());
    }

    private Object getFieldValue(Object object, GraphQLOutputType outputType) {
        try {
            Field field = object.getClass().getField(this.fieldName);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

