/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation;

import graphql.ShouldNotHappenException;
import graphql.language.ArrayValue;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.Value;
import graphql.language.VariableReference;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import java.util.LinkedHashMap;
import java.util.Map;

public class ValidationUtil {
    public TypeName getUnmodifiedType(Type type) {
        if (type instanceof ListType) {
            return this.getUnmodifiedType(((ListType)type).getType());
        }
        if (type instanceof NonNullType) {
            return this.getUnmodifiedType(((NonNullType)type).getType());
        }
        if (type instanceof TypeName) {
            return (TypeName)type;
        }
        throw new ShouldNotHappenException();
    }

    public boolean isValidLiteralValue(Value value, GraphQLType type) {
        if (value == null) {
            return !(type instanceof GraphQLNonNull);
        }
        if (value instanceof VariableReference) {
            return true;
        }
        if (type instanceof GraphQLNonNull) {
            return this.isValidLiteralValue(value, ((GraphQLNonNull)type).getWrappedType());
        }
        if (type instanceof GraphQLScalarType) {
            return ((GraphQLScalarType)type).getCoercing().parseLiteral(value) != null;
        }
        if (type instanceof GraphQLEnumType) {
            return ((GraphQLEnumType)type).getCoercing().parseLiteral(value) != null;
        }
        if (type instanceof GraphQLList) {
            return this.isValidLiteralValue(value, (GraphQLList)type);
        }
        if (type instanceof GraphQLInputObjectType) {
            return this.isValidLiteralValue(value, (GraphQLInputObjectType)type);
        }
        return false;
    }

    private boolean isValidLiteralValue(Value value, GraphQLInputObjectType type) {
        if (!(value instanceof ObjectValue)) {
            return false;
        }
        ObjectValue objectValue = (ObjectValue)value;
        Map<String, ObjectField> objectFieldMap = this.fieldMap(objectValue);
        if (this.isFieldMissing(type, objectFieldMap)) {
            return false;
        }
        for (ObjectField objectField : objectValue.getObjectFields()) {
            GraphQLInputObjectField inputObjectField = type.getField(objectField.getName());
            if (inputObjectField == null) {
                return false;
            }
            if (this.isValidLiteralValue(objectField.getValue(), inputObjectField.getType())) continue;
            return false;
        }
        return true;
    }

    private boolean isFieldMissing(GraphQLInputObjectType type, Map<String, ObjectField> objectFieldMap) {
        for (GraphQLInputObjectField inputObjectField : type.getFields()) {
            if (objectFieldMap.containsKey(inputObjectField.getName()) || !(inputObjectField.getType() instanceof GraphQLNonNull)) continue;
            return true;
        }
        return false;
    }

    private Map<String, ObjectField> fieldMap(ObjectValue objectValue) {
        LinkedHashMap<String, ObjectField> result = new LinkedHashMap<String, ObjectField>();
        for (ObjectField objectField : objectValue.getObjectFields()) {
            result.put(objectField.getName(), objectField);
        }
        return result;
    }

    private boolean isValidLiteralValue(Value value, GraphQLList type) {
        GraphQLType wrappedType = type.getWrappedType();
        if (value instanceof ArrayValue) {
            for (Value innerValue : ((ArrayValue)value).getValues()) {
                if (this.isValidLiteralValue(innerValue, wrappedType)) continue;
                return false;
            }
            return true;
        }
        return this.isValidLiteralValue(value, wrappedType);
    }
}

