/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.io.CharStreams;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.GraphQLError;
import graphql.InvalidSyntaxError;
import graphql.execution.ExecutionStrategy;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLSchema;
import graphql.servlet.GraphQLContext;
import graphql.servlet.GraphQLMBean;
import graphql.servlet.GraphQLOperationListener;
import graphql.servlet.GraphQLSchemaProvider;
import graphql.validation.ValidationError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GraphQLServlet
extends HttpServlet
implements Servlet,
GraphQLMBean,
GraphQLSchemaProvider {
    private static final Logger log = LoggerFactory.getLogger(GraphQLServlet.class);
    private List<GraphQLOperationListener> operationListeners;

    protected abstract GraphQLContext createContext(Optional<HttpServletRequest> var1, Optional<HttpServletResponse> var2);

    protected abstract ExecutionStrategy getExecutionStrategy();

    protected abstract Map<String, Object> transformVariables(GraphQLSchema var1, String var2, Map<String, Object> var3);

    public GraphQLServlet() {
        this(new ArrayList<GraphQLOperationListener>());
    }

    public GraphQLServlet(List<GraphQLOperationListener> operationListeners) {
        this.operationListeners = new ArrayList<GraphQLOperationListener>(operationListeners);
    }

    public void addOperationListener(GraphQLOperationListener operationListener) {
        this.operationListeners.add(operationListener);
    }

    public void removeOperationListener(GraphQLOperationListener operationListener) {
        this.operationListeners.remove(operationListener);
    }

    @Override
    public String[] getQueries() {
        return (String[])this.getSchema().getQueryType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String[] getMutations() {
        return (String[])this.getSchema().getMutationType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String executeQuery(String query) {
        try {
            ExecutionResult result = new GraphQL(this.getSchema()).execute(query, (Object)this.createContext(Optional.empty(), Optional.empty()), new HashMap());
            if (result.getErrors().isEmpty()) {
                return new ObjectMapper().writeValueAsString(result.getData());
            }
            return new ObjectMapper().writeValueAsString(this.getGraphQLErrors(result));
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        GraphQLContext context = this.createContext(Optional.of(req), Optional.of(resp));
        String path = req.getPathInfo();
        if (path == null) {
            path = req.getServletPath();
        }
        if (path.contentEquals("/schema.json")) {
            this.query(CharStreams.toString((Readable)new InputStreamReader(GraphQLServlet.class.getResourceAsStream("introspectionQuery"))), null, new HashMap<String, Object>(), this.getSchema(), req, resp, context);
        } else if (req.getParameter("q") != null) {
            this.query(req.getParameter("q"), null, new HashMap<String, Object>(), this.getReadOnlySchema(), req, resp, context);
        } else if (req.getParameter("query") != null) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            if (req.getParameter("variables") != null) {
                variables.putAll((Map)new ObjectMapper().readValue(req.getParameter("variables"), (TypeReference)new TypeReference<Map<String, Object>>(){}));
            }
            String operationName = null;
            if (req.getParameter("operationName") != null) {
                operationName = req.getParameter("operationName");
            }
            this.query(req.getParameter("query"), operationName, variables, this.getReadOnlySchema(), req, resp, context);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Request request;
        HashMap<String, Object> variables;
        Object inputStream;
        GraphQLContext context;
        block6: {
            context = this.createContext(Optional.of(req), Optional.of(resp));
            inputStream = null;
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                ServletFileUpload upload = new ServletFileUpload();
                try {
                    FileItemIterator it = upload.getItemIterator(req);
                    context.setFiles(Optional.of(it));
                    while (inputStream == null && it.hasNext()) {
                        FileItemStream stream = it.next();
                        if (!stream.getFieldName().contentEquals("graphql")) continue;
                        inputStream = stream.openStream();
                    }
                    if (inputStream == null) {
                        throw new ServletException("no query found");
                    }
                    break block6;
                }
                catch (FileUploadException e) {
                    throw new ServletException("no query found");
                }
            }
            inputStream = req.getInputStream();
        }
        if ((variables = (request = (Request)new ObjectMapper().readValue((InputStream)inputStream, Request.class)).variables) == null) {
            variables = new HashMap<String, Object>();
        }
        this.query(request.query, request.operationName, variables, this.getSchema(), req, resp, context);
    }

    private void query(final String query, final String operationName, final Map<String, Object> variables, final GraphQLSchema schema, final HttpServletRequest req, final HttpServletResponse resp, final GraphQLContext context) throws IOException {
        if (Subject.getSubject(AccessController.getContext()) == null && context.getSubject().isPresent()) {
            Subject.doAs(context.getSubject().get(), new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    GraphQLServlet.this.query(query, operationName, variables, schema, req, resp, context);
                    return null;
                }
            });
        } else {
            Map<String, Object> vars = this.transformVariables(schema, query, variables);
            this.operationListeners.forEach(l -> l.beforeGraphQLOperation(context, operationName, query, vars));
            ExecutionResult result = new GraphQL(schema, this.getExecutionStrategy()).execute(query, operationName, (Object)context, vars);
            resp.setContentType("application/json;charset=utf-8");
            if (result.getErrors().isEmpty()) {
                HashMap<String, Object> dict = new HashMap<String, Object>();
                dict.put("data", result.getData());
                resp.getWriter().write(new ObjectMapper().writeValueAsString(dict));
                this.operationListeners.forEach(l -> l.onSuccessfulGraphQLOperation(context, operationName, query, vars, result.getData()));
            } else {
                resp.setStatus(500);
                List<GraphQLError> errors = this.getGraphQLErrors(result);
                HashMap<String, List<GraphQLError>> dict = new HashMap<String, List<GraphQLError>>();
                dict.put("errors", errors);
                resp.getWriter().write(new ObjectMapper().writeValueAsString(dict));
                this.operationListeners.forEach(l -> l.onFailedGraphQLOperation(context, operationName, query, vars, result.getErrors()));
            }
        }
    }

    private List<GraphQLError> getGraphQLErrors(ExecutionResult result) {
        return result.getErrors().stream().filter(error -> error instanceof InvalidSyntaxError || error instanceof ValidationError).collect(Collectors.toList());
    }

    public static class Request {
        private String query;
        @JsonDeserialize(using=VariablesDeserializer.class)
        private Map<String, Object> variables = new HashMap<String, Object>();
        private String operationName;

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public void setVariables(Map<String, Object> variables) {
            this.variables = variables;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public void setOperationName(String operationName) {
            this.operationName = operationName;
        }
    }

    protected static class VariablesDeserializer
    extends JsonDeserializer<Map<String, Object>> {
        protected VariablesDeserializer() {
        }

        public Map<String, Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Object o = p.readValueAs(Object.class);
            if (o instanceof Map) {
                return (Map)o;
            }
            if (o instanceof String) {
                return (Map)new ObjectMapper().readValue((String)o, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            throw new RuntimeJsonMappingException("variables should be either an object or a string");
        }
    }
}

