/*
 * Decompiled with CFR 0.152.
 */
package graphql.servlet;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import graphql.ExecutionResult;
import graphql.schema.GraphQLFieldDefinition;
import graphql.servlet.GraphQLBatchedInvocationInput;
import graphql.servlet.GraphQLInvocationInputFactory;
import graphql.servlet.GraphQLMBean;
import graphql.servlet.GraphQLObjectMapper;
import graphql.servlet.GraphQLQueryInvoker;
import graphql.servlet.GraphQLServletListener;
import graphql.servlet.GraphQLSingleInvocationInput;
import graphql.servlet.internal.GraphQLRequest;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.AsyncContext;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGraphQLHttpServlet
extends HttpServlet
implements Servlet,
GraphQLMBean {
    public static final Logger log = LoggerFactory.getLogger(AbstractGraphQLHttpServlet.class);
    public static final String APPLICATION_JSON_UTF8 = "application/json;charset=UTF-8";
    public static final String APPLICATION_GRAPHQL = "application/graphql";
    public static final int STATUS_OK = 200;
    public static final int STATUS_BAD_REQUEST = 400;
    private static final GraphQLRequest INTROSPECTION_REQUEST = new GraphQLRequest("\n  query IntrospectionQuery {\n    __schema {\n      queryType { name }\n      mutationType { name }\n      subscriptionType { name }\n      types {\n        ...FullType\n      }\n      directives {\n        name\n        description\n        locations\n        args {\n          ...InputValue\n        }\n      }\n    }\n  }\n\n  fragment FullType on __Type {\n    kind\n    name\n    description\n    fields(includeDeprecated: true) {\n      name\n      description\n      args {\n        ...InputValue\n      }\n      type {\n        ...TypeRef\n      }\n      isDeprecated\n      deprecationReason\n    }\n    inputFields {\n      ...InputValue\n    }\n    interfaces {\n      ...TypeRef\n    }\n    enumValues(includeDeprecated: true) {\n      name\n      description\n      isDeprecated\n      deprecationReason\n    }\n    possibleTypes {\n      ...TypeRef\n    }\n  }\n\n  fragment InputValue on __InputValue {\n    name\n    description\n    type { ...TypeRef }\n    defaultValue\n  }\n\n  fragment TypeRef on __Type {\n    kind\n    name\n    ofType {\n      kind\n      name\n      ofType {\n        kind\n        name\n        ofType {\n          kind\n          name\n        }\n      }\n    }\n  }\n", new HashMap<String, Object>(), null);
    private final List<GraphQLServletListener> listeners;
    private final HttpRequestHandler getHandler;
    private final HttpRequestHandler postHandler;
    private final boolean asyncServletMode;

    protected abstract GraphQLQueryInvoker getQueryInvoker();

    protected abstract GraphQLInvocationInputFactory getInvocationInputFactory();

    protected abstract GraphQLObjectMapper getGraphQLObjectMapper();

    public AbstractGraphQLHttpServlet() {
        this(null, false);
    }

    public AbstractGraphQLHttpServlet(List<GraphQLServletListener> listeners, boolean asyncServletMode) {
        this.listeners = listeners != null ? new ArrayList<GraphQLServletListener>(listeners) : new ArrayList();
        this.asyncServletMode = asyncServletMode;
        this.getHandler = (request, response) -> {
            GraphQLInvocationInputFactory invocationInputFactory = this.getInvocationInputFactory();
            GraphQLObjectMapper graphQLObjectMapper = this.getGraphQLObjectMapper();
            GraphQLQueryInvoker queryInvoker = this.getQueryInvoker();
            String path = request.getPathInfo();
            if (path == null) {
                path = request.getServletPath();
            }
            if (path.contentEquals("/schema.json")) {
                this.query(queryInvoker, graphQLObjectMapper, invocationInputFactory.create(INTROSPECTION_REQUEST, request), response);
            } else {
                String query = request.getParameter("query");
                if (query != null) {
                    if (this.isBatchedQuery(query)) {
                        this.queryBatched(queryInvoker, graphQLObjectMapper, invocationInputFactory.createReadOnly(graphQLObjectMapper.readBatchedGraphQLRequest(query), request), response);
                    } else {
                        HashMap<String, Object> variables = new HashMap<String, Object>();
                        if (request.getParameter("variables") != null) {
                            variables.putAll(graphQLObjectMapper.deserializeVariables(request.getParameter("variables")));
                        }
                        String operationName = request.getParameter("operationName");
                        this.query(queryInvoker, graphQLObjectMapper, invocationInputFactory.createReadOnly(new GraphQLRequest(query, variables, operationName), request), response);
                    }
                } else {
                    response.setStatus(400);
                    log.info("Bad GET request: path was not \"/schema.json\" or no query variable named \"query\" given");
                }
            }
        };
        this.postHandler = (request, response) -> {
            GraphQLInvocationInputFactory invocationInputFactory = this.getInvocationInputFactory();
            GraphQLObjectMapper graphQLObjectMapper = this.getGraphQLObjectMapper();
            GraphQLQueryInvoker queryInvoker = this.getQueryInvoker();
            try {
                if (APPLICATION_GRAPHQL.equals(request.getContentType())) {
                    String query = CharStreams.toString((Readable)request.getReader());
                    this.query(queryInvoker, graphQLObjectMapper, invocationInputFactory.create(new GraphQLRequest(query, null, null)), response);
                } else if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data") && !request.getParts().isEmpty()) {
                    Optional<Part> queryItem;
                    Map<String, List<Part>> fileItems = request.getParts().stream().collect(Collectors.toMap(Part::getName, Collections::singletonList, (l1, l2) -> Stream.concat(l1.stream(), l2.stream()).collect(Collectors.toList())));
                    if (fileItems.containsKey("graphql")) {
                        Optional<Part> graphqlItem = this.getFileItem(fileItems, "graphql");
                        if (graphqlItem.isPresent()) {
                            InputStream inputStream = graphqlItem.get().getInputStream();
                            if (!inputStream.markSupported()) {
                                inputStream = new BufferedInputStream(inputStream);
                            }
                            if (this.isBatchedQuery(inputStream)) {
                                GraphQLBatchedInvocationInput invocationInput = invocationInputFactory.create(graphQLObjectMapper.readBatchedGraphQLRequest(inputStream), request);
                                invocationInput.getContext().setFiles(fileItems);
                                this.queryBatched(queryInvoker, graphQLObjectMapper, invocationInput, response);
                                return;
                            }
                            GraphQLSingleInvocationInput invocationInput = invocationInputFactory.create(graphQLObjectMapper.readGraphQLRequest(inputStream), request);
                            invocationInput.getContext().setFiles(fileItems);
                            this.query(queryInvoker, graphQLObjectMapper, invocationInput, response);
                            return;
                        }
                    } else if (fileItems.containsKey("query") && (queryItem = this.getFileItem(fileItems, "query")).isPresent()) {
                        InputStream inputStream = queryItem.get().getInputStream();
                        if (!inputStream.markSupported()) {
                            inputStream = new BufferedInputStream(inputStream);
                        }
                        if (this.isBatchedQuery(inputStream)) {
                            GraphQLBatchedInvocationInput invocationInput = invocationInputFactory.create(graphQLObjectMapper.readBatchedGraphQLRequest(inputStream), request);
                            invocationInput.getContext().setFiles(fileItems);
                            this.queryBatched(queryInvoker, graphQLObjectMapper, invocationInput, response);
                            return;
                        }
                        String query = new String(ByteStreams.toByteArray((InputStream)inputStream));
                        Map<String, Object> variables = null;
                        Optional<Part> variablesItem = this.getFileItem(fileItems, "variables");
                        if (variablesItem.isPresent()) {
                            variables = graphQLObjectMapper.deserializeVariables(new String(ByteStreams.toByteArray((InputStream)variablesItem.get().getInputStream())));
                        }
                        String operationName = null;
                        Optional<Part> operationNameItem = this.getFileItem(fileItems, "operationName");
                        if (operationNameItem.isPresent()) {
                            operationName = new String(ByteStreams.toByteArray((InputStream)operationNameItem.get().getInputStream())).trim();
                        }
                        GraphQLSingleInvocationInput invocationInput = invocationInputFactory.create(new GraphQLRequest(query, variables, operationName), request);
                        invocationInput.getContext().setFiles(fileItems);
                        this.query(queryInvoker, graphQLObjectMapper, invocationInput, response);
                        return;
                    }
                    response.setStatus(400);
                    log.info("Bad POST multipart request: no part named \"graphql\" or \"query\"");
                } else {
                    Object inputStream = request.getInputStream();
                    if (!inputStream.markSupported()) {
                        inputStream = new BufferedInputStream((InputStream)inputStream);
                    }
                    if (this.isBatchedQuery((InputStream)inputStream)) {
                        this.queryBatched(queryInvoker, graphQLObjectMapper, invocationInputFactory.create(graphQLObjectMapper.readBatchedGraphQLRequest((InputStream)inputStream), request), response);
                    } else {
                        this.query(queryInvoker, graphQLObjectMapper, invocationInputFactory.create(graphQLObjectMapper.readGraphQLRequest((InputStream)inputStream), request), response);
                    }
                }
            }
            catch (Exception e) {
                log.info("Bad POST request: parsing failed", (Throwable)e);
                response.setStatus(400);
            }
        };
    }

    public void addListener(GraphQLServletListener servletListener) {
        this.listeners.add(servletListener);
    }

    public void removeListener(GraphQLServletListener servletListener) {
        this.listeners.remove(servletListener);
    }

    @Override
    public String[] getQueries() {
        return (String[])this.getInvocationInputFactory().getSchemaProvider().getSchema().getQueryType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String[] getMutations() {
        return (String[])this.getInvocationInputFactory().getSchemaProvider().getSchema().getMutationType().getFieldDefinitions().stream().map(GraphQLFieldDefinition::getName).toArray(String[]::new);
    }

    @Override
    public String executeQuery(String query) {
        try {
            return this.getGraphQLObjectMapper().serializeResultAsJson(this.getQueryInvoker().query(this.getInvocationInputFactory().create(new GraphQLRequest(query, new HashMap<String, Object>(), null))));
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    private void doRequestAsync(HttpServletRequest request, HttpServletResponse response, HttpRequestHandler handler) {
        if (this.asyncServletMode) {
            AsyncContext asyncContext = request.startAsync();
            HttpServletRequest asyncRequest = (HttpServletRequest)asyncContext.getRequest();
            HttpServletResponse asyncResponse = (HttpServletResponse)asyncContext.getResponse();
            new Thread(() -> this.doRequest(asyncRequest, asyncResponse, handler, asyncContext)).start();
        } else {
            this.doRequest(request, response, handler, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(HttpServletRequest request, HttpServletResponse response, HttpRequestHandler handler, AsyncContext asyncContext) {
        List<GraphQLServletListener.RequestCallback> requestCallbacks = this.runListeners(l -> l.onRequest(request, response));
        try {
            handler.handle(request, response);
            this.runCallbacks(requestCallbacks, c -> c.onSuccess(request, response));
        }
        catch (Throwable t) {
            response.setStatus(500);
            log.error("Error executing GraphQL request!", t);
            this.runCallbacks(requestCallbacks, c -> c.onError(request, response, t));
        }
        finally {
            this.runCallbacks(requestCallbacks, c -> c.onFinally(request, response));
            if (asyncContext != null) {
                asyncContext.complete();
            }
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequestAsync(req, resp, this.getHandler);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doRequestAsync(req, resp, this.postHandler);
    }

    private Optional<Part> getFileItem(Map<String, List<Part>> fileItems, String name) {
        return Optional.ofNullable(fileItems.get(name)).filter(list -> !list.isEmpty()).map(list -> (Part)list.get(0));
    }

    private void query(GraphQLQueryInvoker queryInvoker, GraphQLObjectMapper graphQLObjectMapper, GraphQLSingleInvocationInput invocationInput, HttpServletResponse resp) throws IOException {
        ExecutionResult result = queryInvoker.query(invocationInput);
        resp.setContentType(APPLICATION_JSON_UTF8);
        resp.setStatus(200);
        resp.getWriter().write(graphQLObjectMapper.serializeResultAsJson(result));
    }

    private void queryBatched(GraphQLQueryInvoker queryInvoker, GraphQLObjectMapper graphQLObjectMapper, GraphQLBatchedInvocationInput invocationInput, HttpServletResponse resp) throws Exception {
        resp.setContentType(APPLICATION_JSON_UTF8);
        resp.setStatus(200);
        PrintWriter respWriter = resp.getWriter();
        ((Writer)respWriter).write(91);
        queryInvoker.query(invocationInput, (result, hasNext) -> {
            respWriter.write(graphQLObjectMapper.serializeResultAsJson(result));
            if (hasNext.booleanValue()) {
                respWriter.write(44);
            }
        });
        ((Writer)respWriter).write(93);
    }

    private <R> List<R> runListeners(Function<? super GraphQLServletListener, R> action) {
        if (this.listeners == null) {
            return Collections.emptyList();
        }
        return this.listeners.stream().map(listener -> {
            try {
                return action.apply((GraphQLServletListener)listener);
            }
            catch (Throwable t) {
                log.error("Error running listener: {}", listener, (Object)t);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private <T> void runCallbacks(List<T> callbacks, Consumer<T> action) {
        callbacks.forEach(callback -> {
            try {
                action.accept(callback);
            }
            catch (Throwable t) {
                log.error("Error running callback: {}", callback, (Object)t);
            }
        });
    }

    private boolean isBatchedQuery(InputStream inputStream) throws IOException {
        int length;
        if (inputStream == null) {
            return false;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[128];
        inputStream.mark(0);
        while ((length = inputStream.read(buffer)) != -1) {
            result.write(buffer, 0, length);
            String chunk = result.toString();
            Boolean isArrayStart = this.isArrayStart(chunk);
            if (isArrayStart == null) continue;
            inputStream.reset();
            return isArrayStart;
        }
        inputStream.reset();
        return false;
    }

    private boolean isBatchedQuery(String query) {
        if (query == null) {
            return false;
        }
        Boolean isArrayStart = this.isArrayStart(query);
        return isArrayStart != null && isArrayStart != false;
    }

    private Boolean isArrayStart(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return ch == '[';
        }
        return null;
    }

    protected static interface HttpRequestHandler
    extends BiConsumer<HttpServletRequest, HttpServletResponse> {
        @Override
        default public void accept(HttpServletRequest request, HttpServletResponse response) {
            try {
                this.handle(request, response);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void handle(HttpServletRequest var1, HttpServletResponse var2) throws Exception;
    }
}

