/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.sdk.api;

import com.groupdocs.sdk.common.ApiException;
import com.groupdocs.sdk.common.ApiInvoker;
import com.groupdocs.sdk.model.CompressResponse;
import com.groupdocs.sdk.model.CreateFolderResponse;
import com.groupdocs.sdk.model.CreatePackageResponse;
import com.groupdocs.sdk.model.DeleteResponse;
import com.groupdocs.sdk.model.FileMoveResponse;
import com.groupdocs.sdk.model.FolderMoveResponse;
import com.groupdocs.sdk.model.ListEntitiesResponse;
import com.groupdocs.sdk.model.StorageInfoResponse;
import com.groupdocs.sdk.model.UploadResponse;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

public class StorageApi {
    String basePath = "https://api.groupdocs.com/v2.0";
    ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public StorageInfoResponse GetStorageInfo(String userId) throws ApiException {
        String resourcePath = "/storage/{userId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (StorageInfoResponse)ApiInvoker.deserialize(response, "", StorageInfoResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public ListEntitiesResponse ListEntities(String userId, String path, Integer pageIndex, Integer pageSize, String orderBy, Boolean orderAsc, String filter, String fileTypes, Boolean extended) throws ApiException {
        String resourcePath = "/storage/{userId}/folders/{*path}?page={pageIndex}&amp;count={pageSize}&amp;order_by={orderBy}&amp;order_asc={orderAsc}&amp;filter={filter}&amp;file_types={fileTypes}&amp;extended={extended}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{path}", String.valueOf(path)).replace("{pageIndex}", String.valueOf(pageIndex)).replace("{pageSize}", String.valueOf(pageSize)).replace("{orderBy}", String.valueOf(orderBy)).replace("{orderAsc}", String.valueOf(orderAsc)).replace("{filter}", String.valueOf(filter)).replace("{fileTypes}", String.valueOf(fileTypes)).replace("{extended}", String.valueOf(extended));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || path == null || pageIndex == null || pageSize == null || orderBy == null || orderAsc == null || filter == null || fileTypes == null || extended == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (ListEntitiesResponse)ApiInvoker.deserialize(response, "", ListEntitiesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public String GetFile(String userId, String fileId) throws ApiException {
        String resourcePath = "/storage/{userId}/files/{fileId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (String)ApiInvoker.deserialize(response, "", String.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public String GetSharedFile(String userEmail, String filePath) throws ApiException {
        String resourcePath = "/storage/shared/{userEmail}/{*filePath}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userEmail}", String.valueOf(userEmail)).replace("{filePath}", String.valueOf(filePath));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userEmail == null || filePath == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams);
            if (response != null) {
                return (String)ApiInvoker.deserialize(response, "", String.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UploadResponse Upload(String userId, String path, String description, InputStream body) throws ApiException {
        String resourcePath = "/storage/{userId}/folders/{*path}?description={description}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{path}", String.valueOf(path)).replace("{description}", String.valueOf(description));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || path == null || description == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams);
            if (response != null) {
                return (UploadResponse)ApiInvoker.deserialize(response, "", UploadResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UploadResponse UploadWeb(String userId, String url) throws ApiException {
        String resourcePath = "/storage/{userId}/urls?url={url}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{url}", String.valueOf(url));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || url == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, null, headerParams);
            if (response != null) {
                return (UploadResponse)ApiInvoker.deserialize(response, "", UploadResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UploadResponse UploadGoogle(String userId, String path, String fileId) throws ApiException {
        String resourcePath = "/storage/{userId}/google/files/{*path}?file_id={fileId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{path}", String.valueOf(path)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || path == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, null, headerParams);
            if (response != null) {
                return (UploadResponse)ApiInvoker.deserialize(response, "", UploadResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DeleteResponse Delete(String userId, String fileId) throws ApiException {
        String resourcePath = "/storage/{userId}/files/{fileId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams);
            if (response != null) {
                return (DeleteResponse)ApiInvoker.deserialize(response, "", DeleteResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DeleteResponse DeleteFromFolder(String userId, String path) throws ApiException {
        String resourcePath = "/storage/{userId}/folders/{*path}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{path}", String.valueOf(path));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || path == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams);
            if (response != null) {
                return (DeleteResponse)ApiInvoker.deserialize(response, "", DeleteResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public FileMoveResponse MoveFile(String userId, String path, String mode, String Groupdocs_Move, String Groupdocs_Copy) throws ApiException {
        String resourcePath = "/storage/{userId}/files/{*path}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{path}", String.valueOf(path)).replace("{mode}", String.valueOf(mode));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || path == null || mode == null) {
            throw new ApiException(400, "missing required params");
        }
        headerParams.put("Groupdocs-Move", Groupdocs_Move);
        headerParams.put("Groupdocs-Copy", Groupdocs_Copy);
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, null, headerParams);
            if (response != null) {
                return (FileMoveResponse)ApiInvoker.deserialize(response, "", FileMoveResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public FolderMoveResponse MoveFolder(String userId, String path, String mode, String Groupdocs_Copy, String Groupdocs_Move) throws ApiException {
        String resourcePath = "/storage/{userId}/folders/{*path}?override_mode={mode}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{path}", String.valueOf(path)).replace("{mode}", String.valueOf(mode));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || path == null || mode == null) {
            throw new ApiException(400, "missing required params");
        }
        headerParams.put("Groupdocs-Copy", Groupdocs_Copy);
        headerParams.put("Groupdocs-Move", Groupdocs_Move);
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, null, headerParams);
            if (response != null) {
                return (FolderMoveResponse)ApiInvoker.deserialize(response, "", FolderMoveResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public CreateFolderResponse Create(String userId, String path) throws ApiException {
        String resourcePath = "/storage/{userId}/paths/{*path}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{path}", String.valueOf(path));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || path == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, null, headerParams);
            if (response != null) {
                return (CreateFolderResponse)ApiInvoker.deserialize(response, "", CreateFolderResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public CompressResponse Compress(String userId, String fileId, String archiveType) throws ApiException {
        String resourcePath = "/storage/{userId}/files/{fileId}/archive/{archiveType}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId)).replace("{archiveType}", String.valueOf(archiveType));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || fileId == null || archiveType == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, null, headerParams);
            if (response != null) {
                return (CompressResponse)ApiInvoker.deserialize(response, "", CompressResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public CreatePackageResponse CreatePackage(String userId, String packageName, Boolean storeRelativePath, List<String> body) throws ApiException {
        String resourcePath = "/storage/{userId}/packages/{packageName}?storeRelativePath={storeRelativePath}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{packageName}", String.valueOf(packageName)).replace("{storeRelativePath}", String.valueOf(storeRelativePath));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || packageName == null || storeRelativePath == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams);
            if (response != null) {
                return (CreatePackageResponse)ApiInvoker.deserialize(response, "", CreatePackageResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public FolderMoveResponse MoveToTrash(String userId, String path) throws ApiException {
        String resourcePath = "/storage/{userId}/trash/{*path}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{path}", String.valueOf(path));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || path == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, null, headerParams);
            if (response != null) {
                return (FolderMoveResponse)ApiInvoker.deserialize(response, "", FolderMoveResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DeleteResponse RestoreFromTrash(String userId, String path) throws ApiException {
        String resourcePath = "/storage/{userId}/trash/{*path}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{path}", String.valueOf(path));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (userId == null || path == null) {
            throw new ApiException(400, "missing required params");
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams);
            if (response != null) {
                return (DeleteResponse)ApiInvoker.deserialize(response, "", DeleteResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }
}

