/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.sdk.common;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.groupdocs.sdk.common.ApiException;
import com.groupdocs.sdk.common.RequestSigner;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.wordnik.swagger.core.util.JsonUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class ApiInvoker {
    private static ApiInvoker INSTANCE = new ApiInvoker();
    private Map<String, Client> hostMap = new HashMap<String, Client>();
    private Map<String, String> defaultHeaderMap = new HashMap<String, String>();
    private static final String ENC = "UTF-8";
    private RequestSigner signer;

    public static ApiInvoker getInstance() {
        return INSTANCE;
    }

    public void setRequestSigner(RequestSigner signer) {
        this.signer = signer;
    }

    public void addDefaultHeader(String key, String value) {
        this.defaultHeaderMap.put(key, value);
    }

    public String escapeString(String str) {
        return ApiInvoker.encodeURIComponent(str);
    }

    public static String encodeURI(String uri) {
        return ApiInvoker.encodeURIComponent(uri).replace("%3B", ";").replace("%2C", ",").replace("%2F", "/").replace("%3F", "?").replace("%3A", ":").replace("%40", "@").replace("%26", "&").replace("%3D", "=").replace("%24", "$").replace("%25", "%").replace("%23", "#");
    }

    public static String encodeURIComponent(String str) {
        try {
            return URLEncoder.encode(str, ENC).replace("+", "%20").replace("%21", "!").replace("%27", "'").replace("%28", "(").replace("%29", ")").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static Object deserialize(String json, String containerType, Class cls) throws ApiException {
        try {
            if ("List".equals(containerType)) {
                CollectionType typeInfo = JsonUtil.getJsonMapper().getTypeFactory().constructCollectionType(List.class, cls);
                List response = (List)JsonUtil.getJsonMapper().readValue(json, (JavaType)typeInfo);
                return response;
            }
            if (String.class.equals((Object)cls)) {
                return json;
            }
            return JsonUtil.getJsonMapper().readValue(json, cls);
        }
        catch (IOException e) {
            throw new ApiException(500, e.getMessage());
        }
    }

    public static String serialize(Object obj) throws ApiException {
        try {
            if (obj != null) {
                return JsonUtil.getJsonMapper().writeValueAsString(obj);
            }
            return "{}";
        }
        catch (Exception e) {
            throw new ApiException(500, e.getMessage());
        }
    }

    public String invokeAPI(String host, String path, String method, Map<String, String> queryParams, Object body, Map<String, String> headerParams) throws ApiException {
        Object requestBody;
        MediaType contentType;
        Client client = this.getClient(host);
        StringBuilder b = new StringBuilder();
        for (String key : queryParams.keySet()) {
            String value = queryParams.get(key);
            if (value == null) continue;
            if (b.toString().length() == 0) {
                b.append("?");
            } else {
                b.append("&");
            }
            b.append(this.escapeString(key)).append("=").append(this.escapeString(value));
        }
        String querystring = b.toString();
        boolean isFileUpload = false;
        if (body == null) {
            contentType = MediaType.TEXT_HTML_TYPE;
        } else {
            contentType = MediaType.APPLICATION_JSON_TYPE;
            if (body instanceof InputStream) {
                isFileUpload = true;
                contentType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
            }
        }
        WebResource.Builder builder = client.resource(ApiInvoker.encodeURI(this.signer.signUrl(host + path + querystring))).type(contentType);
        for (String key : headerParams.keySet()) {
            builder.header(key, (Object)headerParams.get(key));
        }
        for (String key : this.defaultHeaderMap.keySet()) {
            if (headerParams.containsKey(key)) continue;
            builder.header(key, (Object)this.defaultHeaderMap.get(key));
        }
        ClientResponse response = null;
        if ("GET".equals(method)) {
            response = (ClientResponse)builder.get(ClientResponse.class);
        } else if ("POST".equals(method)) {
            requestBody = isFileUpload ? body : this.signer.signContent(ApiInvoker.serialize(body), builder);
            response = (ClientResponse)builder.post(ClientResponse.class, requestBody);
        } else if ("PUT".equals(method)) {
            requestBody = isFileUpload ? body : this.signer.signContent(ApiInvoker.serialize(body), builder);
            response = (ClientResponse)builder.put(ClientResponse.class, requestBody);
        } else if ("DELETE".equals(method)) {
            response = (ClientResponse)builder.delete(ClientResponse.class, (Object)this.signer.signContent(ApiInvoker.serialize(body), builder));
        } else {
            throw new ApiException(500, "unknown method type " + method);
        }
        if (response.getClientResponseStatus() == ClientResponse.Status.OK || response.getClientResponseStatus() == ClientResponse.Status.CREATED || response.getClientResponseStatus() == ClientResponse.Status.ACCEPTED || response.getClientResponseStatus() == ClientResponse.Status.NOT_FOUND) {
            return (String)response.getEntity(String.class);
        }
        throw new ApiException(response.getClientResponseStatus().getStatusCode(), (String)response.getEntity(String.class));
    }

    private Client getClient(String host) {
        if (!this.hostMap.containsKey(host)) {
            Client client = Client.create();
            client.addFilter((ClientFilter)new LoggingFilter());
            this.hostMap.put(host, client);
        }
        return this.hostMap.get(host);
    }
}

