/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.sdk.api;

import com.groupdocs.sdk.common.ApiException;
import com.groupdocs.sdk.common.ApiInvoker;
import com.groupdocs.sdk.model.AddDatasourceResponse;
import com.groupdocs.sdk.model.AddDocumentDataSourceResponse;
import com.groupdocs.sdk.model.AddDocumentQuestionnaireResponse;
import com.groupdocs.sdk.model.AddQuestionnaireCollectorResponse;
import com.groupdocs.sdk.model.AddQuestionnaireExecutionResponse;
import com.groupdocs.sdk.model.CreateQuestionnaireResponse;
import com.groupdocs.sdk.model.Datasource;
import com.groupdocs.sdk.model.DatasourceField;
import com.groupdocs.sdk.model.DeleteDatasourceResponse;
import com.groupdocs.sdk.model.DeleteDocumentQuestionnaireResponse;
import com.groupdocs.sdk.model.DeleteQuestionnaireCollectorResponse;
import com.groupdocs.sdk.model.DeleteQuestionnaireExecutionResponse;
import com.groupdocs.sdk.model.DeleteQuestionnaireResponse;
import com.groupdocs.sdk.model.GetDatasourceResponse;
import com.groupdocs.sdk.model.GetDatasourcesResponse;
import com.groupdocs.sdk.model.GetDocumentQuestionnairesResponse;
import com.groupdocs.sdk.model.GetQuestionnaireCollectorResponse;
import com.groupdocs.sdk.model.GetQuestionnaireCollectorsResponse;
import com.groupdocs.sdk.model.GetQuestionnaireExecutionResponse;
import com.groupdocs.sdk.model.GetQuestionnaireExecutionsResponse;
import com.groupdocs.sdk.model.GetQuestionnaireMetadataResponse;
import com.groupdocs.sdk.model.GetQuestionnaireResponse;
import com.groupdocs.sdk.model.GetQuestionnairesResponse;
import com.groupdocs.sdk.model.GetTemplatesResponse;
import com.groupdocs.sdk.model.MergeTemplateResponse;
import com.groupdocs.sdk.model.QuestionnaireCollectorInfo;
import com.groupdocs.sdk.model.QuestionnaireExecutionInfo;
import com.groupdocs.sdk.model.QuestionnaireInfo;
import com.groupdocs.sdk.model.QuestionnaireMetadata;
import com.groupdocs.sdk.model.TemplateFieldsResponse;
import com.groupdocs.sdk.model.UpdateQuestionnaireCollectorResponse;
import com.groupdocs.sdk.model.UpdateQuestionnaireExecutionResponse;
import com.groupdocs.sdk.model.UpdateQuestionnaireResponse;
import java.util.HashMap;
import java.util.List;

public class MergeApi {
    String basePath = "https://api.groupdocs.com/v2.0";
    ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public AddDocumentDataSourceResponse AddJobDocumentDataSource(String userId, Integer jobId, Integer fileId, Integer datasourceId) throws ApiException {
        if (userId == null || jobId == null || fileId == null || datasourceId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/jobs/{jobId}/files/{fileId}/datasources/{datasourceId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{jobId}", String.valueOf(jobId)).replace("{fileId}", String.valueOf(fileId)).replace("{datasourceId}", String.valueOf(datasourceId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (AddDocumentDataSourceResponse)ApiInvoker.deserialize(response, "", AddDocumentDataSourceResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public AddDocumentDataSourceResponse AddJobDocumentDataSourceFields(String userId, String jobId, String fileId, List<DatasourceField> body) throws ApiException {
        if (userId == null || jobId == null || fileId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/jobs/{jobId}/files/{fileId}/datasources".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{jobId}", String.valueOf(jobId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (AddDocumentDataSourceResponse)ApiInvoker.deserialize(response, "", AddDocumentDataSourceResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public MergeTemplateResponse FillQuestionnaire(String userId, String collectorId, String datasourceId, String targetType, String emailResults) throws ApiException {
        if (userId == null || collectorId == null || datasourceId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/collectors/{collectorId}/datasources/{datasourceId}?new_type={targetType}&email_results={emailResults}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{collectorId}", String.valueOf(collectorId)).replace("{datasourceId}", String.valueOf(datasourceId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(targetType))) {
            queryParams.put("new_type", String.valueOf(targetType));
        }
        if (!"null".equals(String.valueOf(emailResults))) {
            queryParams.put("email_results", String.valueOf(emailResults));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (MergeTemplateResponse)ApiInvoker.deserialize(response, "", MergeTemplateResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public MergeTemplateResponse FillExecution(String userId, String executionId, String datasourceId, String targetType, String emailResults) throws ApiException {
        if (userId == null || executionId == null || datasourceId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/executions/{executionId}/datasources/{datasourceId}?new_type={targetType}&email_results={emailResults}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{executionId}", String.valueOf(executionId)).replace("{datasourceId}", String.valueOf(datasourceId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(targetType))) {
            queryParams.put("new_type", String.valueOf(targetType));
        }
        if (!"null".equals(String.valueOf(emailResults))) {
            queryParams.put("email_results", String.valueOf(emailResults));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (MergeTemplateResponse)ApiInvoker.deserialize(response, "", MergeTemplateResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public MergeTemplateResponse MergeDatasource(String userId, String fileId, String datasourceId, String targetType, String emailResults) throws ApiException {
        if (userId == null || fileId == null || datasourceId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/files/{fileId}/datasources/{datasourceId}?new_type={targetType}&email_results={emailResults}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId)).replace("{datasourceId}", String.valueOf(datasourceId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(targetType))) {
            queryParams.put("new_type", String.valueOf(targetType));
        }
        if (!"null".equals(String.valueOf(emailResults))) {
            queryParams.put("email_results", String.valueOf(emailResults));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (MergeTemplateResponse)ApiInvoker.deserialize(response, "", MergeTemplateResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public MergeTemplateResponse MergeDatasourceFields(String userId, String fileId, String targetType, String emailResults, String assemblyName, List<DatasourceField> body) throws ApiException {
        if (userId == null || fileId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/files/{fileId}/datasources?new_type={targetType}&email_results={emailResults}&assembly_name={assemblyName}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(targetType))) {
            queryParams.put("new_type", String.valueOf(targetType));
        }
        if (!"null".equals(String.valueOf(emailResults))) {
            queryParams.put("email_results", String.valueOf(emailResults));
        }
        if (!"null".equals(String.valueOf(assemblyName))) {
            queryParams.put("assembly_name", String.valueOf(assemblyName));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (MergeTemplateResponse)ApiInvoker.deserialize(response, "", MergeTemplateResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetQuestionnaireResponse GetQuestionnaire(String userId, String questionnaireId) throws ApiException {
        if (userId == null || questionnaireId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/{questionnaireId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{questionnaireId}", String.valueOf(questionnaireId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetQuestionnaireResponse)ApiInvoker.deserialize(response, "", GetQuestionnaireResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetQuestionnairesResponse GetQuestionnaires(String userId, String status, Integer pageNumber, Integer pageSize) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires?status={status}&page_number={pageNumber}&page_size={pageSize}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(status))) {
            queryParams.put("status", String.valueOf(status));
        }
        if (!"null".equals(String.valueOf(pageNumber))) {
            queryParams.put("page_number", String.valueOf(pageNumber));
        }
        if (!"null".equals(String.valueOf(pageSize))) {
            queryParams.put("page_size", String.valueOf(pageSize));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetQuestionnairesResponse)ApiInvoker.deserialize(response, "", GetQuestionnairesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public CreateQuestionnaireResponse CreateQuestionnaire(String userId, QuestionnaireInfo body) throws ApiException {
        if (userId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (CreateQuestionnaireResponse)ApiInvoker.deserialize(response, "", CreateQuestionnaireResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UpdateQuestionnaireResponse UpdateQuestionnaire(String userId, String questionnaireId, QuestionnaireInfo body) throws ApiException {
        if (userId == null || questionnaireId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/{questionnaireId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{questionnaireId}", String.valueOf(questionnaireId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (UpdateQuestionnaireResponse)ApiInvoker.deserialize(response, "", UpdateQuestionnaireResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DeleteQuestionnaireResponse DeleteQuestionnaire(String userId, String questionnaireId) throws ApiException {
        if (userId == null || questionnaireId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/{questionnaireId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{questionnaireId}", String.valueOf(questionnaireId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (DeleteQuestionnaireResponse)ApiInvoker.deserialize(response, "", DeleteQuestionnaireResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetDocumentQuestionnairesResponse GetDocumentQuestionnaires(String userId, String fileId) throws ApiException {
        if (userId == null || fileId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/files/{fileId}/questionnaires".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetDocumentQuestionnairesResponse)ApiInvoker.deserialize(response, "", GetDocumentQuestionnairesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public AddDocumentQuestionnaireResponse CreateDocumentQuestionnaire(String userId, String fileId, QuestionnaireInfo body) throws ApiException {
        if (userId == null || fileId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/files/{fileId}/questionnaires".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (AddDocumentQuestionnaireResponse)ApiInvoker.deserialize(response, "", AddDocumentQuestionnaireResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public AddDocumentQuestionnaireResponse AddDocumentQuestionnaire(String userId, String fileId, String questionnaireId) throws ApiException {
        if (userId == null || fileId == null || questionnaireId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/files/{fileId}/questionnaires/{questionnaireId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId)).replace("{questionnaireId}", String.valueOf(questionnaireId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (AddDocumentQuestionnaireResponse)ApiInvoker.deserialize(response, "", AddDocumentQuestionnaireResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DeleteDocumentQuestionnaireResponse DeleteDocumentQuestionnaire(String userId, String fileId, String questionnaireId) throws ApiException {
        if (userId == null || fileId == null || questionnaireId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/files/{fileId}/questionnaires/{questionnaireId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{fileId}", String.valueOf(fileId)).replace("{questionnaireId}", String.valueOf(questionnaireId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (DeleteDocumentQuestionnaireResponse)ApiInvoker.deserialize(response, "", DeleteDocumentQuestionnaireResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public AddDatasourceResponse AddDataSource(String userId, Datasource body) throws ApiException {
        if (userId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/datasources".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (AddDatasourceResponse)ApiInvoker.deserialize(response, "", AddDatasourceResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public AddDatasourceResponse UpdateDataSource(String userId, String datasourceId, Datasource body) throws ApiException {
        if (userId == null || datasourceId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/datasources/{datasourceId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{datasourceId}", String.valueOf(datasourceId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (AddDatasourceResponse)ApiInvoker.deserialize(response, "", AddDatasourceResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public AddDatasourceResponse UpdateDataSourceFields(String userId, String datasourceId, Datasource body) throws ApiException {
        if (userId == null || datasourceId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/datasources/{datasourceId}/fields".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{datasourceId}", String.valueOf(datasourceId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (AddDatasourceResponse)ApiInvoker.deserialize(response, "", AddDatasourceResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DeleteDatasourceResponse DeleteDataSource(String userId, String datasourceId) throws ApiException {
        if (userId == null || datasourceId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/datasources/{datasourceId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{datasourceId}", String.valueOf(datasourceId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (DeleteDatasourceResponse)ApiInvoker.deserialize(response, "", DeleteDatasourceResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetDatasourceResponse GetDataSource(String userId, String datasourceId, String fields) throws ApiException {
        if (userId == null || datasourceId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/datasources/{datasourceId}?field={fields}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{datasourceId}", String.valueOf(datasourceId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(fields))) {
            queryParams.put("field", String.valueOf(fields));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetDatasourceResponse)ApiInvoker.deserialize(response, "", GetDatasourceResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetDatasourcesResponse GetQuestionnaireDataSources(String userId, String questionnaireId, Boolean includeFields) throws ApiException {
        if (userId == null || questionnaireId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/{questionnaireId}/datasources?include_fields={includeFields}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{questionnaireId}", String.valueOf(questionnaireId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(includeFields))) {
            queryParams.put("include_fields", String.valueOf(includeFields));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetDatasourcesResponse)ApiInvoker.deserialize(response, "", GetDatasourcesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public AddQuestionnaireExecutionResponse AddQuestionnaireExecution(String userId, String collectorId, QuestionnaireExecutionInfo body) throws ApiException {
        if (userId == null || collectorId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/collectors/{collectorId}/executions".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{collectorId}", String.valueOf(collectorId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (AddQuestionnaireExecutionResponse)ApiInvoker.deserialize(response, "", AddQuestionnaireExecutionResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetQuestionnaireExecutionsResponse GetQuestionnaireCollectorExecutions(String userId, String collectorId) throws ApiException {
        if (userId == null || collectorId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/collectors/{collectorId}/executions".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{collectorId}", String.valueOf(collectorId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetQuestionnaireExecutionsResponse)ApiInvoker.deserialize(response, "", GetQuestionnaireExecutionsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetQuestionnaireExecutionsResponse GetQuestionnaireExecutions(String userId, String questionnaireId) throws ApiException {
        if (userId == null || questionnaireId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/{questionnaireId}/executions".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{questionnaireId}", String.valueOf(questionnaireId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetQuestionnaireExecutionsResponse)ApiInvoker.deserialize(response, "", GetQuestionnaireExecutionsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetQuestionnaireExecutionResponse GetQuestionnaireExecution(String userId, String executionId) throws ApiException {
        if (userId == null || executionId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/executions/{executionId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{executionId}", String.valueOf(executionId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetQuestionnaireExecutionResponse)ApiInvoker.deserialize(response, "", GetQuestionnaireExecutionResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DeleteQuestionnaireExecutionResponse DeleteQuestionnaireExecution(String userId, String executionId) throws ApiException {
        if (userId == null || executionId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/executions/{executionId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{executionId}", String.valueOf(executionId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (DeleteQuestionnaireExecutionResponse)ApiInvoker.deserialize(response, "", DeleteQuestionnaireExecutionResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UpdateQuestionnaireExecutionResponse UpdateQuestionnaireExecution(String userId, String executionId, QuestionnaireExecutionInfo body) throws ApiException {
        if (userId == null || executionId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/executions/{executionId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{executionId}", String.valueOf(executionId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (UpdateQuestionnaireExecutionResponse)ApiInvoker.deserialize(response, "", UpdateQuestionnaireExecutionResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UpdateQuestionnaireExecutionResponse UpdateQuestionnaireExecutionStatus(String userId, String executionId, String body) throws ApiException {
        if (userId == null || executionId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/executions/{executionId}/status".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{executionId}", String.valueOf(executionId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (UpdateQuestionnaireExecutionResponse)ApiInvoker.deserialize(response, "", UpdateQuestionnaireExecutionResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetQuestionnaireCollectorsResponse GetQuestionnaireCollectors(String userId, String questionnaireId) throws ApiException {
        if (userId == null || questionnaireId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/{questionnaireId}/collectors".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{questionnaireId}", String.valueOf(questionnaireId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetQuestionnaireCollectorsResponse)ApiInvoker.deserialize(response, "", GetQuestionnaireCollectorsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetQuestionnaireCollectorResponse GetQuestionnaireCollector(String userId, String collectorId) throws ApiException {
        if (userId == null || collectorId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/collectors/{collectorId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{collectorId}", String.valueOf(collectorId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetQuestionnaireCollectorResponse)ApiInvoker.deserialize(response, "", GetQuestionnaireCollectorResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public AddQuestionnaireCollectorResponse AddQuestionnaireCollector(String userId, String questionnaireId, QuestionnaireCollectorInfo body) throws ApiException {
        if (userId == null || questionnaireId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/{questionnaireId}/collectors".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{questionnaireId}", String.valueOf(questionnaireId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (AddQuestionnaireCollectorResponse)ApiInvoker.deserialize(response, "", AddQuestionnaireCollectorResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UpdateQuestionnaireCollectorResponse UpdateQuestionnaireCollector(String userId, String collectorId, QuestionnaireCollectorInfo body) throws ApiException {
        if (userId == null || collectorId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/collectors/{collectorId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{collectorId}", String.valueOf(collectorId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (UpdateQuestionnaireCollectorResponse)ApiInvoker.deserialize(response, "", UpdateQuestionnaireCollectorResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public DeleteQuestionnaireCollectorResponse DeleteQuestionnaireCollector(String userId, String collectorId) throws ApiException {
        if (userId == null || collectorId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/collectors/{collectorId}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{collectorId}", String.valueOf(collectorId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "DELETE", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (DeleteQuestionnaireCollectorResponse)ApiInvoker.deserialize(response, "", DeleteQuestionnaireCollectorResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetTemplatesResponse GetTemplates(String userId) throws ApiException {
        if (userId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/templates".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetTemplatesResponse)ApiInvoker.deserialize(response, "", GetTemplatesResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public TemplateFieldsResponse GetQuestionnaireFields(String userId, String questionnaireId, Boolean includeGeometry) throws ApiException {
        if (userId == null || questionnaireId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/{questionnaireId}/fields?include_geometry={includeGeometry}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{questionnaireId}", String.valueOf(questionnaireId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(includeGeometry))) {
            queryParams.put("include_geometry", String.valueOf(includeGeometry));
        }
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (TemplateFieldsResponse)ApiInvoker.deserialize(response, "", TemplateFieldsResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public GetQuestionnaireMetadataResponse GetQuestionnaireMetadata(String userId, String questionnaireId) throws ApiException {
        if (userId == null || questionnaireId == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/{questionnaireId}/metadata".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{questionnaireId}", String.valueOf(questionnaireId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, String.class);
            if (response != null) {
                return (GetQuestionnaireMetadataResponse)ApiInvoker.deserialize(response, "", GetQuestionnaireMetadataResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UpdateQuestionnaireResponse UpdateQuestionnaireMetadata(String userId, String questionnaireId, QuestionnaireMetadata body) throws ApiException {
        if (userId == null || questionnaireId == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/merge/{userId}/questionnaires/{questionnaireId}/metadata".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userId}", String.valueOf(userId)).replace("{questionnaireId}", String.valueOf(questionnaireId));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "PUT", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (UpdateQuestionnaireResponse)ApiInvoker.deserialize(response, "", UpdateQuestionnaireResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }
}

