/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.sdk.api;

import com.groupdocs.sdk.common.ApiException;
import com.groupdocs.sdk.common.ApiInvoker;
import com.groupdocs.sdk.common.FileStream;
import com.groupdocs.sdk.model.UserInfoResponse;
import java.util.HashMap;

public class SharedApi {
    String basePath = "https://api.groupdocs.com/v2.0";
    ApiInvoker apiInvoker = ApiInvoker.getInstance();

    public ApiInvoker getInvoker() {
        return this.apiInvoker;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public FileStream Download(String guid, String fileName, Boolean render) throws ApiException {
        if (guid == null || fileName == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/shared/files/{guid}?filename={fileName}&render={render}".replace("*", "");
        int pos = resourcePath.indexOf("?");
        if (pos > -1) {
            resourcePath = resourcePath.substring(0, pos);
        }
        resourcePath = resourcePath.replace("{format}", "json").replace("{guid}", String.valueOf(guid));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        if (!"null".equals(String.valueOf(fileName))) {
            queryParams.put("filename", String.valueOf(fileName));
        }
        if (!"null".equals(String.valueOf(render))) {
            queryParams.put("render", String.valueOf(render));
        }
        try {
            return this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, FileStream.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public FileStream GetXml(String guid) throws ApiException {
        if (guid == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/shared/files/{guid}/xml".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{guid}", String.valueOf(guid));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            return this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, FileStream.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public FileStream GetHtml(String guid) throws ApiException {
        if (guid == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/shared/files/{guid}/html".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{guid}", String.valueOf(guid));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            return this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, FileStream.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public FileStream GetPackage(String path) throws ApiException {
        if (path == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/shared/packages/{*path}".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{path}", String.valueOf(path));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            return this.apiInvoker.invokeAPI(this.basePath, resourcePath, "GET", queryParams, null, headerParams, FileStream.class);
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }

    public UserInfoResponse LoginUser(String userName, String body) throws ApiException {
        if (userName == null || body == null) {
            throw new ApiException(400, "missing required params");
        }
        String resourcePath = "/shared/users/{userName}/logins".replace("*", "");
        resourcePath = resourcePath.replace("{format}", "json").replace("{userName}", String.valueOf(userName));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        try {
            String response = this.apiInvoker.invokeAPI(this.basePath, resourcePath, "POST", queryParams, body, headerParams, String.class);
            if (response != null) {
                return (UserInfoResponse)ApiInvoker.deserialize(response, "", UserInfoResponse.class);
            }
            return null;
        }
        catch (ApiException ex) {
            if (ex.getCode() == 404) {
                return null;
            }
            throw ex;
        }
    }
}

