/*
 * Decompiled with CFR 0.152.
 */
package com.groupdocs.sdk.common;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.core.header.ContentDisposition;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import javax.ws.rs.core.MultivaluedMap;

public class FileStream {
    private InputStream inputStream;
    private String contentType;
    private String fileName;
    private long size = -1L;

    public FileStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public FileStream(String requestUri, ClientResponse response) {
        this.inputStream = response.getEntityInputStream();
        if (response.getType() != null) {
            this.contentType = response.getType().toString();
        }
        MultivaluedMap headers = response.getHeaders();
        try {
            ContentDisposition cd = new ContentDisposition((String)headers.getFirst((Object)"Content-Disposition"));
            this.fileName = cd.getFileName() == null ? this.getFileNameFromUrl(requestUri) : cd.getFileName();
            this.size = cd.getSize() == 0L ? (long)response.getLength() : cd.getSize();
        }
        catch (ParseException e) {
            // empty catch block
        }
    }

    private String getFileNameFromUrl(String requestUri) {
        try {
            URL url = new URL(requestUri);
            String path = url.getPath();
            return path.substring(path.lastIndexOf(47) + 1);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
}

