/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.support.okhttp3;

import com.hb0730.https.config.HttpConfig;
import com.hb0730.https.exception.HttpException;
import com.hb0730.https.inter.AbstractSyncHttp;
import com.hb0730.https.support.okhttp3.IOkhttp3;
import com.hb0730.https.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OkHttp3SyncImpl
extends AbstractSyncHttp
implements IOkhttp3 {
    private final OkHttpClient.Builder clientBuilder;

    public OkHttp3SyncImpl() {
        this(new HttpConfig());
    }

    public OkHttp3SyncImpl(HttpConfig config) {
        this(new OkHttpClient().newBuilder(), config);
    }

    public OkHttp3SyncImpl(OkHttpClient.Builder clientBuilder, HttpConfig config) {
        super(config);
        this.clientBuilder = clientBuilder;
    }

    @Override
    public String get(String url) {
        return this.get(url, null);
    }

    @Override
    public String get(String url, Map<String, String> params) {
        if (StringUtils.isEmpty(url)) {
            return "";
        }
        Request.Builder builder = this.getRequestBuilder(url, params, this.httpConfig.isEncode(), this.header == null ? null : this.header.getHeaders());
        return this.execStr(builder);
    }

    @Override
    public String post(String url) {
        return this.post(url, "");
    }

    @Override
    public String post(String url, String data) {
        if (StringUtils.isEmpty(url)) {
            return "";
        }
        Request.Builder requestBuilder = this.postJsonRequestBuild(url, data, StringUtils.isBlank(this.httpConfig.getContentType()) ? JSON_UTF_8 : MediaType.parse((String)this.httpConfig.getContentType()), this.header == null ? null : this.header.getHeaders());
        return this.execStr(requestBuilder);
    }

    @Override
    public InputStream postStream(String url, String dataJson) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        Request.Builder requestBuilder = this.postJsonRequestBuild(url, dataJson, StringUtils.isBlank(this.httpConfig.getContentType()) ? JSON_UTF_8 : MediaType.parse((String)this.httpConfig.getContentType()), this.header == null ? null : this.header.getHeaders());
        return this.execStream(requestBuilder);
    }

    @Override
    public String post(String url, Map<String, String> formdata) {
        if (StringUtils.isBlank(url)) {
            return "";
        }
        Request.Builder requestBuilder = this.postFormDataRequestBuild(url, formdata, this.httpConfig.isEncode(), StringUtils.isBlank(this.httpConfig.getContentType()) ? FORM_DATA_UTF_8 : MediaType.parse((String)this.httpConfig.getContentType()), null == this.header ? null : this.header.getHeaders());
        return this.execStr(requestBuilder);
    }

    public String execStr(Request.Builder requestBuilder) {
        String result = "";
        if (null == requestBuilder) {
            return result;
        }
        Request request = requestBuilder.build();
        OkHttpClient httpClient = this.buildClient(this.clientBuilder, this.httpConfig);
        try (Response response = httpClient.newCall(request).execute();){
            if (response.isSuccessful()) {
                result = Objects.requireNonNull(response.body()).string();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HttpException("http execute error:" + e.getMessage(), e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream execStream(Request.Builder requestBuilder) {
        if (null == requestBuilder) {
            return null;
        }
        Request request = requestBuilder.build();
        OkHttpClient httpClient = this.buildClient(this.clientBuilder, this.httpConfig);
        try (Response response = httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) return null;
            InputStream inputStream = Objects.requireNonNull(response.body()).byteStream();
            return inputStream;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HttpException("http execute error:" + e.getMessage(), e);
        }
    }
}

