/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.utils;

import com.hb0730.https.utils.CollectionUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.function.BiConsumer;

public final class MapUtils {
    public static String parseMapToUrlString(Map<String, String> params, boolean encode) {
        if (CollectionUtils.isEmpty(params)) {
            return "";
        }
        ArrayList paramsList = new ArrayList();
        MapUtils.forEach(params, (k, v) -> {
            if (null == v) {
                paramsList.add(k + "=");
            } else {
                try {
                    paramsList.add(k + "=" + (encode ? URLEncoder.encode(v, StandardCharsets.UTF_8.displayName()) : v));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        });
        return String.join((CharSequence)"&", paramsList);
    }

    public static <K, V> void forEach(Map<K, V> map, BiConsumer<? super K, ? super V> action) {
        if (CollectionUtils.isEmpty(map) || action == null) {
            return;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V v;
            K k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
            action.accept(k, v);
        }
    }

    private MapUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

