/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.support.httpclient;

import com.hb0730.https.config.HttpConfig;
import com.hb0730.https.exception.HttpException;
import com.hb0730.https.inter.AbstractAsyncHttp;
import com.hb0730.https.support.callback.HttpCallback;
import com.hb0730.https.utils.CollectionUtils;
import com.hb0730.https.utils.MapUtils;
import com.hb0730.https.utils.StringUtils;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Message;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.nio.AsyncEntityConsumer;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.entity.StringAsyncEntityConsumer;
import org.apache.hc.core5.http.nio.support.BasicResponseConsumer;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.net.WWWFormCodec;

public class HttpClientAsyncImpl
extends AbstractAsyncHttp {
    private final CloseableHttpAsyncClient httpClient;

    public HttpClientAsyncImpl() {
        this(HttpAsyncClients.createDefault(), new HttpConfig());
    }

    public HttpClientAsyncImpl(HttpConfig config) {
        this(HttpAsyncClients.createDefault(), config);
    }

    public HttpClientAsyncImpl(CloseableHttpAsyncClient httpClient, HttpConfig config) {
        super(config);
        this.httpClient = httpClient;
    }

    @Override
    public void get(String url, HttpCallback httpCallback) {
        this.get(url, null, httpCallback);
    }

    @Override
    public void get(String url, Map<String, String> params, HttpCallback httpCallback) {
        URI uri;
        URIBuilder builder;
        if (StringUtils.isBlank(url)) {
            throw new HttpException("url missing");
        }
        try {
            builder = new URIBuilder(url);
            if (!CollectionUtils.isEmpty(params)) {
                ArrayList query = new ArrayList(params.size());
                params.forEach((k, v) -> query.add(new BasicNameValuePair(k, v)));
                if (this.httpConfig.isEncode()) {
                    String queryParams = WWWFormCodec.format(query, (Charset)this.getCharSet());
                    builder.setCustomQuery(queryParams);
                } else {
                    builder.addParameters(query);
                }
            }
            builder.setCharset(this.getCharSet());
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            throw new HttpException(e);
        }
        builder = SimpleRequestBuilder.get((URI)uri);
        builder.setRequestConfig(this.buildConfig());
        SimpleHttpRequest httpRequest = builder.build();
        this.addHeader((HttpRequest)httpRequest);
        SimpleRequestProducer producer = SimpleRequestProducer.create((SimpleHttpRequest)httpRequest);
        this.exec((AsyncRequestProducer)producer, httpCallback);
    }

    @Override
    public void post(String url, HttpCallback httpCallback) {
        this.post(url, "", httpCallback);
    }

    @Override
    public void post(String url, String dataJson, HttpCallback httpCallback) {
        if (StringUtils.isBlank(url)) {
            throw new HttpException("url missing");
        }
        SimpleRequestBuilder builder = SimpleRequestBuilder.post((String)url);
        builder.setBody(dataJson, this.getContentType());
        builder.setRequestConfig(this.buildConfig());
        builder.setCharset(this.httpConfig.getCharset());
        SimpleHttpRequest httpRequest = builder.build();
        this.addHeader((HttpRequest)httpRequest);
        SimpleRequestProducer producer = SimpleRequestProducer.create((SimpleHttpRequest)httpRequest);
        this.exec((AsyncRequestProducer)producer, httpCallback);
    }

    @Override
    public void post(String url, Map<String, String> formdata, HttpCallback httpCallback) {
        if (StringUtils.isBlank(url)) {
            throw new HttpException("url missing");
        }
        SimpleRequestBuilder builder = SimpleRequestBuilder.post((String)url);
        builder.setCharset(this.httpConfig.getCharset());
        if (!CollectionUtils.isEmpty(formdata)) {
            formdata.forEach((arg_0, arg_1) -> ((SimpleRequestBuilder)builder).addParameter(arg_0, arg_1));
        }
        SimpleHttpRequest httpRequest = builder.build();
        SimpleRequestProducer producer = SimpleRequestProducer.create((SimpleHttpRequest)httpRequest);
        this.exec((AsyncRequestProducer)producer, httpCallback);
    }

    private void exec(AsyncRequestProducer producer, final HttpCallback httpCallback) {
        this.httpClient.start();
        CharCodingConfig config = CharCodingConfig.custom().setCharset(this.getCharSet()).build();
        StringAsyncEntityConsumer stringConsumer = new StringAsyncEntityConsumer(config);
        BasicResponseConsumer responseConsumer = new BasicResponseConsumer((AsyncEntityConsumer)stringConsumer);
        this.httpClient.execute(producer, (AsyncResponseConsumer)responseConsumer, (FutureCallback)new FutureCallback<Message<HttpResponse, String>>(){

            public void completed(Message<HttpResponse, String> result) {
                if (null == httpCallback) {
                    return;
                }
                HttpResponse head = (HttpResponse)result.getHead();
                if (head.getCode() >= 200 && head.getCode() < 300) {
                    httpCallback.success((String)result.getBody());
                } else {
                    httpCallback.failure(new HttpException("Unexpected response status: " + head.getCode()));
                }
            }

            public void failed(Exception ex) {
                if (null == httpCallback) {
                    return;
                }
                httpCallback.failure(ex);
            }

            public void cancelled() {
            }
        });
    }

    private RequestConfig buildConfig() {
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(this.httpConfig.getTimeout(), TimeUnit.MILLISECONDS).setConnectTimeout(this.httpConfig.getTimeout(), TimeUnit.MILLISECONDS);
        if (null != this.httpConfig.getProxy()) {
            Proxy proxy = this.httpConfig.getProxy();
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            HttpHost httpHost = new HttpHost(proxy.type().name().toLowerCase(), address.getHostName(), address.getPort());
            builder.setProxy(httpHost);
        }
        return builder.build();
    }

    private void addHeader(HttpRequest request) {
        if (null != this.getHeader()) {
            Map<String, String> headers = this.getHeader().getHeaders();
            MapUtils.forEach(headers, (arg_0, arg_1) -> ((HttpRequest)request).addHeader(arg_0, arg_1));
        }
    }

    private Charset getCharSet() {
        return this.httpConfig.getCharset() == null ? StandardCharsets.UTF_8 : this.httpConfig.getCharset();
    }

    private ContentType getContentType() {
        String contentType = this.getHttpConfig().getContentType();
        if (StringUtils.isBlank(contentType)) {
            return ContentType.TEXT_PLAIN;
        }
        return ContentType.parse((CharSequence)contentType);
    }

    public CloseableHttpAsyncClient getHttpClient() {
        return this.httpClient;
    }
}

