/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.support.httpclient;

import com.hb0730.https.HttpHeader;
import com.hb0730.https.config.HttpConfig;
import com.hb0730.https.exception.HttpException;
import com.hb0730.https.inter.AbstractSyncHttp;
import com.hb0730.https.utils.CollectionUtils;
import com.hb0730.https.utils.MapUtils;
import com.hb0730.https.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpClientSyncImpl
extends AbstractSyncHttp {
    private final CloseableHttpClient httpClient;

    public HttpClientSyncImpl() {
        this(HttpConfig.builder().build(), HttpClients.createDefault());
    }

    public HttpClientSyncImpl(CloseableHttpClient httpClient) {
        super(HttpConfig.builder().build());
        this.httpClient = httpClient;
    }

    public HttpClientSyncImpl(HttpConfig httpConfig, CloseableHttpClient httpClient) {
        super(httpConfig);
        this.httpClient = httpClient;
    }

    @Override
    public String get(String url) {
        return this.get(url, null);
    }

    @Override
    public String get(String url, Map<String, String> params) {
        URI uri;
        URIBuilder builder;
        if (StringUtils.isEmpty(url)) {
            return "";
        }
        try {
            builder = new URIBuilder(url);
            if (!CollectionUtils.isEmpty(params)) {
                ArrayList query = new ArrayList(params.size());
                params.forEach((k, v) -> query.add(new BasicNameValuePair(k, v)));
                if (this.httpConfig.isEncode()) {
                    String queryParams = URLEncodedUtils.format(query, (Charset)this.getCharSet());
                    builder.setCustomQuery(queryParams);
                } else {
                    builder.addParameters(query);
                }
            }
            builder.setCharset(this.httpConfig.getCharset());
            uri = builder.build();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            throw new HttpException(e);
        }
        builder = RequestBuilder.get((URI)uri);
        builder.setCharset(this.getCharSet());
        builder.setConfig(this.buildConfig());
        HttpUriRequest request = builder.build();
        this.addHeader((HttpRequest)request);
        return this.execStr(request);
    }

    @Override
    public String post(String url) {
        return this.post(url, "");
    }

    @Override
    public String post(String url, String dataJson) {
        if (StringUtils.isEmpty(url)) {
            return "";
        }
        RequestBuilder builder = RequestBuilder.post((String)url);
        if (!StringUtils.isBlank(dataJson)) {
            StringEntity entity = new StringEntity(dataJson, this.getContentType());
            builder.setEntity((HttpEntity)entity);
        }
        builder.setConfig(this.buildConfig());
        builder.setCharset(this.getCharSet());
        HttpUriRequest uriRequest = builder.build();
        this.addHeader((HttpRequest)uriRequest);
        return this.execStr(uriRequest);
    }

    @Override
    public String post(String url, String dataJson, HttpHeader header) {
        if (StringUtils.isEmpty(url)) {
            return "";
        }
        RequestBuilder builder = RequestBuilder.post((String)url);
        if (!StringUtils.isBlank(dataJson)) {
            StringEntity entity = new StringEntity(dataJson, this.getContentType());
            builder.setEntity((HttpEntity)entity);
        }
        builder.setConfig(this.buildConfig());
        builder.setCharset(this.getCharSet());
        HttpUriRequest uriRequest = builder.build();
        this.addHeader((HttpRequest)uriRequest);
        this.addHeader((HttpRequest)uriRequest, header);
        return this.execStr(uriRequest);
    }

    @Override
    public InputStream postStream(String url, String dataJson) {
        if (StringUtils.isEmpty(url)) {
            return null;
        }
        RequestBuilder builder = RequestBuilder.post((String)url);
        if (!StringUtils.isBlank(dataJson)) {
            StringEntity entity = new StringEntity(dataJson, this.getContentType());
            builder.setEntity((HttpEntity)entity);
        }
        builder.setConfig(this.buildConfig());
        builder.setCharset(this.getCharSet());
        HttpUriRequest uriRequest = builder.build();
        this.addHeader((HttpRequest)uriRequest);
        return this.execStream(uriRequest);
    }

    @Override
    public String post(String url, Map<String, String> formdata) {
        if (StringUtils.isEmpty(url)) {
            return "";
        }
        RequestBuilder builder = RequestBuilder.post((String)url);
        if (!CollectionUtils.isEmpty(formdata)) {
            ArrayList form = new ArrayList(formdata.size());
            MapUtils.forEach(formdata, (k, v) -> form.add(new BasicNameValuePair(v, k)));
            builder.setEntity((HttpEntity)new UrlEncodedFormEntity(form, this.getCharSet()));
        }
        builder.setCharset(this.getCharSet());
        builder.setConfig(this.buildConfig());
        builder.setCharset(this.getCharSet());
        HttpUriRequest uriRequest = builder.build();
        this.addHeader((HttpRequest)uriRequest);
        return this.execStr(uriRequest);
    }

    private boolean isSuccess(CloseableHttpResponse response) {
        if (response == null) {
            return false;
        }
        if (response.getStatusLine() == null) {
            return false;
        }
        return response.getStatusLine().getStatusCode() >= 200 && response.getStatusLine().getStatusCode() < 300;
    }

    private void addHeader(HttpRequest request, HttpHeader header) {
        if (null == request || null == header) {
            return;
        }
        Map<String, String> headers = header.getHeaders();
        if (CollectionUtils.isEmpty(headers)) {
            return;
        }
        MapUtils.forEach(headers, (arg_0, arg_1) -> ((HttpRequest)request).addHeader(arg_0, arg_1));
    }

    private void addHeader(HttpRequest request) {
        this.addHeader(request, this.getHeader());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String execStr(HttpUriRequest request) {
        String result = "";
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            if (!this.isSuccess(response)) {
                String string = null;
                return string;
            }
            HttpEntity entity = response.getEntity();
            if (null == entity) return result;
            result = EntityUtils.toString((HttpEntity)entity, (Charset)this.getCharSet());
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HttpException("request result error:" + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream execStream(HttpUriRequest request) {
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            if (!this.isSuccess(response)) {
                InputStream inputStream = null;
                return inputStream;
            }
            HttpEntity entity = response.getEntity();
            if (null == entity) return null;
            InputStream inputStream = entity.getContent();
            return inputStream;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new HttpException("request result error:" + e.getMessage());
        }
    }

    private RequestConfig buildConfig() {
        int timeout = this.httpConfig.getTimeout() > Integer.MAX_VALUE ? Integer.MAX_VALUE : Long.valueOf(this.httpConfig.getTimeout()).intValue();
        RequestConfig.Builder builder = RequestConfig.custom().setConnectionRequestTimeout(timeout).setConnectTimeout(timeout).setSocketTimeout(timeout);
        if (null != this.httpConfig.getProxy()) {
            Proxy proxy = this.httpConfig.getProxy();
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            HttpHost host = new HttpHost(address.getHostName(), address.getPort(), proxy.type().name().toLowerCase());
            builder.setProxy(host);
        }
        return builder.build();
    }

    private Charset getCharSet() {
        return this.httpConfig.getCharset() == null ? StandardCharsets.UTF_8 : this.httpConfig.getCharset();
    }

    private ContentType getContentType() {
        String contentType = this.httpConfig.getContentType();
        if (StringUtils.isBlank(contentType)) {
            return ContentType.TEXT_PLAIN;
        }
        return ContentType.parse((String)contentType);
    }
}

