/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.support.okhttp3;

import com.hb0730.https.config.HttpConfig;
import com.hb0730.https.exception.HttpException;
import com.hb0730.https.utils.MapUtils;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public interface IOkhttp3 {
    public static final MediaType JSON_UTF_8 = MediaType.parse((String)"application/json; charset=utf-8");
    public static final MediaType FORM_DATA_UTF_8 = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");

    default public Request.Builder getRequestBuilder(String url, Map<String, String> params, boolean urlEnabled, Map<String, String> header) {
        HttpUrl httpUrl = this.buildHttpUrl(url, params, urlEnabled);
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl);
        if (null != header) {
            MapUtils.forEach(header, (arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        return requestBuilder.get();
    }

    default public Request.Builder postJsonRequestBuild(String url, String dataJson, MediaType contentType, Map<String, String> header) {
        HttpUrl httpUrl = this.buildHttpUrl(url, null, true);
        Request.Builder builder = new Request.Builder().url(httpUrl);
        if (null != header) {
            MapUtils.forEach(header, (arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        builder.addHeader("Content-Type", contentType.toString());
        RequestBody body = RequestBody.create((String)dataJson, (MediaType)contentType);
        return builder.post(body);
    }

    default public Request.Builder postFormDataRequestBuild(String url, Map<String, String> formdata, boolean encode, MediaType contentType, Map<String, String> headers) {
        HttpUrl httpUrl = this.buildHttpUrl(url, null, true);
        Request.Builder builder = new Request.Builder().url(httpUrl);
        if (null != headers) {
            MapUtils.forEach(headers, (arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        builder.addHeader("Content-Type", contentType.toString());
        FormBody.Builder formBuild = new FormBody.Builder(contentType.charset());
        if (encode) {
            MapUtils.forEach(formdata, (arg_0, arg_1) -> ((FormBody.Builder)formBuild).addEncoded(arg_0, arg_1));
        } else {
            MapUtils.forEach(formdata, (arg_0, arg_1) -> ((FormBody.Builder)formBuild).add(arg_0, arg_1));
        }
        FormBody formBody = formBuild.build();
        return builder.post((RequestBody)formBody);
    }

    default public HttpUrl buildHttpUrl(String url, Map<String, String> params, boolean urlEnabled) {
        HttpUrl parse = HttpUrl.parse((String)url);
        if (null == parse) {
            throw new HttpException("url missing");
        }
        HttpUrl.Builder builder = parse.newBuilder();
        if (urlEnabled) {
            MapUtils.forEach(params, (arg_0, arg_1) -> ((HttpUrl.Builder)builder).addEncodedQueryParameter(arg_0, arg_1));
        } else {
            MapUtils.forEach(params, (arg_0, arg_1) -> ((HttpUrl.Builder)builder).addQueryParameter(arg_0, arg_1));
        }
        return builder.build();
    }

    default public OkHttpClient buildClient(OkHttpClient.Builder clientBuilder, HttpConfig config) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (clientBuilder != null) {
            builder = clientBuilder;
        }
        builder.connectTimeout(config.getTimeout(), TimeUnit.MILLISECONDS);
        builder.proxy(config.getProxy());
        builder.readTimeout(config.getTimeout(), TimeUnit.MILLISECONDS);
        builder.writeTimeout(config.getTimeout(), TimeUnit.MILLISECONDS);
        return builder.build();
    }
}

