/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.support.hutool;

import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.http.HttpException;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.Method;
import com.hb0730.https.HttpHeader;
import com.hb0730.https.config.HttpConfig;
import com.hb0730.https.inter.AbstractSyncHttp;
import com.hb0730.https.support.SimpleHttpResponse;
import com.hb0730.https.support.hutool.IHutoolHttp;
import com.hb0730.https.utils.StringUtils;
import java.util.Map;

public class HutoolSyncImpl
extends AbstractSyncHttp
implements IHutoolHttp {
    public HutoolSyncImpl() {
        this(HttpConfig.builder().build());
    }

    public HutoolSyncImpl(HttpConfig httpConfig) {
        super(httpConfig);
    }

    @Override
    public SimpleHttpResponse get(String url) {
        return this.get(url, null);
    }

    @Override
    public SimpleHttpResponse get(String url, Map<String, String> params) {
        if (StringUtils.isEmpty(url)) {
            throw new HttpException("url missing");
        }
        UrlBuilder builder = this.urlBuilder(url, params, this.httpConfig.getCharset(), this.httpConfig.isEncode());
        HttpRequest request = this.getRequest(builder, Method.GET);
        return this.exec(request);
    }

    @Override
    public SimpleHttpResponse post(String url) {
        return this.post(url, (String)null);
    }

    @Override
    public SimpleHttpResponse post(String url, String dataJson) {
        return this.post(url, dataJson, null);
    }

    @Override
    public SimpleHttpResponse post(String url, String dataJson, HttpHeader header) {
        if (StringUtils.isEmpty(url)) {
            throw new HttpException("url missing");
        }
        UrlBuilder builder = this.urlBuilder(url, null, this.httpConfig.getCharset(), this.httpConfig.isEncode());
        HttpRequest request = this.getRequest(builder, Method.POST);
        if (null != header) {
            request.addHeaders(header.getHeaders());
        }
        request.body(dataJson, this.getContentType("application/json; charset=utf-8"));
        return this.exec(request);
    }

    @Override
    public SimpleHttpResponse post(String url, Map<String, String> formdata) {
        return this.post(url, formdata, null);
    }

    @Override
    public SimpleHttpResponse post(String url, Map<String, String> formData, HttpHeader header) {
        if (StringUtils.isEmpty(url)) {
            throw new HttpException("url missing");
        }
        UrlBuilder builder = this.urlBuilder(url, null, this.httpConfig.getCharset(), this.httpConfig.isEncode());
        HttpRequest request = this.getRequest(builder, Method.POST);
        request.formStr(formData);
        request.contentType(this.getContentType("application/x-www-form-urlencoded; charset=utf-8"));
        if (null != header) {
            request.addHeaders(header.getHeaders());
        }
        return this.exec(request);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SimpleHttpResponse exec(HttpRequest request) {
        try (HttpResponse response = request.execute();){
            SimpleHttpResponse simpleHttpResponse = SimpleHttpResponse.builder().success(response.isOk()).body(response.bodyBytes()).headers(response.headers()).build();
            return simpleHttpResponse;
        }
        catch (Exception e) {
            throw new com.hb0730.https.exception.HttpException("request error:" + e.getMessage());
        }
    }

    private HttpRequest getRequest(UrlBuilder url, Method method) {
        return this.getHttpRequest(url, method, this.getHttpConfig() == null ? HttpConfig.builder().build() : this.getHttpConfig(), this.getHeader());
    }

    private String getContentType(String defaultContentType) {
        if (StringUtils.isBlank(this.httpConfig.getContentType())) {
            return defaultContentType;
        }
        return this.httpConfig.getContentType();
    }
}

