/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.support.okhttp3;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.ArrayUtil;
import com.hb0730.https.config.HttpConfig;
import com.hb0730.https.exception.HttpException;
import com.hb0730.https.utils.MapUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public interface IOkhttp3 {
    public static final MediaType JSON_UTF_8 = MediaType.parse((String)"application/json; charset=utf-8");
    public static final MediaType FORM_DATA_UTF_8 = MediaType.parse((String)"application/x-www-form-urlencoded; charset=utf-8");

    default public Request.Builder getRequestBuilder(String url, Map<String, String> params, boolean urlEnabled, Map<String, String> header) {
        HttpUrl httpUrl = this.buildHttpUrl(url, params, urlEnabled);
        Request.Builder requestBuilder = new Request.Builder().url(httpUrl);
        if (null != header) {
            MapUtils.forEach(header, (arg_0, arg_1) -> ((Request.Builder)requestBuilder).addHeader(arg_0, arg_1));
        }
        return requestBuilder.get();
    }

    default public Request.Builder postJsonRequestBuild(String url, String dataJson, MediaType contentType, Map<String, String> header) {
        HttpUrl httpUrl = this.buildHttpUrl(url, null, true);
        Request.Builder builder = new Request.Builder().url(httpUrl);
        if (null != header) {
            MapUtils.forEach(header, (arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        builder.addHeader("Content-Type", contentType.toString());
        RequestBody body = RequestBody.create((String)dataJson, (MediaType)contentType);
        return builder.post(body);
    }

    default public Request.Builder postFormDataRequestBuild(String url, Map<String, String> formdata, boolean encode, MediaType contentType, Map<String, String> headers) {
        HttpUrl httpUrl = this.buildHttpUrl(url, null, true);
        Request.Builder builder = new Request.Builder().url(httpUrl);
        if (null != headers) {
            MapUtils.forEach(headers, (arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        builder.addHeader("Content-Type", contentType.toString());
        FormBody.Builder formBuild = new FormBody.Builder(contentType.charset());
        if (encode) {
            MapUtils.forEach(formdata, (arg_0, arg_1) -> ((FormBody.Builder)formBuild).addEncoded(arg_0, arg_1));
        } else {
            MapUtils.forEach(formdata, (arg_0, arg_1) -> ((FormBody.Builder)formBuild).add(arg_0, arg_1));
        }
        FormBody formBody = formBuild.build();
        return builder.post((RequestBody)formBody);
    }

    default public Request.Builder postFormFileRequestBuild(String url, Map<String, Object> formdata, Map<String, String> headers) {
        HttpUrl httpUrl = this.buildHttpUrl(url, null, true);
        Request.Builder builder = new Request.Builder().url(httpUrl);
        if (null != headers) {
            MapUtils.forEach(headers, (arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        builder.addHeader("Content-Type", "multipart/form-data");
        MultipartBody.Builder multipartBody = new MultipartBody.Builder();
        multipartBody.setType(MultipartBody.FORM);
        for (Map.Entry<String, Object> entry : formdata.entrySet()) {
            String strValue;
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof File) {
                multipartBody.addFormDataPart(name, ((File)value).getName(), RequestBody.create((File)((File)value), (MediaType)MediaType.parse((String)FileUtil.getMimeType((Path)((File)value).toPath()))));
                continue;
            }
            if (value instanceof Iterable) {
                strValue = CollUtil.join((Iterable)((Iterable)value), (CharSequence)",");
            } else if (ArrayUtil.isArray((Object)value)) {
                if (File.class == ArrayUtil.getComponentType((Object)value)) {
                    File[] files = (File[])value;
                    for (int i = 0; i < files.length; ++i) {
                        MultipartBody.Part part = MultipartBody.Part.createFormData((String)(name + i), (String)files[i].getName(), (RequestBody)RequestBody.create((File)files[i], (MediaType)MediaType.parse((String)FileUtil.getMimeType((String)files[i].getName()))));
                        multipartBody.addPart(part);
                    }
                    continue;
                }
                strValue = ArrayUtil.join((Object[])((Object[])value), (CharSequence)",");
            } else {
                strValue = Convert.toStr((Object)value, null);
            }
            multipartBody.addFormDataPart(name, strValue);
        }
        MultipartBody body = multipartBody.build();
        return builder.post((RequestBody)body);
    }

    default public HttpUrl buildHttpUrl(String url, Map<String, String> params, boolean urlEnabled) {
        HttpUrl parse = HttpUrl.parse((String)url);
        if (null == parse) {
            throw new HttpException("url missing");
        }
        HttpUrl.Builder builder = parse.newBuilder();
        if (urlEnabled) {
            MapUtils.forEach(params, (arg_0, arg_1) -> ((HttpUrl.Builder)builder).addEncodedQueryParameter(arg_0, arg_1));
        } else {
            MapUtils.forEach(params, (arg_0, arg_1) -> ((HttpUrl.Builder)builder).addQueryParameter(arg_0, arg_1));
        }
        return builder.build();
    }

    default public OkHttpClient buildClient(OkHttpClient.Builder clientBuilder, HttpConfig config) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (clientBuilder != null) {
            builder = clientBuilder;
        }
        builder.connectTimeout(config.getTimeout(), TimeUnit.MILLISECONDS);
        builder.proxy(config.getProxy());
        builder.readTimeout(config.getTimeout(), TimeUnit.MILLISECONDS);
        builder.writeTimeout(config.getTimeout(), TimeUnit.MILLISECONDS);
        return builder.build();
    }
}

