/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https;

import com.hb0730.https.HttpHeader;
import com.hb0730.https.config.HttpConfig;
import com.hb0730.https.exception.HttpException;
import com.hb0730.https.support.AbstractSimpleHttp;
import com.hb0730.https.support.SimpleHttpResponse;
import com.hb0730.https.support.httpclient.HttpClientImpl;
import com.hb0730.https.support.hutool.HutoolImpl;
import com.hb0730.https.support.okhttp3.OkHttp3Impl;
import com.hb0730.https.utils.ClassUtils;
import java.io.File;
import java.util.Map;

public class SimpleHttp
implements com.hb0730.https.support.SimpleHttp {
    public static final SimpleHttp HTTP = new SimpleHttp();
    private static AbstractSimpleHttp proxy;

    private void selectHttpProxy() {
        AbstractSimpleHttp defaultProxy = null;
        ClassLoader classLoader = SimpleHttp.class.getClassLoader();
        if (ClassUtils.isPresent("org.apache.http.impl.client.HttpClients", classLoader)) {
            defaultProxy = this.getHttpProxy(HttpClientImpl.class);
        }
        if (ClassUtils.isPresent("okhttp3.OkHttpClient", classLoader)) {
            defaultProxy = this.getHttpProxy(OkHttp3Impl.class);
        }
        if (ClassUtils.isPresent("cn.hutool.http.HttpRequest", classLoader)) {
            defaultProxy = this.getHttpProxy(HutoolImpl.class);
        }
        if (defaultProxy == null) {
            throw new HttpException("Has no HttpImpl defined in environment!");
        }
        proxy = defaultProxy;
    }

    private <T extends AbstractSimpleHttp> AbstractSimpleHttp getHttpProxy(Class<T> clazz) {
        try {
            return (AbstractSimpleHttp)clazz.newInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }

    private synchronized void checkHttpNotNull(com.hb0730.https.support.SimpleHttp proxy) {
        if (null == proxy) {
            this.selectHttpProxy();
        }
    }

    public SimpleHttp setHttp(AbstractSimpleHttp http) {
        proxy = http;
        return this;
    }

    public SimpleHttp setHttpConfig(HttpConfig config) {
        this.checkHttpNotNull(proxy);
        if (null == config) {
            config = HttpConfig.builder().timeout(3000L).build();
        }
        proxy.setHttpConfig(config);
        return this;
    }

    public SimpleHttp setHeader(HttpHeader header) {
        this.checkHttpNotNull(proxy);
        proxy.setHeader(header);
        return this;
    }

    @Override
    public SimpleHttpResponse get(String url) {
        this.checkHttpNotNull(proxy);
        return proxy.get(url);
    }

    @Override
    public SimpleHttpResponse get(String url, Map<String, String> params) {
        this.checkHttpNotNull(proxy);
        return proxy.get(url, params);
    }

    @Override
    public SimpleHttpResponse post(String url) {
        this.checkHttpNotNull(proxy);
        return proxy.post(url);
    }

    @Override
    public SimpleHttpResponse post(String url, String data) {
        this.checkHttpNotNull(proxy);
        return proxy.post(url, data);
    }

    @Override
    public SimpleHttpResponse post(String url, String dataJson, HttpHeader header) {
        this.checkHttpNotNull(proxy);
        return proxy.post(url, dataJson, header);
    }

    @Override
    public SimpleHttpResponse postFormStr(String url, Map<String, String> params) {
        this.checkHttpNotNull(proxy);
        return proxy.postFormStr(url, params);
    }

    @Override
    public SimpleHttpResponse postFormStr(String url, Map<String, String> formData, HttpHeader header) {
        this.checkHttpNotNull(proxy);
        return proxy.postFormStr(url, formData, header);
    }

    @Override
    public SimpleHttpResponse postFile(String url, String name, String filename, byte[] fileBytes) {
        this.checkHttpNotNull(proxy);
        return proxy.postFile(url, name, filename, fileBytes);
    }

    @Override
    public SimpleHttpResponse postFile(String url, String name, File file) {
        this.checkHttpNotNull(proxy);
        return proxy.postFile(url, name, file);
    }

    @Override
    public SimpleHttpResponse postFormFile(String url, Map<String, Object> formData) {
        this.checkHttpNotNull(proxy);
        return proxy.postFormFile(url, formData);
    }

    @Override
    public SimpleHttpResponse postFormFile(String url, Map<String, Object> formData, HttpHeader header) {
        this.checkHttpNotNull(proxy);
        return proxy.postFormFile(url, formData, header);
    }
}

