/*
 * Decompiled with CFR 0.152.
 */
package com.hb0730.https.support.hutool;

import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.Method;
import com.hb0730.https.HttpHeader;
import com.hb0730.https.config.HttpConfig;
import java.nio.charset.Charset;
import java.util.Map;

public interface IHutoolHttp {
    default public UrlBuilder urlBuilder(String url, Map<String, String> queryParams, Charset charset, boolean isEnabled) {
        UrlQuery query = UrlQuery.of(queryParams, (boolean)isEnabled);
        UrlBuilder builder = UrlBuilder.of((String)url, (Charset)charset);
        UrlQuery urlQuery = builder.getQuery();
        query.addAll(urlQuery.getQueryMap());
        builder.setQuery(query);
        return builder;
    }

    default public HttpRequest getHttpRequest(HttpRequest httpRequest, UrlBuilder builder, Method method, HttpConfig config, HttpHeader header) {
        HttpRequest request = httpRequest;
        if (null == request) {
            request = HttpRequest.of((UrlBuilder)builder);
        } else {
            request.setUrl(builder);
        }
        request.method(method);
        request.setProxy(config.getProxy());
        request.setConnectionTimeout(Math.toIntExact(config.getTimeout()));
        if (null != header) {
            request.addHeaders(header.getHeaders());
        }
        return request;
    }
}

