/*
 * Decompiled with CFR 0.152.
 */
package com.hippocp.easy.code.exception.aspect.advice;

import cn.hutool.core.util.StrUtil;
import javax.validation.ConstraintViolationException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindException;

@Aspect
@Component
public class ExceptionHandlerAdvice {
    private static final Logger log = LoggerFactory.getLogger(ExceptionHandlerAdvice.class);

    @Pointcut(value="@annotation(com.hippocp.easy.code.exception.aspect.annotation.ExceptionHandlerAble)")
    public void exceptionHandlerAblePointCut() {
    }

    @AfterThrowing(value="exceptionHandlerAblePointCut()", throwing="e")
    public void exceptionHandler(JoinPoint joinPoint, Exception e) {
        boolean isArgsValidateException;
        String osName = System.getProperty("os.name");
        boolean isWindowsOs = osName.toLowerCase().contains("windows");
        String newLine = "\n";
        if (isWindowsOs) {
            newLine = "\r\n";
        }
        StackTraceElement firstElement = e.getStackTrace()[0];
        String className = firstElement.getClassName();
        String methodName = firstElement.getMethodName();
        String exceptionLog = StrUtil.format((CharSequence)"\u7c7b [{}] \u65b9\u6cd5 [{}] \u51fa\u73b0\u5f02\u5e38\uff0c\u5f02\u5e38\u6458\u8981\uff1a{}", (Object[])new Object[]{className, methodName, e.getMessage()});
        StringBuilder argsMessage = new StringBuilder();
        Object[] args = joinPoint.getArgs();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        String[] argNames = methodSignature.getParameterNames();
        for (int i = 0; i < args.length; ++i) {
            String argLog = StrUtil.format((CharSequence)"\u53c2\u6570\u540d\uff1a{}\uff0c\u53c2\u6570\u503c\uff1a{}\u3002{}", (Object[])new Object[]{argNames[i], args[i], newLine});
            argsMessage.append(argLog);
        }
        boolean bl = isArgsValidateException = e instanceof BindException || e instanceof ConstraintViolationException;
        if (isArgsValidateException) {
            log.warn(exceptionLog);
            log.warn(argsMessage.toString());
        } else {
            log.error(exceptionLog);
            log.error(argsMessage.toString());
        }
    }
}

