/*
 * Decompiled with CFR 0.152.
 */
package com.hippocp.easy.code.exception.handler;

import cn.hutool.core.util.StrUtil;
import com.hippocp.easy.code.domain.response.CreateResponseWrapper;
import com.hippocp.easy.code.domain.response.ErrorCodeEnum;
import com.hippocp.easy.code.domain.response.ResponseWrapper;
import com.hippocp.easy.code.domain.validate.ConstraintError;
import com.hippocp.easy.code.exception.config.ExceptionHandlerProperties;
import com.hippocp.easy.code.util.parse.ConstraintErrorParseUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler
implements Ordered {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ExceptionHandlerProperties exceptionHandlerProperties;

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public ResponseWrapper<String> httpRequestMethodNotSupportedExceptionHandler(HttpRequestMethodNotSupportedException e) {
        String requestMethod = e.getMethod();
        Object[] supportedMethods = e.getSupportedMethods();
        String message = StrUtil.format((CharSequence)"\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u652f\u6301\uff0c\u5f53\u524d\u8bf7\u6c42\u65b9\u6cd5\u4e3a {}\uff0c\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u6cd5\u5982\u4e0b\uff1a{}", (Object[])new Object[]{requestMethod, Arrays.toString(supportedMethods)});
        this.logger.warn(message, (Throwable)e);
        return CreateResponseWrapper.requestFailedReturnErrorCodeMessage((ErrorCodeEnum)ErrorCodeEnum.USER_REQUEST_PARAMETER_ERROR, (String)message);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public ResponseWrapper<String> httpMessageNotReadableExceptionHandler(HttpMessageNotReadableException e) {
        String message = "\u7f3a\u5c11\u6240\u9700\u7684\u8bf7\u6c42\u4f53";
        this.logger.warn(message, (Throwable)e);
        return CreateResponseWrapper.requestFailedReturnErrorCodeMessage((ErrorCodeEnum)ErrorCodeEnum.USER_REQUEST_PARAMETER_ERROR, (String)message);
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public ResponseWrapper<String> httpMediaTypeNotSupportedExceptionHandler(HttpMediaTypeNotSupportedException e) {
        MediaType contentType = e.getContentType();
        String typeStr = Objects.toString(contentType);
        String message = StrUtil.format((CharSequence)"\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u652f\u6301\uff0c\u5f53\u524d\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e3a {}", (Object[])new Object[]{typeStr});
        this.logger.warn(message, (Throwable)e);
        return CreateResponseWrapper.requestFailedReturnErrorCodeMessage((ErrorCodeEnum)ErrorCodeEnum.USER_REQUEST_PARAMETER_ERROR, (String)message);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public ResponseWrapper<String> missingServletRequestParameterExceptionHandler(MissingServletRequestParameterException e) {
        String parameterName = e.getParameterName();
        String parameterType = e.getParameterType();
        String message = StrUtil.format((CharSequence)"\u5fc5\u9700\u7684\u53c2\u6570 {} \u4e0d\u5b58\u5728\uff08\u7c7b\u578b {}\uff09", (Object[])new Object[]{parameterName, parameterType});
        this.logger.warn(message, (Throwable)e);
        return CreateResponseWrapper.requestFailedReturnErrorCodeMessage((ErrorCodeEnum)ErrorCodeEnum.USER_REQUEST_PARAMETER_ERROR, (String)message);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public ResponseWrapper<String> noHandlerFoundExceptionHandler(NoHandlerFoundException e, HttpServletRequest request) {
        String requestURI = request.getRequestURI();
        String message = StrUtil.format((CharSequence)"\u63a5\u53e3 [{}] \u4e0d\u5b58\u5728", (Object[])new Object[]{requestURI});
        this.logger.warn(message, (Throwable)e);
        return CreateResponseWrapper.requestFailedReturnErrorCodeMessage((ErrorCodeEnum)ErrorCodeEnum.USER_REQUEST_PARAMETER_ERROR, (String)message);
    }

    @ExceptionHandler(value={BindException.class})
    public ResponseWrapper<List<ConstraintError>> bindExceptionHandler(BindException exception) {
        BindingResult bindingResult = exception.getBindingResult();
        List list = ConstraintErrorParseUtil.getConstraintError((BindingResult)bindingResult);
        String log = ConstraintErrorParseUtil.buildLogMessage((List)list);
        this.logger.warn("\u6355\u6349\u5230 BindException \u5f02\u5e38");
        this.logger.warn(log);
        return CreateResponseWrapper.requestFailedReturnErrorCodeMessageData((ErrorCodeEnum)ErrorCodeEnum.USER_REQUEST_PARAMETER_ERROR, (Object)list);
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public ResponseWrapper<List<ConstraintError>> methodArgumentNotValidExceptionHandler(MethodArgumentNotValidException exception) {
        BindingResult bindingResult = exception.getBindingResult();
        List list = ConstraintErrorParseUtil.getConstraintError((BindingResult)bindingResult);
        String log = ConstraintErrorParseUtil.buildLogMessage((List)list);
        this.logger.warn("\u6355\u6349\u5230 MethodArgumentNotValidException \u5f02\u5e38");
        this.logger.warn(log);
        return CreateResponseWrapper.requestFailedReturnErrorCodeMessageData((ErrorCodeEnum)ErrorCodeEnum.USER_REQUEST_PARAMETER_ERROR, (Object)list);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseWrapper<List<ConstraintError>> constraintViolationExceptionHandler(ConstraintViolationException exception) {
        Set constraintViolations = exception.getConstraintViolations();
        List list = ConstraintErrorParseUtil.getConstraintError((Set)constraintViolations);
        String log = ConstraintErrorParseUtil.buildLogMessage((List)list);
        this.logger.warn("\u6355\u6349\u5230 ConstraintViolationException \u5f02\u5e38");
        this.logger.warn(log);
        return CreateResponseWrapper.requestFailedReturnErrorCodeMessageData((ErrorCodeEnum)ErrorCodeEnum.USER_REQUEST_PARAMETER_ERROR, (Object)list);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseWrapper<String> exceptionHandler(Exception exception, HttpServletRequest request, HandlerMethod handlerMethod) {
        String logMessage;
        String requestURI = request.getRequestURI();
        String message = StrUtil.format((CharSequence)"\u63a5\u53e3 [{}] \u5185\u90e8\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (Object[])new Object[]{requestURI});
        String exceptionMessage = exception.getMessage();
        if (handlerMethod != null) {
            String className = handlerMethod.getBean().getClass().getName();
            String methodName = handlerMethod.getMethod().getName();
            logMessage = StrUtil.format((CharSequence)"\u63a5\u53e3 [{}] \u51fa\u73b0\u5f02\u5e38\uff0c\u65b9\u6cd5\uff1a{}.{}\uff0c\u5f02\u5e38\u6458\u8981\uff1a{}", (Object[])new Object[]{requestURI, className, methodName, exceptionMessage});
        } else {
            logMessage = exceptionMessage;
        }
        this.logger.error(logMessage, (Throwable)exception);
        return CreateResponseWrapper.requestFailedReturnErrorCodeMessage((ErrorCodeEnum)ErrorCodeEnum.SYSTEM_RUN_ERROR, (String)message);
    }

    public void serviceExceptionHandler() {
    }

    public int getOrder() {
        return this.exceptionHandlerProperties.getGlobalExceptionHandlerOrder();
    }
}

