/*
 * Decompiled with CFR 0.152.
 */
package com.hippocp.easy.code.validate.internal.constraintvalidators.bv.excel;

import cn.hutool.core.util.ArrayUtil;
import com.hippocp.easy.code.util.file.MultipartFileUtil;
import com.hippocp.easy.code.validate.constraints.EqualsExtensionName;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import org.springframework.web.multipart.MultipartFile;

public class EqualsExtensionNameForMultipartFile
implements ConstraintValidator<EqualsExtensionName, MultipartFile> {
    private String[] extensionNames;

    public void initialize(EqualsExtensionName parameters) {
        this.extensionNames = parameters.extensionNames();
    }

    public boolean isValid(MultipartFile multipartFile, ConstraintValidatorContext context) {
        if (multipartFile == null) {
            return true;
        }
        boolean equalsFileSuffix = MultipartFileUtil.isEqualsFileSuffix((MultipartFile)multipartFile, (String[])this.extensionNames);
        if (!equalsFileSuffix) {
            HibernateConstraintValidatorContext hibernateContext = (HibernateConstraintValidatorContext)context.unwrap(HibernateConstraintValidatorContext.class);
            String arrayJoin = ArrayUtil.join((Object[])this.extensionNames, (CharSequence)" ");
            hibernateContext.addExpressionVariable("extensionNameRightHint", (Object)arrayJoin);
        }
        return equalsFileSuffix;
    }
}

