/*
 * Decompiled with CFR 0.152.
 */
package com.hippocp.easy.code.validate.internal.constraintvalidators.bv.excel;

import cn.hutool.core.util.ArrayUtil;
import com.hippocp.easy.code.util.excel.ExcelValidateUtil;
import com.hippocp.easy.code.validate.constraints.EqualsExcelTitle;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import org.springframework.web.multipart.MultipartFile;

public class ExcelTitleEqualsForMultipartFile
implements ConstraintValidator<EqualsExcelTitle, MultipartFile> {
    private String[] excelTitles;

    public void initialize(EqualsExcelTitle parameters) {
        this.excelTitles = parameters.excelTitles();
    }

    public boolean isValid(MultipartFile multipartFile, ConstraintValidatorContext context) {
        if (multipartFile == null) {
            return true;
        }
        boolean excelTitleEquals = ExcelValidateUtil.excelTitleEquals((MultipartFile)multipartFile, (String[])this.excelTitles);
        if (!excelTitleEquals) {
            HibernateConstraintValidatorContext hibernateContext = (HibernateConstraintValidatorContext)context.unwrap(HibernateConstraintValidatorContext.class);
            hibernateContext.disableDefaultConstraintViolation();
            String arrayJoin = ArrayUtil.join((Object[])this.excelTitles, (CharSequence)"\uff0c");
            String msgTemplate = "Excel\u8868\u683c\u7b2c{excelTitleRowNum}\u884c\u6807\u9898\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u8bf7\u6ce8\u610f\u68c0\u67e5\u6807\u9898\u662f\u5426\u5305\u542b\u7a7a\u767d\u5b57\u7b26\u4f8b\u5982\uff1a\u7a7a\u683c\u3001\u5236\u8868\u7b26\u3001\u6362\u884c\u7b26\u7b49\uff0c\u6b63\u786e\u8868\u683c\u6807\u9898\u5982\u4e0b\uff1a${excelTitleRightHint}";
            hibernateContext.addExpressionVariable("excelTitleRightHint", (Object)arrayJoin).buildConstraintViolationWithTemplate(msgTemplate).addConstraintViolation();
        }
        return excelTitleEquals;
    }
}

