/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dataloader.guice;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.MoreTypes;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Names;
import com.google.inject.servlet.ServletScopes;
import com.hubspot.dataloader.guice.DataLoaderWrapper;
import com.hubspot.dataloader.guice.TypedBindingBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.UUID;
import org.dataloader.BatchLoader;
import org.dataloader.DataLoader;
import org.dataloader.MappedBatchLoader;

public class DataLoaderBinder {
    private static final TypeResolver TYPE_RESOLVER = new TypeResolver();
    private final Binder binder;
    private final MapBinder<String, DataLoader> mapBinder;

    private DataLoaderBinder(Binder binder) {
        this.binder = binder;
        this.mapBinder = MapBinder.newMapBinder((Binder)binder, String.class, DataLoader.class);
    }

    public static DataLoaderBinder newDataLoaderBinder(Binder binder) {
        return new DataLoaderBinder(binder);
    }

    public TypedBindingBuilder bindDataLoader(final String name) {
        return new TypedBindingBuilder(){

            @Override
            public DataLoaderBinder toBatchLoader(final Class<? extends BatchLoader> loaderClass) {
                Key requestScopedKey = Key.get((TypeLiteral)new TypeLiteral<DataLoader<?, ?>>(){}, (Annotation)Names.named((String)UUID.randomUUID().toString()));
                DataLoaderBinder.this.binder.bind(requestScopedKey).toProvider(new Provider<DataLoader<?, ?>>(){
                    @Inject
                    Injector injector;

                    public DataLoader<?, ?> get() {
                        return DataLoader.newDataLoader((BatchLoader)((BatchLoader)this.injector.getInstance(loaderClass)));
                    }
                }).in(ServletScopes.REQUEST);
                return this.addBindings(requestScopedKey, DataLoaderBinder.createKey(name, loaderClass, BatchLoader.class));
            }

            @Override
            public DataLoaderBinder toMappedBatchLoader(final Class<? extends MappedBatchLoader> loaderClass) {
                Key requestScopedKey = Key.get((TypeLiteral)new TypeLiteral<DataLoader<?, ?>>(){}, (Annotation)Names.named((String)UUID.randomUUID().toString()));
                DataLoaderBinder.this.binder.bind(requestScopedKey).toProvider(new Provider<DataLoader<?, ?>>(){
                    @Inject
                    Injector injector;

                    public DataLoader<?, ?> get() {
                        return DataLoader.newMappedDataLoader((MappedBatchLoader)((MappedBatchLoader)this.injector.getInstance(loaderClass)));
                    }
                }).in(ServletScopes.REQUEST);
                return this.addBindings(requestScopedKey, DataLoaderBinder.createKey(name, loaderClass, MappedBatchLoader.class));
            }

            private DataLoaderBinder addBindings(final Key<DataLoader<?, ?>> requestScopedKey, Key<DataLoader<?, ?>> singletonKey) {
                DataLoaderBinder.this.binder.bind(singletonKey).toProvider(new Provider<DataLoader<?, ?>>(){
                    @Inject
                    Injector injector;

                    public DataLoader<?, ?> get() {
                        Provider loaderProvider = this.injector.getProvider(requestScopedKey);
                        return DataLoaderWrapper.wrap(loaderProvider);
                    }
                }).in(Scopes.SINGLETON);
                DataLoaderBinder.this.mapBinder.addBinding((Object)name).to(requestScopedKey);
                return DataLoaderBinder.this;
            }
        };
    }

    private static Key<DataLoader<?, ?>> createKey(String name, Class<?> loaderImpl, Class<?> loaderType) {
        ResolvedType resolvedType = TYPE_RESOLVER.resolve(loaderImpl, new Type[0]);
        Type[] loaderParams = (Type[])resolvedType.typeParametersFor(loaderType).stream().map(DataLoaderBinder::convertResolvedType).toArray(Type[]::new);
        MoreTypes.ParameterizedTypeImpl dataLoaderType = new MoreTypes.ParameterizedTypeImpl(null, DataLoader.class, loaderParams);
        return Key.get((Type)dataLoaderType, (Annotation)Names.named((String)name));
    }

    private static Type convertResolvedType(ResolvedType resolvedType) {
        if (resolvedType.getTypeParameters().isEmpty()) {
            return resolvedType.getErasedType();
        }
        Type[] typeParameters = (Type[])resolvedType.getTypeParameters().stream().map(DataLoaderBinder::convertResolvedType).toArray(Type[]::new);
        return new MoreTypes.ParameterizedTypeImpl(null, (Type)resolvedType.getErasedType(), typeParameters);
    }
}

