/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.dataloader.guice;

import com.google.inject.Provider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.dataloader.DataLoader;
import org.dataloader.stats.Statistics;

public class DataLoaderWrapper<K, V>
extends DataLoader<K, V> {
    private final Provider<DataLoader<?, ?>> delegateProvider;

    private DataLoaderWrapper(Provider<DataLoader<?, ?>> delegateProvider) {
        super(key -> null);
        this.delegateProvider = delegateProvider;
    }

    public static <K, V> DataLoader<K, V> wrap(Provider<DataLoader<?, ?>> delegateProvider) {
        return new DataLoaderWrapper<K, V>(delegateProvider);
    }

    private DataLoader<K, V> delegate() {
        return (DataLoader)this.delegateProvider.get();
    }

    public CompletableFuture<V> load(K key) {
        return this.delegate().load(key);
    }

    public CompletableFuture<V> load(K key, Object keyContext) {
        return this.delegate().load(key, keyContext);
    }

    public CompletableFuture<List<V>> loadMany(List<K> keys) {
        return this.delegate().loadMany(keys);
    }

    public CompletableFuture<List<V>> loadMany(List<K> keys, List<Object> keyContexts) {
        return this.delegate().loadMany(keys, keyContexts);
    }

    public CompletableFuture<List<V>> dispatch() {
        return this.delegate().dispatch();
    }

    public List<V> dispatchAndJoin() {
        return this.delegate().dispatchAndJoin();
    }

    public int dispatchDepth() {
        return this.delegate().dispatchDepth();
    }

    public DataLoader<K, V> clear(K key) {
        return this.delegate().clear(key);
    }

    public DataLoader<K, V> clearAll() {
        return this.delegate().clearAll();
    }

    public DataLoader<K, V> prime(K key, V value) {
        return this.delegate().prime(key, value);
    }

    public DataLoader<K, V> prime(K key, Exception error) {
        return this.delegate().prime(key, error);
    }

    public Object getCacheKey(K key) {
        return this.delegate().getCacheKey(key);
    }

    public Statistics getStatistics() {
        return this.delegate().getStatistics();
    }
}

