/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery;

import com.huskycode.jpaquery.DependenciesDefinition;
import com.huskycode.jpaquery.command.CommandNodes;
import com.huskycode.jpaquery.crud.CreationPlanFromDefinition;
import com.huskycode.jpaquery.persister.PersisterImpl;
import com.huskycode.jpaquery.populator.RandomValuePopulator;
import com.huskycode.jpaquery.populator.RandomValuePopulatorImpl;
import com.huskycode.jpaquery.solver.SolverImpl;
import com.huskycode.jpaquery.types.tree.CreationPlan;
import com.huskycode.jpaquery.types.tree.PersistedResult;
import javax.persistence.EntityManager;

public class JPAQueryContext {
    private EntityManager entityManager;
    private RandomValuePopulator randomValuePopulator;
    private DependenciesDefinition dependenciesDefinition;

    private JPAQueryContext() {
    }

    static JPAQueryContext newInstance(EntityManager entityManager, DependenciesDefinition deps, RandomValuePopulator randomValuePopulator) {
        JPAQueryContext jpaContext = new JPAQueryContext();
        if (entityManager == null) {
            throw new IllegalArgumentException("Entity manager supplied cannot be null");
        }
        if (deps == null) {
            throw new IllegalArgumentException("Dependencies definition supplied cannot be null");
        }
        jpaContext.randomValuePopulator = randomValuePopulator;
        jpaContext.entityManager = entityManager;
        jpaContext.dependenciesDefinition = deps;
        return jpaContext;
    }

    public static JPAQueryContext newInstance(EntityManager entityManager, DependenciesDefinition deps) {
        return JPAQueryContext.newInstance(entityManager, deps, new RandomValuePopulatorImpl());
    }

    public <E> PersistedResult create(Class<E> entityClass) {
        SolverImpl solver = SolverImpl.newInstance(this.dependenciesDefinition);
        CreationPlan creationPlan = solver.solveFor(entityClass);
        PersisterImpl persister = PersisterImpl.newInstance(this.entityManager, this.dependenciesDefinition);
        return persister.persistValues(creationPlan);
    }

    public <E> PersistedResult create(CommandNodes commands) {
        SolverImpl solver = SolverImpl.newInstance(this.dependenciesDefinition);
        CreationPlan creationPlan = solver.solveFor(commands);
        PersisterImpl persister = PersisterImpl.newInstance(this.entityManager, this.dependenciesDefinition);
        return persister.persistValues(creationPlan);
    }

    public <E> PersistedResult createFromDependencyDefinition() {
        CreationPlanFromDefinition creator = CreationPlanFromDefinition.getInstance();
        PersisterImpl persister = PersisterImpl.newInstance(this.entityManager, this.dependenciesDefinition);
        return persister.persistValues(creator.from(this.dependenciesDefinition));
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public RandomValuePopulator getRandomValuePopulator() {
        return this.randomValuePopulator;
    }

    public DependenciesDefinition getDependenciesDefinition() {
        return this.dependenciesDefinition;
    }
}

