/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.persister;

import com.huskycode.jpaquery.DependenciesDefinition;
import com.huskycode.jpaquery.annotation.VisibleForTesting;
import com.huskycode.jpaquery.link.Link;
import com.huskycode.jpaquery.persister.Persister;
import com.huskycode.jpaquery.persister.entitycreator.EntityPersisterFactory;
import com.huskycode.jpaquery.persister.entitycreator.EntityPersisterFactoryImpl;
import com.huskycode.jpaquery.persister.store.PropogatedValueStore;
import com.huskycode.jpaquery.persister.util.BeanUtil;
import com.huskycode.jpaquery.populator.CreationPlanTraverser;
import com.huskycode.jpaquery.types.tree.CreationPlan;
import com.huskycode.jpaquery.types.tree.EntityNode;
import com.huskycode.jpaquery.types.tree.PersistedResult;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;

public class PersisterImpl
implements Persister {
    private EntityManager em;
    private DependenciesDefinition deps;
    private CreationPlanTraverser creationPlanTraverser = new CreationPlanTraverser();
    private EntityPersisterFactory entityPersisterFactory = new EntityPersisterFactoryImpl();

    @VisibleForTesting
    PersisterImpl(EntityManager em, DependenciesDefinition deps) {
        this.em = em;
        this.deps = deps;
    }

    public static PersisterImpl newInstance(EntityManager em, DependenciesDefinition deps) {
        PersisterImpl persisterImpl = new PersisterImpl(em, deps);
        return persisterImpl;
    }

    @Override
    public PersistedResult persistValues(CreationPlan plan) {
        ArrayList<Object> objects = new ArrayList<Object>();
        PropogatedValueStore<EntityNode, Field, Object> valueStore = PropogatedValueStore.newInstance();
        for (EntityNode node : this.creationPlanTraverser.getEntityNodes(plan)) {
            Map<Field, Object> overrideFields = this.getOverrideFields(node, valueStore);
            Object obj = this.entityPersisterFactory.createEntityPersister(node, this.deps, this.em).persistNode(node, overrideFields);
            objects.add(obj);
            this.storeFieldValueToPopulate(obj, node, valueStore);
        }
        return PersistedResult.newInstance(objects);
    }

    private Map<Field, Object> getOverrideFields(EntityNode node, PropogatedValueStore<EntityNode, Field, Object> valueStore) {
        HashMap<Field, Object> overrideFields = new HashMap<Field, Object>();
        if (node.getCommand() != null) {
            overrideFields.putAll(node.getCommand().getFieldValues());
        }
        overrideFields.putAll(valueStore.get(node));
        return overrideFields;
    }

    private void storeFieldValueToPopulate(Object obj, EntityNode parent, PropogatedValueStore<EntityNode, Field, Object> valueStore) {
        for (EntityNode child : parent.getChilds()) {
            List<Link<?, ?, ?>> links = this.deps.getDependencyLinks(child.getEntityClass(), parent.getEntityClass());
            for (Link<?, ?, ?> link : links) {
                Field parentField = link.getTo().getField();
                valueStore.putValue(child, link.getFrom().getField(), BeanUtil.getValue(obj, parentField));
            }
        }
    }
}

