/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.populator;

import com.huskycode.jpaquery.populator.CannotSetValueException;
import com.huskycode.jpaquery.populator.RandomValuePopulator;
import com.huskycode.jpaquery.util.Randomizer;
import com.huskycode.jpaquery.util.RandomizerImpl;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.metamodel.SingularAttribute;

public class RandomValuePopulatorImpl
implements RandomValuePopulator {
    private Randomizer randomizer;

    RandomValuePopulatorImpl(Randomizer randomizer) {
        this.randomizer = randomizer;
    }

    public RandomValuePopulatorImpl() {
        this(new RandomizerImpl());
    }

    @Override
    public <E> void populateValue(E entity) {
        List<Field> allFields = this.getAllFieldsInHierarchy(entity);
        for (Field f : allFields) {
            if ((f.getModifiers() & 0x10) == 16) continue;
            try {
                this.setRandomValue(entity, f);
            }
            catch (IllegalAccessException e) {
                throw new CannotSetValueException(e);
            }
        }
    }

    private <E> List<Field> getAllFieldsInHierarchy(E entity) {
        LinkedList working = new LinkedList();
        LinkedList<Field> allFields = new LinkedList<Field>();
        working.add(entity.getClass());
        while (working.size() > 0) {
            Field[] fields;
            Class c = (Class)working.poll();
            Class sper = c.getSuperclass();
            if (c.getSuperclass() != null) {
                working.add(sper);
            }
            for (Field f : fields = c.getDeclaredFields()) {
                allFields.add(f);
            }
        }
        return allFields;
    }

    public <E, T> void setRandomValue(E entity, Field field) throws IllegalAccessException {
        field.setAccessible(true);
        int length = 0;
        if (field.getType().equals(String.class) && field.isAnnotationPresent(Column.class)) {
            Column anno = field.getAnnotation(Column.class);
            length = anno.length();
        }
        this.setValue(entity, field, this.randomizer.getRandomOfType(field.getType(), length));
    }

    private <E, T> void setValue(E entity, Field field, T value) throws IllegalAccessException {
        field.set(entity, value);
    }

    private <E, T> T getValue(E entity, Field field) throws IllegalAccessException {
        return (T)field.get(entity);
    }

    private <E, T> void setRandomValue(E entity, SingularAttribute<?, T> field) {
        this.setValue(entity, field, this.randomizer.getRandomOfType(field.getJavaType()));
    }

    private <E, T> void setValue(E entity, SingularAttribute<?, T> field, T value) {
        block3: {
            try {
                Member member = field.getJavaMember();
                if (member instanceof Method) break block3;
                if (member instanceof Field) {
                    ((Field)member).set(entity, value);
                    break block3;
                }
                throw new IllegalArgumentException("Unexpected java member type. Expecting method or field, found: " + member);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private <E, T> T getValue(E entity, SingularAttribute<?, T> field) {
        try {
            Member member = field.getJavaMember();
            if (member instanceof Method) {
                return (T)((Method)member).invoke(entity, new Object[0]);
            }
            if (member instanceof Field) {
                return (T)((Field)member).get(entity);
            }
            throw new IllegalArgumentException("Unexpected java member type. Expecting method or field, found: " + member);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

