/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.solver;

import com.huskycode.jpaquery.util.MapUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DirectedGraph<T> {
    Map<NodeWarper<T>, Set<NodeWarper<T>>> childrenMap = new HashMap<NodeWarper<T>, Set<NodeWarper<T>>>();
    Map<NodeWarper<T>, Set<NodeWarper<T>>> parentMap = new HashMap<NodeWarper<T>, Set<NodeWarper<T>>>();
    Set<NodeWarper<T>> allNodes = new HashSet<NodeWarper<T>>();
    Map<NodeWarper<T>, NodeWarper<T>> actualNodesMap = new HashMap<NodeWarper<T>, NodeWarper<T>>();

    private DirectedGraph() {
    }

    public static <T> DirectedGraph<T> newInstance() {
        return new DirectedGraph<T>();
    }

    public void addNode(T node) {
        this.allNodes.add(this.getOrCreateNode(node));
    }

    public void addRelation(T from, T to) {
        NodeWarper<T> child = this.getOrCreateNode(from);
        NodeWarper<T> parent = this.getOrCreateNode(to);
        MapUtil.getOrCreateSet(this.childrenMap, parent).add(child);
        MapUtil.getOrCreateSet(this.parentMap, child).add(parent);
        this.allNodes.add(child);
        this.allNodes.add(parent);
    }

    public void computeNodeLevel() {
        int max = this.allNodes.size();
        int count = 0;
        while (count++ < max) {
            boolean noChange = true;
            for (NodeWarper<T> node : this.parentMap.keySet()) {
                int maxParentLevel = this.getMaxLevelOfParent(node);
                int toBeNodeLevel = maxParentLevel + 1;
                if (toBeNodeLevel <= node.getLevel()) continue;
                node.setLevel(toBeNodeLevel);
                noChange = false;
            }
            if (!noChange) continue;
            break;
        }
    }

    private NodeWarper<T> getOrCreateNode(T t) {
        NodeWarper<T> key = NodeWarper.newInstance(t);
        NodeWarper<T> value = this.actualNodesMap.get(key);
        if (value == null) {
            value = key;
            this.actualNodesMap.put(key, value);
        }
        return value;
    }

    public List<T> getInorderNodeAscendent() {
        Comparator comparator = NodeComparatorAsc.getInstance();
        return this.getInorderNode(comparator);
    }

    public List<T> getInorderNodeDescendent() {
        Comparator comparator = NodeComparatorDesc.getInstance();
        return this.getInorderNode(comparator);
    }

    private List<T> getInorderNode(Comparator<Node<T>> comparator) {
        NodeWarper[] arrayData = this.allNodes.toArray(new NodeWarper[0]);
        Arrays.sort(arrayData, comparator);
        return this.toList(arrayData);
    }

    private int getMaxLevelOfParent(NodeWarper<T> node) {
        int max = -1;
        for (NodeWarper<T> parent : this.parentMap.get(node)) {
            if (max >= parent.getLevel()) continue;
            max = parent.getLevel();
        }
        return max;
    }

    private List<T> toList(NodeWarper<T>[] data) {
        ArrayList<T> result = new ArrayList<T>(data.length);
        for (NodeWarper<T> node : data) {
            result.add(node.get());
        }
        return result;
    }

    private static class NodeWarper<T>
    implements Node<T> {
        private T instance;
        private int level;

        private NodeWarper(T t) {
            this.instance = t;
        }

        public static <T> NodeWarper<T> newInstance(T t) {
            return new NodeWarper<T>(t);
        }

        @Override
        public T get() {
            return this.instance;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        public int hashCode() {
            return this.instance.hashCode();
        }

        public String toString() {
            return "NodeWarper [instance=" + this.instance + ", level=" + this.level + "]";
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NodeWarper other = (NodeWarper)obj;
            return this.instance == other.instance;
        }
    }

    static interface Node<T> {
        public int getLevel();

        public T get();
    }

    private static class NodeComparatorDesc<T>
    implements Comparator<Node<T>> {
        private static final NodeComparatorDesc INSTANCE = new NodeComparatorDesc();

        private NodeComparatorDesc() {
        }

        public static final <T> Comparator<Node<T>> getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(Node<T> o1, Node<T> o2) {
            Comparator<Node<Node<T>>> ascComparator = NodeComparatorAsc.getInstance();
            return -ascComparator.compare(o1, o2);
        }
    }

    private static class NodeComparatorAsc<T>
    implements Comparator<Node<T>> {
        private static final NodeComparatorAsc INSTANCE = new NodeComparatorAsc();

        private NodeComparatorAsc() {
        }

        public static final <T> Comparator<Node<T>> getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(Node<T> o1, Node<T> o2) {
            return o1.getLevel() - o2.getLevel();
        }
    }

    private static class NodeComparatorWithTieBreaker<T>
    implements Comparator<Node<T>> {
        private Comparator<Node<T>> theCompator;
        private Comparator<T> theTieBreaker;

        private NodeComparatorWithTieBreaker(Comparator<Node<T>> theCompator, Comparator<T> theTieBreaker) {
            this.theCompator = theCompator;
            this.theTieBreaker = theTieBreaker;
        }

        public static <T> NodeComparatorWithTieBreaker<T> newInstance(Comparator<Node<T>> theCompator, Comparator<T> theTieBreaker) {
            return new NodeComparatorWithTieBreaker<T>(theCompator, theTieBreaker);
        }

        @Override
        public int compare(Node<T> o1, Node<T> o2) {
            int value = this.theCompator.compare(o1, o2);
            if (value == 0) {
                value = this.theTieBreaker.compare(o1.get(), o2.get());
            }
            return value;
        }
    }
}

