/*
 * Decompiled with CFR 0.152.
 */
package com.huskycode.jpaquery.solver;

import com.huskycode.jpaquery.DependenciesDefinition;
import com.huskycode.jpaquery.command.CommandNode;
import com.huskycode.jpaquery.command.CommandNodeFactory;
import com.huskycode.jpaquery.command.CommandNodes;
import com.huskycode.jpaquery.command.CommandNodesFactory;
import com.huskycode.jpaquery.persister.store.InstanceValueStore;
import com.huskycode.jpaquery.persister.store.InstanceWrapper;
import com.huskycode.jpaquery.persister.store.PropogatedValueStore;
import com.huskycode.jpaquery.solver.CommandInterpretor;
import com.huskycode.jpaquery.solver.CommandPlan;
import com.huskycode.jpaquery.solver.InOrderEntityData;
import com.huskycode.jpaquery.solver.InvalidCommandHierarchy;
import com.huskycode.jpaquery.solver.Solver;
import com.huskycode.jpaquery.types.tree.ActionGraph;
import com.huskycode.jpaquery.types.tree.CreationPlan;
import com.huskycode.jpaquery.types.tree.EntityNode;
import com.huskycode.jpaquery.util.CollectionUtil;
import com.huskycode.jpaquery.util.Factory;
import com.huskycode.jpaquery.util.MapUtil;
import com.huskycode.jpaquery.util.ValueStore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SolverImpl
implements Solver {
    private CommandInterpretor commandInterpretor = CommandInterpretor.getInstance();
    private DependenciesDefinition deps;

    private SolverImpl(DependenciesDefinition deps) {
        this.deps = deps;
    }

    public static SolverImpl newInstance(DependenciesDefinition deps) {
        return new SolverImpl(deps);
    }

    @Override
    @Deprecated
    public <E> CreationPlan solveFor(Class<E> entityClass) {
        CommandNodeFactory.CommandNodeImpl command = CommandNodeFactory.n(entityClass, new CommandNode[0]);
        return this.solveFor(CommandNodesFactory.ns(command));
    }

    @Override
    public <E> CreationPlan solveFor(CommandNodes commands) {
        ActionGraph actionGraph = this.createActionGraph(commands);
        return CreationPlan.newInstance(actionGraph);
    }

    protected ActionGraph createActionGraph(CommandNodes commands) {
        ActionGraph actionGraph = ActionGraph.newInstance();
        CommandPlan plan = this.commandInterpretor.createPlan(commands, this.deps);
        this.createActionGraph(plan, actionGraph);
        return actionGraph;
    }

    private void createActionGraph(CommandPlan plan, ActionGraph actionGraph) {
        PropogatedValueStore<CommandNode, Class<?>, EntityNode> context = PropogatedValueStore.newInstance();
        InstanceValueStore<CommandNode, ListIterator<Class<?>>> commandNodeIteratorMap = InstanceValueStore.newInstance();
        DummyEntityContainer dummyContainer = DummyEntityContainer.newInstance(this.deps);
        HashMap<ContextKey, EntityNode> instanceContainer = new HashMap<ContextKey, EntityNode>();
        InOrderEntityData inOrderEntityData = plan.getInOrderEntityData();
        EntityListIteratorFactory entityListIteratorFactory = EntityListIteratorFactory.newInstance(inOrderEntityData.getInOrderEntityList());
        for (CommandNode currentCommand : plan.getPlan()) {
            EntityNode thisNode;
            Set<Class<?>> parents;
            ListIterator entityClassIterator = (ListIterator)MapUtil.getOrCreate(commandNodeIteratorMap, currentCommand, entityListIteratorFactory);
            Class currentEntityClass = (Class)entityClassIterator.getCurrent();
            Map<Class<?>, EntityNode> currentContext = context.get(currentCommand);
            while (!currentCommand.getEntity().equals(currentEntityClass)) {
                parents = this.getDirectParentDependency(currentEntityClass);
                if (parents.size() == 0 || !CollectionUtil.containAny(parents, currentContext.keySet())) {
                    if (!dummyContainer.contain(currentEntityClass) && this.shouldCreate(currentEntityClass, currentCommand, context)) {
                        thisNode = dummyContainer.create(currentEntityClass);
                        actionGraph.addEntityNode(thisNode);
                    }
                } else if (!currentContext.keySet().contains(currentEntityClass)) {
                    ContextKey key = this.createContextKey(currentEntityClass, currentContext, dummyContainer);
                    EntityNode thisNode2 = (EntityNode)instanceContainer.get(key);
                    if (thisNode2 == null) {
                        thisNode2 = this.createEntityNodeAndUpdateContext(currentEntityClass, currentContext, dummyContainer);
                        actionGraph.addEntityNode(thisNode2);
                        instanceContainer.put(key, thisNode2);
                    }
                    currentContext.put(currentEntityClass, thisNode2);
                } else {
                    throw new InvalidCommandHierarchy("Context contain the entity before it expects");
                }
                if (entityClassIterator.hasNext()) {
                    currentEntityClass = (Class)entityClassIterator.next().getCurrent();
                    continue;
                }
                throw new InvalidCommandHierarchy(currentCommand.toString());
            }
            parents = this.getDirectParentDependency(currentEntityClass);
            if (!currentCommand.getEntity().equals(currentEntityClass)) continue;
            thisNode = this.createEntityNodeAndUpdateContext(currentCommand, currentContext, dummyContainer, parents);
            actionGraph.addEntityNode(thisNode);
            this.updateChildrenIterator(currentCommand.getChildren(), entityClassIterator, commandNodeIteratorMap);
            this.updateChildrenContext(currentCommand.getChildren(), currentContext, context);
        }
    }

    private boolean shouldCreate(Class<?> currentEntity, CommandNode command, PropogatedValueStore<CommandNode, Class<?>, EntityNode> context) {
        if (command.getChildren().size() > 0) {
            for (CommandNode child : command.getChildren()) {
                if (context.get(child).keySet().contains(currentEntity)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private Set<Class<?>> getDirectParentDependency(Class<?> currentEntityClass) {
        return this.deps.getDirectParentDependencyEntity(currentEntityClass);
    }

    private ContextKey createContextKey(Class<?> currentEntityClass, Map<Class<?>, EntityNode> context, DummyEntityContainer dummyContainer) {
        ContextKey key = ContextKey.newInstance(currentEntityClass);
        for (Class<?> parent : this.getDirectParentDependency(currentEntityClass)) {
            EntityNode parentNode = context.get(parent);
            if (parentNode == null) {
                parentNode = dummyContainer.getDummyEntity(parent);
            }
            key.addEntityNode(parentNode);
        }
        return key;
    }

    private void updateChildrenContext(List<CommandNode> children, Map<Class<?>, EntityNode> parentContext, PropogatedValueStore<CommandNode, Class<?>, EntityNode> context) {
        for (CommandNode child : children) {
            for (Map.Entry<Class<?>, EntityNode> entry : parentContext.entrySet()) {
                Map<Class<?>, EntityNode> childContext = context.get(child);
                if (childContext.containsKey(entry.getKey())) continue;
                childContext.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private void updateChildrenIterator(List<CommandNode> children, ListIterator<Class<?>> entityClassIterator, ValueStore<CommandNode, ListIterator<Class<?>>> commandNodeIteratorMap) {
        ((ListIterator)entityClassIterator).next();
        for (CommandNode child : children) {
            ListIterator<Class<?>> childItr = commandNodeIteratorMap.get(child);
            if (childItr == null) {
                commandNodeIteratorMap.putValue(child, ListIterator.copy(entityClassIterator));
                continue;
            }
            childItr.updateLatest(entityClassIterator);
        }
    }

    private EntityNode createEntityNodeAndUpdateContext(Class<?> entityClass, Map<Class<?>, EntityNode> context, DummyEntityContainer dummyContainer) {
        EntityNode thisNode = EntityNode.newInstance(entityClass);
        this.linkDependency(thisNode, context, dummyContainer);
        context.put(entityClass, thisNode);
        return thisNode;
    }

    private EntityNode createEntityNodeAndUpdateContext(CommandNode command, Map<Class<?>, EntityNode> context, DummyEntityContainer dummyContainer, Set<Class<?>> parents) {
        EntityNode thisNode = this.createEntityNodeAndUpdateContext(command.getEntity(), context, dummyContainer);
        thisNode.setCommand(command);
        return thisNode;
    }

    private void linkDependency(EntityNode thisNode, Map<Class<?>, EntityNode> context, DummyEntityContainer dummyContainer) {
        for (Class<?> entityClass : this.getDirectParentDependency(thisNode.getEntityClass())) {
            EntityNode parentNode = context.get(entityClass);
            if (parentNode == null) {
                parentNode = dummyContainer.getDummyEntity(entityClass);
            }
            thisNode.addParent(parentNode);
            parentNode.addChild(thisNode);
        }
    }

    private static class ContextKey {
        private final Class<?> entityClass;
        private final List<InstanceWrapper<EntityNode>> entityNodes;

        private ContextKey(Class<?> entityClass) {
            this.entityClass = entityClass;
            this.entityNodes = new ArrayList<InstanceWrapper<EntityNode>>();
        }

        public static ContextKey newInstance(Class<?> entityClass) {
            return new ContextKey(entityClass);
        }

        public void addEntityNode(EntityNode node) {
            this.entityNodes.add(new InstanceWrapper<EntityNode>(node));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.entityClass == null ? 0 : this.entityClass.hashCode());
            result = 31 * result + (this.entityNodes == null ? 0 : ((Object)this.entityNodes).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContextKey other = (ContextKey)obj;
            if (this.entityClass == null ? other.entityClass != null : !this.entityClass.equals(other.entityClass)) {
                return false;
            }
            return !(this.entityNodes == null ? other.entityNodes != null : !((Object)this.entityNodes).equals(other.entityNodes));
        }
    }

    private static class ListIterator<T> {
        private java.util.ListIterator<T> itr;
        private List<T> list;
        private T current;
        private int currentIndex;

        private ListIterator(List<T> list, int index) {
            this.initialize(list, index);
        }

        private void initialize(List<T> list, int index) {
            this.list = list;
            this.itr = list.listIterator(index);
            this.next();
        }

        public static <T> ListIterator<T> of(List<T> list) {
            return new ListIterator<T>(list, 0);
        }

        public static <T> ListIterator<T> copy(ListIterator<T> other) {
            return new ListIterator<T>(other.list, other.currentIndex);
        }

        public void updateLatest(ListIterator<T> other) {
            if (this.currentIndex < other.currentIndex) {
                this.initialize(this.list, other.currentIndex);
            }
        }

        public boolean hasNext() {
            return this.itr.hasNext();
        }

        private ListIterator<T> next() {
            try {
                this.currentIndex = this.itr.nextIndex();
                this.current = this.itr.next();
                return this;
            }
            catch (NoSuchElementException e) {
                this.current = null;
                return this;
            }
        }

        public T getCurrent() {
            return this.current;
        }
    }

    private static class DummyEntityContainer {
        private final Map<Class<?>, EntityNode> dummyContainer = new HashMap();
        private final DependenciesDefinition deps;

        private DummyEntityContainer(DependenciesDefinition deps) {
            this.deps = deps;
        }

        public static DummyEntityContainer newInstance(DependenciesDefinition deps) {
            return new DummyEntityContainer(deps);
        }

        public EntityNode create(Class<?> entityClass) {
            EntityNode result = this.dummyContainer.get(entityClass);
            if (result == null) {
                result = EntityNode.newInstance(entityClass);
                this.linkDependency(result);
                this.dummyContainer.put(entityClass, result);
            }
            return result;
        }

        public boolean contain(Class<?> entityClass) {
            return this.dummyContainer.containsKey(entityClass);
        }

        public EntityNode getDummyEntity(Class<?> entityClass) {
            return this.dummyContainer.get(entityClass);
        }

        private void linkDependency(EntityNode thisNode) {
            for (Class<?> parent : this.deps.getDirectParentDependencyEntity(thisNode.getEntityClass())) {
                EntityNode parentNode = this.dummyContainer.get(parent);
                thisNode.addParent(parentNode);
                parentNode.addChild(thisNode);
            }
        }
    }

    private static class EntityListIteratorFactory
    implements Factory<ListIterator<Class<?>>> {
        private final List<Class<?>> plan;

        private EntityListIteratorFactory(List<Class<?>> plan) {
            this.plan = plan;
        }

        public static EntityListIteratorFactory newInstance(List<Class<?>> plan) {
            return new EntityListIteratorFactory(plan);
        }

        @Override
        public ListIterator<Class<?>> newInstace() {
            return ListIterator.of(this.plan);
        }
    }
}

